;+
; NAME:
;       blv_module_def_parameter
;
; PURPOSE:
;       This function creates a modal widget_base with all the element 
;		necessary to initialise
;		an optic_system object, and then return a structure with 
;		all the information of the widget
;
; CATEGORY:
;	BLViewer
;
; CALLING SEQUENCE:
;       Data=blv_module_def_parameter(Parent, DIM=dim)
;
; INPUTS:
;       Parent: a widget_base.
;
; KEYWORD PARAMETERS:
;		Dim: a structur with all the element necessary to 
;		initialise the field of the widget
;
; EXAMPLE
;		       Data=blv_module_def_parameter(Parent, DIM=dim)
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-

PRO blv_module_def_parameter_event,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_def_parameter_event: error caught: '+!error_state.msg)
   RETURN
ENDIF



Widget_Control,event.id, Get_UValue=uvalue

CASE uValue OF
	'cancel_symbol_event': BEGIN
		; PURPOSE: to destroy the widget
		widget_control, event.top, /destroy
		END
	'ok_optical_module_event': BEGIN
		; PURPOSE: to modify the structure to return and destroy the widget
		widget_control, event.top, get_uvalue=info
		widget_control, info.rlen1ID, get_value=rlen1
		widget_control, info.rlen2ID, get_value=rlen2
		widget_control, info.rwidx1ID, get_value=rwidx1
		widget_control, info.rwidx2ID, get_value=rwidx2
		widget_control, info.profID, get_value=prof
		widget_control, info.t_sourceID, get_value=t_source
		widget_control, info.t_imageID, get_value=t_image
		widget_control, info.t_incidenceID, get_value=t_incidence
		widget_control, info.t_reflectionID, get_value=t_reflection
		widget_control, info.alphaID, get_value=alpha
;srio		widget_control, info.file_nameID, get_value=file_name
		
		(*(info.ptr)).ok=1
		(*(info.ptr)).rlen1=rlen1
		(*(info.ptr)).rlen2=rlen2
		(*(info.ptr)).rwidx1=rwidx1
		(*(info.ptr)).rwidx2=rwidx2
		(*(info.ptr)).prof=prof
		(*(info.ptr)).t_source=t_source
		(*(info.ptr)).t_image=t_image
		(*(info.ptr)).t_incidence=t_incidence
		(*(info.ptr)).t_reflection=t_reflection
		(*(info.ptr)).alpha=alpha
;srio		(*(info.ptr)).file_name=file_name

		widget_control, event.top, /destroy
		END
	'type_name_event': BEGIN
		; PURPOSE: modify the type name in field and structur to return
		widget_control, event.top, get_uvalue=info
		(*(info.ptr)).type_name=info.list_type_name[event.index]

		sel_name = info.list_type_name[event.index]
		IF sel_name EQ 'External (VRML)' THEN BEGIN
		  file1 = (*(info.ptr)).mesh_file
		  IF file1 EQ 'undefined' THEN file2='' ELSE file2=file1
		  file3 = Dialog_Pickfile(Dialog_Parent=event.top, File=file2, Filter='*.wrl', $
			Title='Pleaseselect a VRML file with an external mesh')
		  IF file3 EQ '' THEN file3=file1
		  (*(info.ptr)).mesh_file=file3
		ENDIF

		END
	'change_color_event': BEGIN
		; PURPOSE: call the Get_RGB procedure and modify the structur tu return
		widget_control, event.top, get_uvalue=info
		data=Get_RGB(event.top, rgb=(*(info.ptr)).color)
		if data.ok eq 0 then return
		(*(info.ptr)).color=data.rgb
		END
	else: ; Print,'CASE uvalue not found: ',uValue
ENDCASE

END

;
;============================================================================================================
;
function blv_module_def_parameter, parent, Dim=dim

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_module_def_parameter: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


IF n_elements(dim) eq 0 THEN BEGIN
	dim=({ok:0, rwidx1:0.3, rwidx2:0.3, rlen1:0.3, rlen2:0.3, prof:0.03, $
			t_incidence:45., t_reflection:45., alpha:0.0, $
			t_source:10.0, t_image:10.0, $
			file_name:string(''), type_name:string('Rectangle'), mesh_file:string('undefined'), $
			color:[100,100,255]})
ENDIF

IF N_Elements(parent) EQ 0 THEN parent=0L
IF Widget_Info(parent,/Valid) THEN  $
  base=widget_base(GROUP_LEADER=parent,/floating,/col,title="Opticsl Module parameters",/modal) ELSE $
  base=widget_base(/col,title="Optic Module's parameters") 

choice=widget_base(base,/row,/ALIGN_LEFT )
	ok=widget_button(choice, value='Accept', UValue='ok_optical_module_event')
	cancel=widget_button(choice, value='Cancel', UValue='cancel_symbol_event')

;srio list_type_name=[dim.type_name,'Rectangle','Ellipse','Ellipse with a hole','Infinite surface','External (VRML)']
list_type_name=['Rectangle','Ellipse','Ellipse with a hole','Infinite surface','External (VRML)']
type_name=widget_droplist(base, title='Type:', value=list_type_name, UValue='type_name_event')

commun_base=widget_base(base, /col,frame=1, /base_align_right)
	rwidx1ID=cw_field(commun_base,title=blv_var_title('Rwid1'),/floating,value=dim.rwidx1)
	rwidx2ID=cw_field(commun_base,title=blv_var_title('Rwid2'),/floating,value=dim.rwidx2)
	rlen1ID=cw_field(commun_base,title=blv_var_title('Rlen1'),/floating,value=dim.rlen1)
	rlen2ID=cw_field(commun_base,title=blv_var_title('Rlen2'),/floating,value=dim.rlen2)
	t_sourceID=cw_field(commun_base,title=blv_var_title('T_Source'),/floating,value=dim.t_source)
	t_imageID=cw_field(commun_base,title=blv_var_title('T_Image'),/floating,value=dim.t_image)
	t_incidenceID=cw_field(commun_base,title=blv_var_title('T_Incidence'),/floating,value=dim.t_incidence)
	t_reflectionID=cw_field(commun_base,title=blv_var_title('T_Reflection'),/floating,value=dim.t_reflection)
	alphaID=cw_field(commun_base,title=blv_var_title('Alpha'),/floating,value=dim.alpha)

new_base=widget_base(base, /col, /base_align_right, frame=1)
	profID=cw_field(new_base,title='Thickness [cm] :',/floating,value=dim.prof)
baseFile=widget_base(base,/row)
	; title_file=widget_text(baseFile,value='File: ',xsize=6)
	; file_nameID=widget_text(baseFile, value=dim.file_name)
	; srio (**confuses the user**) file_nameID = CW_PickFile(baseFile,Value=dim.file_name,UValue='changefile')
	  file_nameID=0L
but_color=widget_button(base, value='Color', UValue='change_color_event')
widget_control, base, /realize

;ptr=ptr_new({ok:0, rwidx1:0.0, rwidx2:0.0, rlen1:0.0, rlen2:0.0, prof:0.0, $
;			t_incidence:0.0, t_reflection:0.0, alpha:0.0, t_source:0.0, t_image:0.0, $
;			file_name:string(''), type_name:dim.type_name, mesh_file:dim.mesh_file, $
;			color:dim.color})

ptr = Ptr_New(dim)
info={ptr:ptr, $
	rwidx1ID:rwidx1ID, rwidx2ID:rwidx2ID, rlen1ID:rlen1ID, rlen2ID:rlen2ID, profID:profID, $
	t_sourceID:t_sourceID, t_imageID:t_imageID, $
	t_incidenceID:t_incidenceID, t_reflectionID:t_reflectionID, alphaID:alphaID, $
	file_nameID:file_nameID, list_type_name:list_type_name}

widget_control, base, set_uvalue=info

xmanager,'blv_module_def_parameter', base

dim_info=*ptr
ptr_free, ptr
return, dim_info
end



