;+
; NAME:
;       BLV_CUBE.
;
; PURPOSE:
;       This function return an IDLGrModel whith a transparenty cube.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       c=BLV_CUBE(larg, haut, prof)
;
; INPUTS:
;       larg: the wide of the cube./x
;		haut: hight./y
;		prof: depth./z
;
; KEYWORD PARAMETERS:
;		none
;
; EXAMPLE:;
;		  c=BLV_CUBE(larg, haut, prof)
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-


;*************surface definition*******
function surfaceForme, pPoint, n1,n2,n3,n4

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'surfaceForme: error caught: '+!error_state.msg)
   RETURN,0
ENDIF



x=[(*pPoint)[0,n1],(*pPoint)[0,n2],(*pPoint)[0,n3]]
y=[(*pPoint)[1,n1],(*pPoint)[1,n2],(*pPoint)[1,n3]]
z=[(*pPoint)[2,n1],(*pPoint)[2,n2],(*pPoint)[2,n3]]
if N_params() eq 5 then begin
	x=[x,(*pPoint)[0,n4]]
	y=[y,(*pPoint)[1,n4]]
	z=[z,(*pPoint)[2,n4]]
endif

color=[255,255,255]
poly=obj_new('idlgrPolygon',x,y,z,vert_color=color,style=1)
return, poly
end



;*************************************
;**************cube definition********
function blv_cube, larg, haut, prof


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_cube: error caught: '+!error_state.msg)
   RETURN,Ptr_New()
ENDIF



pPoint=ptr_new([[larg,-haut,prof],$
		[larg,-haut,-prof],$
		[-larg,-haut,-prof],$
		[-larg,-haut,prof],$
		[larg,haut,prof],$
		[larg,haut,-prof],$
		[-larg,haut,-prof],$
		[-larg,haut,prof]])
c=obj_new('idlgrmodel')
c->add, surfaceForme(pPoint,0,1,2,3)
c->add, surfaceForme(pPoint,4,5,6,7)
c->add, surfaceForme(pPoint,0,1,5,4)
c->add, surfaceForme(pPoint,2,3,7,6)
c->add, surfaceForme(pPoint,0,3,7,4)
c->add, surfaceForme(pPoint,1,2,6,5)
ptr_free, pPoint
return, c
end
