PRO plotccc,input,xmin,xmax,NPOINTS=npoints,write=write

;+
;
;       NAME:
;               PLOTCCC
;
;       PURPOSE:
;               This procedure makes a plot of the conic
;		calculated from the 10 coefficients in ccc
;
;       CATEGORY:
;               SHADOW tools
;
;       CALLING SEQUENCE:
;               plotccc,ccc,xmin,xmax
;
; 	INPUTS:
;		ccc: 10 conic coefficients, like the  output of 
;			conicset(). It may be a file containing the 
;			coefficients. Default is: coefficients from ccc.out
;		xmin, the min x for the plot (default=-200)
;		xmax, the max x for the plot (default=200)
;	
; 	KEYWORD PARAMETERS
;		NPOINTS:  number of abscisa points (default=1000)
;		WRITE:  A string containing the name of the output file
;		        where coefficients are written.
;
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu
;	
;	MODIFICATION HISTORY:
;		2009-09-29 written
;
;-
on_error,2
;

IF N_Elements(input) EQ 0 THEN input='ccc.out'
IF N_Elements(xmin) EQ 0 THEN xmin=-200
IF N_Elements(xmax) EQ 0 THEN xmax=-xmin
IF N_Elements(npoints) EQ 0 THEN npoints=1000


yy=makearray1(npoints,xmin,xmax)


IF N_Elements(input) EQ 10 THEN ccc=input ELSE ccc = rascii(input)

BB=ccc[4]*YY+ccc[8]
CC=ccc[1]*YY*YY+ccc[7]*YY+ccc[9]
xx_1 = (-BB+Sqrt(BB^2-4*ccc[2]*CC))/2/ccc[2] 
xx_2 = (-BB-Sqrt(BB^2-4*ccc[2]*CC))/2/ccc[2] 

tmp = make_set(yy,xx_1,xx_2)
xplot,tmp,coltitles=['y','curve1','curve2']

IF N_Elements(write) NE 0 THEN BEGIN
  openw,unit,write,/get_lun
  For i=0,9 DO printf,unit,ccc[i]
  Free_Lun,unit
  print,'File written to disk: '+write
ENDIF

END
