; 
;===============================================================================
;
Pro xshoe_f_ripple,oestr,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_F_RIPPLE: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')

titles=[ 'Type of defect',$
  'File-name',$
  'Ripple Wavel. X',$
  'Ripple Wavel. Y',$
  'Ripple Ampli. X',$
  'Ripple Ampli. Y',$
  'Ripple Phase X',$
  'Ripple Phase Y']

flags = replicate('1',n_elements(titles))
flags[1] = 'w(0) GE 1'
flags[2:7] = 'w(0) EQ 0'
 
tmp =    { F_G_S:[strcompress(oestr.F_G_S,/rem),'sinusoidal','gaussian',$
		'external spline'],$
   FILE_RIP:oestr.FILE_RIP, $
   X_RIP_WAV:oestr.X_RIP_WAV, $
   Y_RIP_WAV:oestr.Y_RIP_WAV, $
   X_RIP_AMP:oestr.X_RIP_AMP, $
   Y_RIP_AMP:oestr.Y_RIP_AMP, $
   X_PHASE:oestr.X_PHASE, $
   Y_PHASE:oestr.Y_PHASE }

action=0
XScrMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Surface Quality',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=2
if action eq 'DONT' then return

oestr.F_G_S = fix(tmp.F_G_S(0))
oestr.FILE_RIP = tmp.FILE_RIP
oestr.X_RIP_WAV = tmp.X_RIP_WAV
oestr.Y_RIP_WAV = tmp.Y_RIP_WAV
oestr.X_RIP_AMP = tmp.X_RIP_AMP
oestr.Y_RIP_AMP = tmp.Y_RIP_AMP
oestr.X_PHASE = tmp.X_PHASE
oestr.Y_PHASE = tmp.Y_PHASE

return
end

