PRO sysplot,input, xrange=xrange, yrange=yrange

;+
;
;       NAME:
;               SYSPLOT
;       PURPOSE:
;               This procedure runs SHADOW's sysplot and displays
;               a plot. 
;
;       CATEGORY:
;               SHADOW tools
;
;       CALLING SEQUENCE:
;               sysplot,input
;
; 	INPUTS:
;		0: BATCH calculation (default) (SYSPLOT.STR file must be ready)
;		1: Interactive calculation (command line)
;	
; 	KEYWORD PARAMETERS
;
;	SIDE EFFECTS
;	       SHADOW's sysplot is run
;	       SHADOW's sysplot creates a file: SYSPLOT.DAT
;	       An auxiliar file is created: sysplot.tmp
;       
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu
;	
;	MODIFICATION HISTORY:
;		2009-09-29 written
;		2009-12-11 srio@esrf.eu adds xrange and yrange keywords
;
;-
on_error,2
;

;
; writes the input for running sysplot
;
;txt=[' 0',' 2',' 200 0',' optax.02',' begin.dat',' star.02',' mirr.01',' mirr.02',' 2 1']
;openw,unit,'SYSPLOT.STR',/get_lun
;for ii=0,N_elements(txt)-1 do printf,unit,txt[ii]
;free_lun,unit


IF N_Elements(input) EQ 0 THEN input=0 
;
; runs shadow/sysplot
;
IF input EQ 0 THEN BEGIN
   xsh_run,'echo 0 | sysplot'
ENDIF ELSE BEGIN
   xsh_run,'sysplot'
ENDELSE

;
; loads output of sysplot
;
txt=read_textfile('SYSPLOT.DAT')
;
; removes text
;
for ii=0,n_elements(txt)-1 do txt[ii]=strsubstitute(txt[ii],'line(','')
for ii=0,n_elements(txt)-1 do txt[ii]=strsubstitute(txt[ii],')','')
;
; writes new file
;
openw,unit,'sysplot.tmp',/get_lun
for ii=0,N_elements(txt)-1 do printf,unit,txt[ii]
free_lun,unit

;
; reads numerical data
;

data=rascii('sysplot.tmp')

IF N_Elements(xrange) NE 2 THEN xrange=[min(data[ [0,2],* ],max=tmp),tmp]
IF N_Elements(yrange) NE 2 THEN yrange=[min(data[ [1,3],* ],max=tmp),tmp]*2
;
; makes the plot
;
; window,/free,title='sysplot'
plot,[0,0],xrange=xrange,yrange=yrange
for ii=0,N_elements(data[0,*])-1 do begin 
  plots,data[0,ii],data[1,ii] 
  plots,data[2,ii],data[3,ii],/continue
endfor

END
