function read_VRML_file, file

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'read_VRML_file: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


file=STRTRIM(file,2)

IF CheckFile(file) NE 1 THEN BEGIN
  Message,/Info,'File not found: '+file
  RETURN,Obj_New('idlgrmodel')
ENDIF
openR, lun, file, /get_lun
line=string(' ')
model=obj_new('idlgrmodel')
CurrentModel=model
flag_next_line=0
mode=strarr(1)
mode=[mode,'children']
currentmode='unknow'


while not eof(lun) do begin
	readf, lun, line
	nb_words=strparse(line, ' ', words)
	nb_words=nb_words+1
	for r=0, nb_words-1 do begin
		words[r]=STRLOWCASE(STRTRIM(words[r], 2))
	endfor
	;; print, '>> ', words
	position=0
	flag_next_line=0
	while position lt nb_words and not flag_next_line do begin
		case words[position] of
		'worldinfo':begin
				currentMode='wordInfo'
				position=position+1
			end
		'children': begin
				currentMode='children'
				position=position+1
			end
		'transform':begin
				currentMode='transform'
				position=position+1
			end
		'shape':begin
				currentMode='shape'
				position=position+1
			end
		'rotation':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'transform' then begin
					; print,'Found Rotation out of transform!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				; print, 'Rotate.'
				angle=float(words[1:4])
				currentModel->rotate, angle[0:2],angle[3]
				flag_next_line=1
			end
		'translation':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'transform' then begin
					print,'Found Translation out of transform!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				; print, 'Translate.'
				vect=float(words[1:3])
				currentModel->translate, vect[0], vect[1], vect[2]
				flag_next_line=1
			end
		'scale':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'transform' then begin
					print,'Found Scale out of transform!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				; print, 'Scale.'
				vect=float(words[1:3])
				currentModel->scale, vect[0], vect[1], vect[2]
				flag_next_line=1
			end
		'pointlight':begin
				currentMode='light'
				position=position+1
			end
		'appearance':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'shape' then begin
					print,'Found appearance out of shape!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='appearance'
				position=position+1
			end
		'material':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'appearance' then begin
					print,'Found material out of appearance!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='material'
				position=position+1
			end
		'diffusecolor':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'material' then begin
					print,'Found diffusecolor out of material!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				; print, 'diffusecolor ignored.'
				rgb=float(words[1:3])
				flag_next_line=1
			end
		'emissivecolor':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'material' then begin
					print,'Found emissivecolor out of material!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				; print, 'emissivecolor ignored.'
				rgb=float(words[1:3])
				flag_next_line=1
			end
		'indexedlineset':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'shape' then begin
					print,'Found indexlineset out of shape!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='indexlineset'
				position=position+1
			end
		'indexedfaceset':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'shape' then begin
					print,'Found indexfaceset out of shape!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='indexfaceset'
				position=position+1
			end
		'coordindex':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'indexlineset' and mode[s-1] ne 'indexfaceset' then begin
					print,'Found coordindex out of indexlineset or indexfaceset!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='coordindex'
				position=position+1
			end
		'coordinate':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'indexlineset' and mode[s-1] ne 'indexfaceset' then begin
					print,'Found coordindex out of indexlineset or indexfaceset!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='coordinate'
				position=position+1
			end
		'point':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'coordinate' then begin
					print,'Found point out of coodinate!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='point'
				position=position+1
			end
		'normal':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'indexlineset' and mode[s-1] ne 'indexfaceset' then begin
					print,'Found normal out of indexlineset or indexfaceset!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='normal'
				position=position+1
			end
		'vector':begin
				s=(size(mode))[1]
				if mode[s-1] ne 'normal' then begin
					print,'Found vector out of normal!'
					close, lun
					free_lun, lun
					return, obj_new('idlgrmodel')
				endif
				currentMode='vector'
				position=position+1
			end
		']':begin
				s=(size(mode))[1]
				case mode[s-1] of
				'children':begin
						; print,'Exit children'
						mode=mode[0:s-2]
						currentMode='unknow'
						position=position+1
						currentModel->getProperty, parent=currentModel
					end
				else: begin
						; print, 'End ',mode[s-1]
						mode=mode[0:s-2]
						currentMode='unknow'
						position=position+1
					end
				endcase
			end
		'}':begin
				s=(size(mode))[1]
				case mode[s-1] of
				'shape':begin
						if n_elements(point) ne 1 and n_elements(coordindex) ne -1 then begin
							shape=obj_new('idlgrpolygon', point[0,*], point[1,*], point[2,*], $
											polygon=coordindex, color=rgb*255,/shading)
							currentmodel->add, shape
						end
						; print,'End shape description'
						mode=mode[0:s-2]
						currentMode='unknow'
						position=position+1
					end
				else: begin
						; print, 'End ', mode[s-1]
						mode=mode[0:s-2]
						currentMode='unknow'
						position=position+1
					end
				endcase
			end
		'[':begin
				mode=[mode, currentMode]
				; print, 'Start ', currentMode
				case currentMode of
					;'children':begin

					;	end
					'coordindex':begin
							flag=0
							num=0
							nbWordMax=0
							txt=''
							;to get the number of lines and the max number of index
							while not flag do begin
								result = FSTAT(lun)
								readf, lun, line
								nb_words=strparse(line, ',', words)
								nb_words=nb_words+1
								for r=0, nb_words-1 do begin
									words[r]=STRLOWCASE(STRTRIM(words[r], 2))
								endfor
								if nb_words gt 0 then begin
									if words[0] eq ']'	then flag=1 else begin
										txt=[[txt],line]
										num=num+1
										if nb_words gt nbWordMax then nbWordMax=nb_words
									endelse
								endif
							endwhile
							point_lun, lun, result.CUR_PTR
							flag=0
							coordIndex=intarr(nbwordmax, num)
							for n=0, num-1 do begin
								;readf, lun, line
								line=txt[n+1]
								nb_words=strparse(line, ',', words)
								nb_words=nb_words+1
								if nb_words gt 0 then begin
									words=STRLOWCASE(STRTRIM(words, 2))
									coordindex[0,n]=uint(nb_words-1)
									coordindex[1:nb_words-1,n]=uint(words[0:nb_words-2])
								endif
							endfor
						end
					'point':begin
							flag=0
							num=0
							while not flag do begin
								Result = FSTAT(lun)
								readf, lun, line
								nb_words=strparse(line, ' ', words)
								nb_words=nb_words+1
								for r=0, nb_words-1 do begin
									words[r]=STRLOWCASE(STRTRIM(words[r], 2))
								endfor
								if nb_words gt 0 then begin
									if words[0] eq ']'	then flag=1 else begin
								;		; print,'>> ', words
										newpoint=fltarr(nb_words, num+1)
										if num eq 0 then begin
								;			; print,num
											for w=0, nb_words-1 do begin
												newpoint[w ,num]=float(words[w])
											endfor
										endif else begin
								;			; print,num
											newpoint[*,0:num-1]=point
											for w=0, nb_words-1 do begin
												newpoint[w, num]=float(words[w])
											endfor
										endelse
										point=newpoint
									endelse
									num=num+1
								endif
							endwhile
							point_lun, lun, result.CUR_PTR
					;	; print, point
						end
					else: ;nothing
				endcase
				currentMode='unknow'
				position=position+1
			end
		'{':begin
				mode=[mode,currentMode]
				; print, 'Start ', currentMode
				case currentMode of
					'shape':begin
							coordIndex=-1
							point=-1
							normal=-1
							rgb=[128.,128., 128.]

						end
					'transform':begin
							newmodel=obj_new('idlgrmodel')
							currentModel->add, newmodel
							currentModel=newmodel
						end

					else:;nothing
				endcase
				currentMode='unknow'
				position=position+1
			end
		else: begin
				position=position+1
			end
		endcase
	endwhile
endwhile
close, lun
free_lun, lun

return, model
end


