;+
;
; =================================  XSh_AbRefC =============================
;
;   XSh_AbRefC is a widget based graphical interface to calculate
;   several properties of a given material (over a specified photon
;   energy range) that are important for physical optics calculations.
;   It interfaces the program ABREFC, part of the ray-tracing package SHADOW.
;   It creates intermediate files that are deleted when QUITing XSh_AbRefC.
;
;   The main window contains four buttons:
;
;       QUIT: to exit from the program
;
;       SET PARAMETERS: to define the parameters for the calculation
;		THICKNESS: thickness of the material in microns
;			(needed for computing the transmission).
;		DENSITY: Material density
;		INCIDENCE ANGLE: in degrees (for reflectivity)
;		PHOTON ENERGY: in eV, start end and step.
;		For each element:
;			Atomic symbol: Two capitalized letters.
;			Formula index.
;
;       SHOW: Display the selected option. Available options are:
;		DIELECTRIC FUNCTION: epsilon = 1 - alpha + i* beta
;			the user can display alpha or beta. 
;			Units are farad/cm
;		ABSOPTION COEFFICIENT: Units are cm^(-1)
;		TRANSMISSION: Tha transmission through a film of thickness	
;			d (as specified by the user):
;			T = exp(-d*mu*Phot_ener)
;		REFLECTIVITY: The s and p components of the reflectivity
;			R are computed from the Fresnel equations and the
;			dielectric function. Also available the average
;			between the s and p components.
;		REFRACTION INDEX: n^2 = epsilon. Only the real part is
;			available.
;		CROSS SECTION: for photoelectric effect. Units in cm^2
;		ELECTRON YIELD: as defined by B. Henke. In essence, the
;			primary electron yield is proportional to the
;			square of the electric field at the surface of
;			the material.
;		ENERGY LOSS: The rate at which energetic electrons lose
;			energy when travelling through a medium is 
;			proportional to the imaginary part of the dielectric
;			function. This is obtained directly from the 
;			linear medium response theory in the limit of
;			small q (Raether, 1960)
;			R(Delta_E) = - Imag(1/epsilon)
;		F1:	the atomic scattering factor f'
;		F2:	the atomic scattering factor f''
;
;       HELP:   Shows this text
;
;
; ----------------------------------------------------------------------
;       Author: S. Kesmarki, ESRF, Jun 1993
;       Modification history:
;		9/11/93 M. Sanchez del Rio: add HELP and cosmetics
;		16/5/94 M. Sanchez del Rio: adapt to a new version
;			   of abrefc (called abrefcnew) which has
;			   an extended optical library (> 100 keV) and
;			   creates the F1 and F2 files with the atomic
;			   scattering factors.
;		 94/10/27  M. Sanchez del Rio: cosmetics.
;		 94/11/28  MSR avoid the program crashes when try to
;			   set #compounds>5 (remarked by N. Brooks)
;                95/05/01  Roger J. Dejus, XFD/APS. Added the case
;                          'nothing' to the procedure xsh_abrefc_setparam_event to
;                          avoid crashing when user enter a <CR>.
;                97/10/02  srio@esrf.fr makes use of xop_wd,/default
;                97/12/05  srio@esrf.fr adapts for SHADOW-GUI
;
;
;-
;
;========================================================================
;
; +
; NAME:
; PURPOSE:
;	This procedure is a graphical interface to the
;	pragram called abrefc.
;
; CATEGORY:
;	User interface
;
; CALLING SEQUENCE:
;	XSh_AbRefC
;
; INPUTS:
;	Only from the keyboard during the running
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	The plot of the graph of the calculated results.
;
; OPTIONAL OUTPUTS:
; 	The graph can be printed to printer or to file
;
; COMMON BLOCKS:
;	compblock
;	compvaluesblock
;	paramblock
;	datafields
;	valuesblock
;	xab_block
;
; SIDE EFFECTS:
;	Creates temporary files in the current directory. These
;	files are deleted at the end.
;
; RESTRICTIONS:
;	The program creates files in the current directory.
;	So, it has to be allowed to write into the current directory.
;
; PROCEDURE:
;
; EXAMPLE:
;	The program are filled with default values. Just try it
;	without changing anything!
;
; MODIFICATION HISTORY:
; 	Written by:	Szabolcs Kesmarki,	Aug 4th, 1993 
; -

;--------------------------------------------------------------------
PRO xsh_abrefc_updatecomp

COMMON compblock, compnumfield, compbase, compound, compline1, compfield1, compfield2
COMMON compvaluesblock, compsymbol, compindex, compnum

WIDGET_CONTROL,compnumfield,GET_VALUE=newcompnum

newcompnum=newcompnum(0)
if newcompnum GT 5 then begin
  itmp = widget_message(/ERROR,'Maximum number of compounds = 5')
  newcompnum = 5
endif
IF (newcompnum GT compnum) THEN BEGIN
	FOR i=compnum+1,newcompnum DO BEGIN
	  string=string(i)+'. component     '
	  compound(i)=WIDGET_BASE(compbase,/COLUMN,/FRAME)
	  compline1(i)=WIDGET_LABEL(compound(i),VALUE=string)
	  compfield1(i)=CW_FIELD(compound(i),$
		TITLE='Atomic symbol:', XSIZE=5, VALUE=compsymbol(i))
	  compfield2(i)=CW_FIELD(compound(i),$
		TITLE='Formula index:', XSIZE=5, VALUE=compindex(i))
	ENDFOR
	WIDGET_CONTROL,compbase,/REALIZE
ENDIF ELSE IF (newcompnum LT compnum) THEN FOR i=newcompnum+1,compnum DO $
	WIDGET_CONTROL,compound(i),/DESTROY
compnum=newcompnum
END
;--------------------------------------------------------------------
PRO xsh_abrefc_setparam_event,event

COMMON paramblock,mainbase
COMMON compblock, compnumfield, compbase, compound, compline1, compfield1, compfield2
COMMON datafields,thicknessfield, densityfield, startenfield, endenfield, stepenfield, anglefield
COMMON compvaluesblock, compsymbol, compindex, compnum
COMMON valuesblock, thickness, density, starten, enden, stepen, angle

WIDGET_CONTROL,event.id,GET_UVALUE=eventuval
s=size(eventuval)
if s(1) EQ 0 THEN eventuval='nothing'

CASE eventuval OF
	'OK':		BEGIN
			openw,unit,'xsh_abrefc_tmp.inp',/GET_LUN

			WIDGET_CONTROL,thicknessfield,GET_VALUE=thickness
			WIDGET_CONTROL,densityfield,GET_VALUE=density
			WIDGET_CONTROL,startenfield,GET_VALUE=starten
			WIDGET_CONTROL,endenfield,GET_VALUE=enden
			WIDGET_CONTROL,stepenfield,GET_VALUE=stepen
			WIDGET_CONTROL,anglefield,GET_VALUE=angle
			printf,unit,'n'
			printf,unit,thickness
			printf,unit, angle
			printf,unit, density

			printf,unit, strcompress(compnum,/REMOVE_ALL)
			FOR i=1,compnum DO BEGIN
				WIDGET_CONTROL,compfield1(i), $
					GET_VALUE=strvalue
				compsymbol(i)=strvalue(0)
				strvalue=p_table(strvalue(0),/SHADOW)
				printf,unit, strvalue
				WIDGET_CONTROL,compfield2(i),$
					GET_VALUE=strvalue
				compindex(i)=strvalue(0)
				strvalue=strupcase(strcompress(strvalue(0),$
					/REMOVE_ALL))
				IF strlen(strvalue) EQ 0 THEN $
					strvalue=strvalue+strvalue
				printf,unit, strvalue
			ENDFOR
			printf,unit, starten,enden,stepen

			close,unit
			WIDGET_CONTROL,mainbase,/HOURGLASS
			print,'############# start running abrefc ##########'
	                command = 'abrefc < xsh_abrefc_tmp.inp'
			xsh_run,command
			print,'############# end running abrefc ############'
			WIDGET_CONTROL,mainbase,/DESTROY
			END
	'CANCEL':	WIDGET_CONTROL,mainbase,/DESTROY
	'COMPNUM':	xsh_abrefc_updatecomp
	'nothing':
ENDCASE
END
;--------------------------------------------------------------------
PRO xsh_abrefc_setparam,GROUP=group

COMMON paramblock,mainbase
COMMON compblock, compnumfield, compbase, compound, compline1, compfield1, compfield2
COMMON compvaluesblock, compsymbol, compindex, compnum
COMMON datafields,thicknessfield, densityfield, startenfield, endenfield, stepenfield, anglefield
COMMON valuesblock, thickness, density, starten, enden, stepen, angle

mainbase=WIDGET_BASE(/ROW,TITLE='XSh_AbRefC parameters')
parambase=WIDGET_BASE(mainbase,/COLUMN)

buttonbase=WIDGET_BASE(parambase,/ROW)
okbutton=WIDGET_BUTTON(buttonbase,VALUE='  Run  ',UVALUE='OK')
cancelbutton=WIDGET_BUTTON(buttonbase,VALUE='Cancel',UVALUE='CANCEL')

thicknessbase=WIDGET_BASE(parambase,/ROW,/FRAME)
thicknesslab1=WIDGET_LABEL(thicknessbase,VALUE='Thickness:        ')
thicknessfield=WIDGET_TEXT(thicknessbase,/EDITABLE,XSIZE=10,VALUE=thickness)
thicknesslab2=WIDGET_LABEL(thicknessbase,VALUE='microns')

densitybase=WIDGET_BASE(parambase,/ROW,/FRAME)
densitylab1=WIDGET_LABEL(densitybase,VALUE='Density:          ')
densityfield=WIDGET_TEXT(densitybase,/EDITABLE,XSIZE=10,VALUE=density)  
densitylab2=WIDGET_LABEL(densitybase,VALUE='g/cm^3')

anglebase=WIDGET_BASE(parambase,/ROW,/FRAME)
anglelab1=WIDGET_LABEL(anglebase,VALUE='Incidence angle:  ')
anglefield=WIDGET_TEXT(anglebase,/EDITABLE,XSIZE=10,VALUE=angle)
anglelab2=WIDGET_LABEL(anglebase,VALUE='degrees')

energybase=WIDGET_BASE(parambase,/COLUMN,/FRAME)
energytitle=WIDGET_LABEL(energybase,VALUE='Photon energy                        ')

startenbase=WIDGET_BASE(energybase,/ROW)
startenlab1=WIDGET_LABEL(startenbase,VALUE='    Starting: ')
startenfield=WIDGET_TEXT(startenbase,/EDITABLE,XSIZE=10,VALUE=starten)
startlab2=WIDGET_LABEL(startenbase,VALUE='eV')

endenbase=WIDGET_BASE(energybase,/ROW)
endenlab1=WIDGET_LABEL(endenbase,VALUE='    End:      ')
endenfield=WIDGET_TEXT(endenbase,/EDITABLE,XSIZE=10,VALUE=enden)
endlab2=WIDGET_LABEL(endenbase,VALUE='eV')

stepenbase=WIDGET_BASE(energybase,/ROW)
stepenlab1=WIDGET_LABEL(stepenbase,VALUE='    Step:     ')
stepenfield=WIDGET_TEXT(stepenbase,/EDITABLE,XSIZE=10,VALUE=stepen)
steplab2=WIDGET_LABEL(stepenbase,VALUE='eV')

compbase=WIDGET_BASE(mainbase,/COLUMN,/FRAME)
;compnumfield=CW_FIELD(compbase,TITLE='Number of components: ', XSIZE=5, /RETURN_EVENTS, UVALUE='COMPNUM', VALUE=compnum, /INTEGER)
compnumfield=Widget_Slider(compbase,TITLE='Number of components', $
  UVALUE='COMPNUM', VALUE=compnum, MINIMUM=1,MAXIMUM=5,/Frame)

compound=lonarr(6)
compline1=lonarr(6)
compfield1=lonarr(6)
compfield2=lonarr(6)

;compnum=0
;print,'>>>>> compnum: ',compnum
;xsh_abrefc_updatecomp


WIDGET_CONTROL,mainbase,/REALIZE
compnum=0
xsh_abrefc_updatecomp

XMANAGER,'xsh_abrefc_setparam',mainbase,GROUP_LEADER=group
END
;--------------------------------------------------------------------
PRO xsh_abrefc_event,event

COMMON xab_block, base

WIDGET_CONTROL,event.id,GET_UVALUE=eventuval
CASE eventuval OF
	'QUIT':	BEGIN
		WIDGET_CONTROL,base,/HOURGLASS
		!p.position=[0,0,0,0]
		case sdep() of
		  'UNIX': command = '/bin/rm -f xsh_abrefc_tmp.inp ABCOEFF'+$
		          ' CROSS_SECTION'+ $
                          ' DIELEC ELECTRON_YIELD ENERGY_LOSS REFLECTIVITY'+ $
                          ' REFRAC_INDEX TRANSMISSION F1_F2'
		  'WINDOWS': command = ['del xsh_abrefc_tmp.inp',$
				'del ABCOEFF','del CROSS_SECTION',$
                                'del DIELEC','del ELECTRON_YIELD',$
			        'del ENERGY_LOSS','del REFLECTIVITY',$
                                'del REFRAC_INDEX','del TRANSMISSION','del F1_F2']
		  else: command = ''
		endcase
		xsh_run,command
		WIDGET_CONTROL,base, /DESTROY
		END
	'SETPAR':	xsh_abrefc_setparam,GROUP=base
        'HELP': xhelp,'xsh_abrefc',GROUP=base
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		title=eventval
		ytitle=' '
		ycol=2
		CASE eventval OF
		"Real part":		BEGIN
					filename='DIELEC'
					title='Dielectric Function, '+title
					ytitle=' [ F/cm ]'
					END
		"Imaginary part":	BEGIN
					filename='DIELEC'
					ycol=3
					title='Dielectric Function, '+title
					ytitle=' [ F/cm ]'
					END
		"Absorption Coefficient":BEGIN
					filename='ABCOEFF'
					ytitle='cm!E-1'
					END
		"Transmission":		filename='TRANSMISSION'
		"Total":		BEGIN
					filename='REFLECTIVITY'
					title='Reflectivity, '+title
					END
		"Parallel":		BEGIN
					filename='REFLECTIVITY'
					ycol=3
					title='Reflectivity, '+title
					END
		"Perpendicular":	BEGIN
					filename='REFLECTIVITY'
					ycol=4
					title='Reflectivity, '+title
					END
		"Refraction index":	filename='REFRAC_INDEX'
		"Cross Section":	BEGIN
					filename='CROSS_SECTION'
					ytitle='cm!E2'
					END
		"Electron Yield":	filename='ELECTRON_YIELD'
		"Energy Loss":		filename='ENERGY_LOSS'
		"f1":			filename='F1'
		"f2":			filename='F2'
		ENDCASE
		ffile = FINDFILE(filename)
                IF (ffile(0) EQ '') THEN BEGIN
                  print,'XSh_AbRefC: File not found. '
                  itmp = widget_message(/ERROR,'Data not found.'+$
                        ' Set Parameters before...  ')
                ENDIF ELSE BEGIN
		  widget_control,/hourglass
		  XPLOT,filename,GROUP=base,  $
		  XTITLE='Photon energy  [ eV ]', YTITLE=ytitle,  $
		  TITLE=title, YCOL=ycol
		ENDELSE
		END
ENDCASE
END
;--------------------------------------------------------------------
PRO XSh_AbRefC, GROUP=group


COMMON xab_block, base
COMMON valuesblock, thickness, density, starten, enden, stepen, angle
COMMON compvaluesblock, compsymbol, compindex, compnum


thickness='100' & density='12.39' & starten='5000' & enden='50000' & stepen='1000' & angle='89.8'
compnum=1
compsymbol=strarr(6)
compindex=strarr(6)

FOR i=1,5 DO BEGIN
		compsymbol(i)=' '
		compindex(i)=' '
		END
compsymbol(1)='Rh'
compindex(1)=1

base=WIDGET_BASE(/COLUMN,TITLE='XSh_AbRefC')
XPdMenu, [ 	'"Quit"			QUIT',$
		'"Set parameters"	SETPAR',$
		'"Show"	{',$
			'"Dielectric Function"	{',$
				'"Real part"		SHOW',$
				'"Imaginary part"	SHOW',$
				'}',$
			'"Absorption Coefficient"	SHOW',$
			'"Transmission"			SHOW',$
			'"Reflectivity"		{',$
				'"Total"		SHOW',$
				'"Parallel"		SHOW',$
				'"Perpendicular"	SHOW',$
				'}',$
			'"Refraction index"		SHOW',$
			'"Cross Section"		SHOW',$
			'"Electron Yield"		SHOW',$
			'"Energy Loss"			SHOW',$
;			'"f1"				SHOW',$
;			'"f2"				SHOW',$
			'}',$
		'"Help"					HELP'$
		], base

case sdep() of
  'UNIX': font='-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'
  'WINDOWS': font='VERDANA*BOLD*ITALIC*24' 
  else: font = ''
endcase
wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE='AbRefC')

wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE='Absorption and Reflectivity')

wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE='(SHADOW utilities)')


!p.position=[0.15,0.1,0.95,0.95]
WIDGET_CONTROL,base,/REALIZE
XMANAGER,'XSh_AbRefC',base,GROUP_LEADER=group		
END
