;SOURCE CLASS, CREATE METHOD

;ARGUMENTS:
;
;   npoints:  numbers of ray
;KEYWORDS
;   typeS=typeS
;      typeS=1 points source
;      typeS=2 rectangular source
;      typeS=3 gaussian source
;      typeS=4 circular uniform source
;      typeS=5 circular normal source

FUNCTION source, npoints, typeS=typeS, typeANG=typeANG, Xrange=Xrange, Zrange=Zrange, Polar=Polar, Azimuth=Azimuth, $
          distance=distance, drawn=drawn

IF n_elements(typeS) EQ 0 THEN typeS=1
IF n_elements(typeANG) EQ 0 THEN typeANG=1
IF n_elements(npoints) EQ 0 THEN npoints=1L
IF n_elements(Xrange) EQ 0 THEN Xrange=[-1e-4,1e-4]
IF n_elements(Zrange) EQ 0 THEN Zrange=[-1e-4,1e-4]
IF n_elements(distance) EQ 0 THEN distance=15 ;m
IF n_elements(Polar) EQ 0 THEN Polar = 1e-3
IF n_elements(Azimuth) EQ 0 THEN Azimuth = 1e-3
IF n_elements(sigma) EQ 0 THEN sigma=1e-4

distance=distance*1e2

Xrange = Xrange(sort(Xrange))
Zrange = Zrange(sort(Zrange))
deltaX = (Xrange[1]-Xrange[0])
deltaZ = (Zrange[1]-Zrange[0])

midpointX = (Xrange[1] + Xrange[0])/2
midpointZ = (Zrange[1] + Zrange[0])/2

ray = dblarr(6,npoints) ; 3 colons, X, Y, Z

;source creation
CASE typeS OF

;==PENCIL source==;
1: BEGIN ray[0,*] = 0. + midpointX
         ray[1,*] = 0.
         ray[2,*] = 0. + midpointZ
   END

;==RECTANGULAR source==;
2: BEGIN
         ray[0,*] = Xrange[0] + randomu(seed, npoints, /double)*deltaX
         ray[1,*] = 0D
         ray[2,*] = Zrange[0] + randomu(seed, npoints, /double)*deltaZ
   END

;==GUASSIAN source==;
3:  BEGIN
         ray[0,*] = randomn(seed, npoints, /double)*deltaX/(2D*sqrt(2D*alog(2D)))
         ray[1,*] = 0D
         ray[2,*] = randomn(seed, npoints, /double)*deltaZ/(2D*sqrt(2D*alog(2D)))
         Xrange = [min(ray[0,*]) , max(ray[0,*])]
         Zrange = [min(ray[2,*]) , max(ray[2,*])]
         END
;CIRCULAR source, UNIFORM distribution

4: BEGIN chi1 = randomu(seed,npoints,/double)
         chi2 = randomu(seed,npoints,/double)
         chi3 = randomu(seed,npoints,/double)
         a = sqrt(chi1)*deltaX/2  ;ray of circular aperture
         b = sqrt(chi1)*deltaZ/2
         ang = 2*!dpi*chi3
         ray[0,*] = a*cos(ang)
         ray[1,*] = 0D
         ray[2,*] = b*sin(ang)
        END
;CIRCULAR source, NORMAL distribution
;5: BEGIN chi1 = randomN(seed,npoints,/double)
;         chi2 = randomN(seed,npoints,/double)
;         chi3 = randomN(seed,npoints,/double)
;         a = sqrt(chi1)*deltaX/2  ;ray of circular aperture
;         b = sqrt(chi2)*deltaZ/2
;         ang = 2*!dpi*chi3
;         ray[0,*] = a*cos(ang)
;         ray[1,*] = 0D
;         ray[2,*] = b*sin(ang)
;    END
ENDCASE


;==ordinamento crescente dei valori==;

;c = reverse(sort(ray[0,*]))
;ray[0,*] = ray[0,c]
;ray[2,*] = ray[2,c]


ranPolar = randomu(seed, npoints, /double)
pmPolar = (2*ranPolar-1)/abs(2*ranPolar-1)          ;uniformly negative/positive array of 1 for the Polar angle

ranAzimuth = randomu(seed, npoints, /double)
pmAzimuth = (2*ranAzimuth-1)/abs(2*ranAzimuth-1)    ;uniformly negative/positive array of 1 for the Azimuthal angle

CASE typeANG OF

;==GUASSIAN DISTRIBUTION OF DIRECTION==;
1: BEGIN ranP = randomn(seed, npoints, /double)*pmPolar
         ranA = randomn(seed, npoints, /double)*pmAzimuth
         ray[3,*] = cos(ranP*Polar/2)*sin(ranA*Azimuth/2)
         ray[5,*] = sin(ranP*Polar/2)
         ray[4,*] = sqrt(1-ray[3,*]^2-ray[5,*]^2)
   END
;==UNIFORM DISTRIBUTION OF DIRECTION==;
2: BEGIN chi1 = randomu(seed, npoints, /double)
         chi2 = randomu(seed, npoints, /double)
         sinP1=sin(Polar/2)
         A1=2*sinP1
         Azimuth1=Azimuth
         A2=Azimuth1
         teta=2*asin(A1*chi1 - sinP1)
         phi=2*(A2*chi2 - Azimuth1/2)
         ray[3,*] = cos(teta)*sin(phi)
         ray[4,*] = cos(teta)*cos(phi)
         ray[5,*] = sin(teta)
   END
   ENDCASE

writesh,'begin.dat',ray,[1,2,3,4,5,6]

IF keyword_set(drawn) THEN xsh_plotxy


return, ray

END