;+
;
; FUNCTION __nrbrefineknotsvectsurface,surf, iknotsU=iknotsU,iknotsV=iknotsV
;
;// Insert Knot into a B-Spline
;//
;// INPUT:
;//
;//   d - spline degree             integer
;//   c - control points            double  matrix(mc,nc)
;//   k - knot sequence             double  vector(nk)
;//   u - new knots                 double  vector(nu)
;//
;// OUTPUT:
;//
;//   ic - new control points double  matrix(mc,nc+nu)
;//   ik - new knot sequence  double  vector(nk+nu)
;//
;// Modified version of Algorithm A5.4 from 'The NURBS BOOK' pg164.
;-


FUNCTION __nrbrefineknotsvectsurface,surf, iknotsU=iknotsU,iknotsV=iknotsV

;//structure surf redefined variables
coefs=surf.coefs
uknots=surf.uknots
vknots=surf.vknots

;// V KNOTS INSERTION//;

IF n_elements(iknotsV) NE 0 THEN BEGIN

w=where((iknotsv ne vknots[0]) and (iknotsv ne vknots[n_elements(vknots)-1]))

IF w[0] NE -1 THEN BEGIN
iknotsv=iknotsv[w]

;//matrix dimensions//;
dim=size(coefs,/dimensions)
mcv =  dim(0)*dim(1);//number of rows//;
ncv = dim(2) ;//number of columns//;

;//coefs reshaping//;
ctrl=transpose(coefs,[1,0,2])
ctrl=transpose(reform(ctrl,mcv,ncv))

dv=surf.q ;//degree of the nurbs along V direction

kv=vknots ;// starting knots along V direction
nkv = n_elements(kv) ;// number of starting knots along V direction

  ;// knots to be inserted//;

 nv = n_elements(iknotsV) ;//numbers of knots to insert along V direction

 nikv = nkv + nv ;// total number of knots along V direction (within the inserction)

 ikv=dblarr(nikv) ;//definition of the new knots' array along V direction

 nicv = ncv + nv ;//number of new control points given by the insertions of knots along V direction

 ictrl = dblarr(nicv,mcv) ;//definition of the new control points given by the insertion


;// FOR LOOPS index defining//;
  n = ncv - 1 ;//last ctrl point index//;

  r = nv - 1 ;//last inserting knots index//;

  m = n + dv + 1


  ;// IVKNOTS position defining inside the VKNOTS array//;
  iknotsV = iknotsV(sort(iknotsV)) ;//increasing sorting of the inserting Knots along V direction//;

  a = __nrbfindspan(n, dv, iknotsV[0], kv)
  b = __nrbfindspan(n, dv, iknotsV[r], kv)

  ++b;

;//inserction of non variating ctrl points//;
  FOR row = 0,mcv-1 DO BEGIN

    FOR j = 0,a-dv DO ictrl[j,row] = ctrl[j,row]
    FOR j = b-1,n DO ictrl[j+r+1,row] = ctrl[j,row]

  ENDFOR
;//inserction of non variating knots along V direction//;

  FOR j = 0,a DO ikv[j] = kv[j]
  FOR j = b+dv, m DO ikv[j+r+1] = kv[j];

;//min e max span index dued by the inserction

  i = b + dv - 1;
  s = b + dv + r;

  FOR j = r,0,-1 DO BEGIN

    WHILE (iknotsV[j] LE kv[i] && i GT a) DO BEGIN

      ikv[s] = kv[i]

      FOR row = 0, mcv-1 DO ictrl[s-dv-1,row] = ctrl[i-dv-1,row]

      --s;
      --i;
    ENDWHILE

    FOR row = 0,mcv-1 DO ictrl[s-dv-1,row] = ictrl[s-dv,row]

    FOR l = 1,dv DO BEGIN

      ind = s - dv + l;

      alfa = ikv[s+l] - iknotsV[j]

      IF (abs(alfa) EQ 0.0) THEN BEGIN

        FOR row = 0,mcv -1 DO ictrl[ind-1,row] = ictrl[ind,row]

      ENDIF ELSE BEGIN

        alfa /= (ikv[s+l] - kv[i-dv+l])

        FOR row = 0,mcv-1 DO ictrl[ind-1,row] = alfa*ictrl[ind-1,row]+(1.0-alfa)*ictrl[ind,row]

    ENDELSE
    ENDFOR

    ikv[s] = iknotsV[j]
    --s;

  ENDFOR

;//new vknots vector dued by inserction//;
vknots=ikv

;//3D grid reshaping//;
ictrl=transpose(ictrl)
ictrl=reform(ictrl,4,mcv/4,nicv)
ictrl=transpose(ictrl,[1,0,2])

coefs=ictrl
ENDIF

ENDIF

;//----------------------------------------------------------//;

;// U KNOTS INSERTION //;

IF n_elements(iknotsu) NE 0 THEN BEGIN

w=where((iknotsu ne uknots[0]) and (iknotsu ne uknots[n_elements(uknots)-1]))

IF w[0] NE -1 THEN BEGIN
iknotsu=iknotsu[w]

;//matrix dimensions//;
dim=size(coefs,/dimensions)

ncu = dim(0) ;//number of rows//;
mcu = dim(1)*dim(2) ;//number of columns//;

ctrl=reform(coefs,ncu,mcu)

du=surf.p ;//degree of the nurbs along U direction

ku=uknots ;// starting knots along U direction
nku = n_elements(ku) ;// number of starting knots along U direction

  ;// knots to be inserted

 nu = n_elements(iknotsU) ;//numbers of knots to inserto along U direction
 niku = nku + nu ;// total number of knots along U direction
 iku=dblarr(niku) ;//definition of the new knots' array along U direction

 nicu = ncu + nu ;number of new control points given by the insertions of knots along U direction

 ictrl = dblarr(nicu,mcu) ;//definition of the new control points given by the insertion

;// FOR LOOPS index defining//;
  n = ncu - 1
  r = nu - 1

  m = n + du + 1

;// IUKNOTS position defining inside of the UKNOTS array//;

  iknotsU=iknotsU(sort(iknotsU));//increasing sorting of the inserting Knots along U direction//;

  a = __nrbfindspan(n, du, iknotsU[0], ku)

  b = __nrbfindspan(n, du, iknotsU[r], ku);

  ++b;

  FOR row = 0,mcu-1 DO BEGIN

    FOR j = 0,a-du DO ictrl[j,row] = ctrl[j,row]
    FOR j = b-1,n DO ictrl[j+r+1,row] = ctrl[j,row]

  ENDFOR

  FOR j = 0,a DO iku[j] = ku[j]

  FOR j = b+du, m DO iku[j+r+1] = ku[j];

  i = b + du - 1;
  s = b + du + r;

  FOR j = r,0,-1 DO BEGIN

    WHILE (iknotsU[j] LE ku[i] && i GT a) DO BEGIN

      iku[s] = ku[i]

      FOR row = 0, mcu-1 DO ictrl[s-du-1,row] = ctrl[i-du-1,row]

      --s;
      --i;
    ENDWHILE

    FOR row = 0,mcu-1 DO ictrl[s-du-1,row] = ictrl[s-du,row]

    FOR l = 1,du DO BEGIN

      ind = s - du + l;

      alfa = iku[s+l] - iknotsU[j]

      IF (abs(alfa) EQ 0.0) THEN BEGIN

        FOR row = 0,mcu -1 DO ictrl[ind-1,row] = ictrl[ind,row]

      ENDIF ELSE BEGIN

        alfa /= (iku[s+l] - ku[i-du+l])

        FOR row = 0,mcu-1 DO ictrl[ind-1,row] = alfa*ictrl[ind-1,row]+(1.0-alfa)*ictrl[ind,row]

    ENDELSE
    ENDFOR

    iku[s] = iknotsU[j]
    --s

  ENDFOR

uknots=iku

ictrl=reform(ictrl,nicu,4,mcu/4)

coefs=ictrl
ENDIF

ENDIF


isurf=nrbstruct(coefs,uknots,vknots)

return,isurf
END
