;+
;
;   ===========================  Xshundul   =========================
;
;   Xshundul is an widget based graphical interface to generate
;   the SHADOW undulator source.
;
;   The main window contains four buttons:
;
;	File: 
;		Load XShUndul input file...
;		Write XShUndul input file...
;		QUIT: to exit from the program
;
;	SET PARAMETERS: to define the parameters for the calculation
;		
;	SHOW: 
;		Some views of the result file 'begin.dat'
;
;	HELP:   Shows this text
;
;
; ----------------------------------------------------------------------
;       Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF, Dec 1995
;       Modification history:
;		96/01/08 MSR allows input file from command line.
;		96/11/05 MSR uses xsh_run to spawn shadow commands.
;		96/03/02 MSR adds no_block kw to xmanager
;		98/03/17 MSR modifies the input parameter (ptr) to plug into
;			the SHADOW-VUI.
;		00/05/30 MSR adds Only_Run keyword
;		00/07/17 MSR allows modifying number of rays.
;		2008/09/11 MSR fixes a bug (error when closing and
;			reopening the parameter window). (Noticed by 
;			Dave Gore). v1.1. 
;
;-
;
;========================================================================
;
;-
;		
;========================================================================
;
FUNCTION XSHUNDUL_NAMEVERSION
return,'XShUndul 1.1'
end
;		
;========================================================================
;
pro xshundul_set_getstr,state
on_error,2
inp = state.str
wids = state.wids
widget_control,wids.lambdau,get_value=lambdau
widget_control,wids.k,get_value=k
widget_control,wids.e_energy,get_value=e_energy
widget_control,wids.nperiods,get_value=nperiods
widget_control,wids.emin,get_value=emin
widget_control,wids.emax,get_value=emax
widget_control,wids.intensity,get_value=intensity
widget_control,wids.maxangle,get_value=maxangle
widget_control,wids.seed,get_value=seed
widget_control,wids.nrays,get_value=nrays
widget_control,wids.sx,get_value=sx
widget_control,wids.sz,get_value=sz
widget_control,wids.ex,get_value=ex
widget_control,wids.ez,get_value=ez

inp.lambdau = float(lambdau(0))
inp.k = float(k(0))
inp.e_energy = float(e_energy(0))
inp.nperiods = fix(nperiods(0))
inp.emin = float(emin(0))
inp.emax = float(emax(0))
inp.intensity = float(intensity(0))
inp.maxangle = float(maxangle(0))
inp.seed = long(seed(0))
inp.nrays = long(nrays[0])
inp.sx = float(sx(0))
inp.sz = float(sz(0))
inp.ex = float(ex(0))
inp.ez = float(ez(0))

state.str = inp
end
;		
;========================================================================
;
PRO xshundul_set_event,event

widget_control,event.id,get_uval=uval

if not(keyword_set(uval)) then return
widget_control,event.top,get_uvalue=state ; ,/no_copy
case uval of
  'run':begin
	widget_control,/hourglass
	xshundul_set_getstr,state
	xshundul_run,state.str,group=event.top
	end
  'done':begin
	xshundul_set_getstr,state
	if ptr_valid(state.input) then *(state.input) = state.str
;	if widget_info(state.caller,/valid) then begin
;	  widget_control,state.caller,set_uvalue = state.str
;        endif
	widget_control,event.top,/destroy
	return
	end
  'cancel':begin
	widget_control,event.top,/destroy
	return
	end
  'update':begin
	xshundul_set_getstr,state
	inp = state.str
	e0 = 950. * inp.e_energy^2 /(1+ inp.k^2/2)/(100*inp.lambdau)
	cc = 1./(1.957*inp.e_energy)*sqrt( (1+inp.k^2/2)/2/inp.nperiods)
	fr = 1./(1.957*inp.e_energy)*sqrt( (1+inp.k^2/2))
	widget_control,state.wids.pree0,set_value=$
	'1st, 3rd, 5th harmonic energy [eV]: '+vect2string([e0,e0*3,e0*5])
	widget_control,state.wids.precc,set_value=$
	'1st, 3rd, 5th harmonic central cone aperture (sigma) [mrad]: '+$
	vect2string([cc,cc/sqrt(3),cc/sqrt(5)])
	widget_control,state.wids.prefr,set_value=$
	'1st, 3rd, 5th harmonic first ring aperture [mrad]: '+$
	vect2string([fr,fr/sqrt(3),fr/sqrt(5)])
	end
  'drop':begin
	state.str.undul_phot_flag(0) = strcompress(event.index,/rem)
	end
endcase
widget_control,event.top,set_uvalue=state ; ,/no_copy
end
;		
;========================================================================
;
PRO xshundul_set,inp,GROUP=group,input=input
;
on_error,2


if xregistered('xshundul_set') then begin
  itmp = Dialog_Message(Dialog_Parent=group,/Question,/Default_No,$
    ['SHADOW VUI has detected an open window for Undulator Source',$
     'Do you want another one?'])
  if itmp EQ 'No' then return
endif
if not(keyword_set(inp)) then inp = xsh_defaults('xshundul')
if not(keyword_set(group)) then wgroup=0L else wgroup=group
if not(keyword_set(input)) then input=0


wWindow = widget_base(title='Undulator Parameters ('+$
   xshundul_nameversion()+')',/COLUMN)


wtmp = widget_base(wWindow,/ROW)
;wtmp1 = widget_button(wtmp,value='Accept',uvalue='done')
wtmp1 = widget_button(wtmp,value='Close',uvalue='done')
;wtmp1 = widget_button(wtmp,value='Cancel',uvalue='cancel')
wtmp1 = widget_button(wtmp,value='Discard changes',uvalue='cancel')
wtmp1 = widget_button(wtmp,value='Run Shadow/source',uvalue='run')


;
; undulator/machine pars
;
wbase = widget_base(wWindow,/COL,/FRAME)
case sdep() of
  'WINDOWS': font = 'VERDANA*BOLD*ITALIC*24' 
  'UNIX': font='-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'
  else: font = ''
endcase

wtmp = widget_label(wbase,value='Undulator/Machine parameters', FONT=font)

wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Period [m]: ',/align_left)
wlambdau = widget_text(wbase0,value=strcompress(inp.lambdau,/rem),/EDIT,$
	XSIZE=6,uvalue='update',/All_Events)
wtmp = widget_label(wbase0,value='K Parameter: ', /align_left)
wK = widget_text(wbase0,value=strcompress(inp.K,/rem),/EDIT,xsize=6, $
	uvalue='update',/All_Events)
wtmp = widget_label(wbase0,value='N periods: ', /align_left)
wnperiods = widget_text(wbase0,value=strcompress(inp.nperiods,/rem),/EDIT,$
	xsize=6, uvalue='update',/All_Events)

wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Energy [GeV]: ', /align_left)
we_energy = widget_text(wbase0,value=strcompress(inp.e_energy,/rem),/EDIT,$
	xsize=6,uvalue='update',/All_Events)
wtmp = widget_label(wbase0,value='Intensity [A]: ', /align_left)
wintensity = widget_text(wbase0,value=strcompress(inp.intensity,/rem),$
	XSIZE=6,/EDIT)


wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Sigma X [cm]: ', /align_left)
wsx = widget_text(wbase0,value=strcompress(inp.sx,/rem),/EDIT,XSIZE=8)
wtmp = widget_label(wbase0,value='Sigma V [cm]: ', /align_left)
wsz = widget_text(wbase0,value=strcompress(inp.sz,/rem),/EDIT,XSIZE=8)

wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Emittance X [rad.cm]: ', /align_left)
wex = widget_text(wbase0,value=strcompress(inp.ex,/rem),/EDIT,XSIZE=12)
wtmp = widget_label(wbase0,value='Emittance Z [rad.cm]: ', /align_left)
wez = widget_text(wbase0,value=strcompress(inp.ez,/rem),/EDIT,XSIZE=12)

;
; pre-calculation pars
;

wbase = widget_base(wWindow,/COL,/FRAME)
wtmp = widget_label(wbase,value='Pre-calculation parameters', FONT=font)

e0 = 950. * inp.e_energy^2 /(1+ inp.k^2/2)/(100*inp.lambdau)

wpreE0 = widget_label(wbase, /align_left, value= $
	'1st, 3rd, 5th harmonic energy [eV]: '+vect2string([e0,e0*3,e0*5]) )

cc = 1./(1.957*inp.e_energy)*sqrt( (1+inp.k^2/2)/2/inp.nperiods)
wprecc = widget_label(wbase, /align_left, value= $
	'1st, 3rd, 5th harmonic central cone aperture (sigma) [mrad]: '+$
	vect2string([cc,cc/sqrt(3),cc/sqrt(5)]))

fr = 1./(1.957*inp.e_energy)*sqrt( (1+inp.k^2/2))
wprefr = widget_label(wbase, /align_left, value= $
	'1st, 3rd, 5th harmonic first ring aperture [mrad]: '+$
	vect2string([fr,fr/sqrt(3),fr/sqrt(5)]))

;
; calculation pars
;

wbase = widget_base(wWindow,/COL,/FRAME)
wtmp = widget_label(wbase,value='Calculation parameters', FONT=font)

wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Calculation code : ',/align_left)
wdrop = widget_droplist(wbase0,value=['Shadow code','Urgent code'],$
	uvalue='drop')
wtmp = widget_label(wbase0,value='Emin [eV]: ',/align_left)
wemin = widget_text(wbase0,value=strcompress(inp.emin,/rem),/edit,xsize=9)
wtmp = widget_label(wbase0,value='Emax [eV]: ',/align_left)
wemax = widget_text(wbase0,value=strcompress(inp.emax,/rem),/edit,xsize=9)

wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Maximum aperture angle [mrad]: ',/align_left)
wmaxangle = widget_text(wbase0,value=strcompress(inp.maxangle,/rem),/edit,$
	xsize=6)
wtmp = widget_label(wbase0,value='Random seed [odd, < 100000] : ',/align_left)
wseed = widget_text(wbase0,value=strcompress(inp.seed,/rem),/edit,$
	xsize=8)

wbase0 = widget_base(wbase,/ROW)
wtmp = widget_label(wbase0,value='Number of rays : ',/align_left)
wnrays = widget_text(wbase0,value=strcompress(inp.nrays,/rem),/edit,$
	xsize=8)



wids = { lambdau:wlambdau, k:wk, e_energy:we_energy, nperiods:wnperiods, $
  emin:wemin, emax:wemax, intensity:wintensity, maxangle:wmaxangle, $
  seed:wseed, sx:wsx, sz:wsz, ex:wex, ez:wez, $
  pree0:wpree0, precc:wprecc, prefr:wprefr, nrays:wnrays }

state = { caller:wgroup, str:inp , wids:wids, input:input }
widget_control,wWindow,set_uvalue=state,/REALIZE
widget_control,wdrop,set_droplist_select=fix(inp.undul_phot_flag(0))

if keyword_set(input) then no_block=1 else no_block=0
xmanager,'xshundul_set', wWindow, group=group,no_block=no_block
END
;		
;========================================================================
;
PRO xshundul_run,str, remove=remove, group=group


common shadow3,shadow3_mode, shadow3_binary
;
on_error,2

;
; run epath
;
CASE shadow3_mode OF
  0: openw,Unit,'xsh_epath_tmp.inp',/get_lun
  else: BEGIN
        openw,Unit,'shadow3.inp',/get_lun
        printf,Unit,'epath'
        END
ENDCASE
printf,Unit,'2'
printf,Unit,strcompress(str.lambdau,/rem)
printf,Unit,strcompress(str.k,/rem)
printf,Unit,strcompress(str.e_energy,/rem)
printf,Unit,'101'
printf,Unit,'1.'
printf,Unit,'xshundul.par'
printf,Unit,'xshundul.traj'
printf,Unit,'0'
IF shadow3_mode EQ 0 THEN free_lun,Unit

;xsh_run,'epath < xsh_epath_tmp.inp'
command = ['epath < xsh_epath_tmp.inp']

;
; run undul_set
;
IF shadow3_mode EQ 0 THEN BEGIN
  openw,Unit,'xsh_undul_set_tmp.inp',/get_lun
ENDIF ELSE BEGIN
  printf,Unit,'undul_set'
ENDELSE
printf,Unit,'0'
printf,Unit,'0'
printf,Unit,'11'
printf,Unit,'31'
printf,Unit,'31'
printf,Unit,'xshundul.traj'
printf,Unit,strcompress(str.nperiods,/rem)
printf,Unit,strcompress(str.emin,/rem)
printf,Unit,strcompress(str.emax,/rem)
printf,Unit,strcompress(str.intensity,/rem)
printf,Unit,strcompress(str.maxangle,/rem)
printf,Unit,'0'
printf,Unit,'1000'
IF shadow3_mode EQ 0 THEN BEGIN
   free_lun,Unit
   ;xsh_run,'undul_set < xsh_undul_set_tmp.inp'
   command = [command,'undul_set < xsh_undul_set_tmp.inp']
ENDIF 

; 
;run undul_phot(shadow) or cdf_z(urgent)
;
if  strcompress(str.undul_phot_flag(0),/rem) EQ '0' then begin
  ;xsh_run,'undul_phot'
  IF shadow3_mode EQ 0 THEN BEGIN
    command = [command,'undul_phot']
  ENDIF ELSE BEGIN
    printf,Unit,'undul_phot'
  ENDELSE
endif else begin
  IF shadow3_mode EQ 0 THEN BEGIN
    openw,Unit,'UNDUL_Z.PAR',/get_lun
    printf,Unit,str.lambdau, 0.0, str.k, str.nperiods, str.e_energy, $
	  str.intensity, 0, 0
    free_lun, Unit
    ;xsh_run,'cdf_z'
    command = [command,'cdf_z']
    ; 
    ; check if cdf_z is installed
    ;
    ffile = Getenv('SHADOW_ROOT')+SDep(/ds)+'bin'+SDep(/ds)+'cdf_z'
    IF SDEP() EQ 'WINDOWS' THEN  ffile=ffile+'.exe'
    IF checkfile(ffile) NE 1 THEN BEGIN
       itmp = Dialog_Message(/Error,Dialog_Parent=group,[$
          ' File Not Found: '+ffile,'','',$
          ' To run Undulator with URGENT code you must download the '+$
                  'cdf_z code from: ','',$
          ' http://ftp.esrf.eu/pub/scisoft/shadow/user_contributions','',$
          ' and install it in your shadow bin directory (listed before)'])
       RETURN
    ENDIF
  ENDIF ELSE BEGIN ; shadow3
    printf,Unit,'cdf_z'
  ENDELSE
endelse
;
;run undul_cdf
;
IF shadow3_mode EQ 0 THEN BEGIN
  openw,Unit,'xsh_undul_cdf_tmp.inp',/get_lun
ENDIF ELSE BEGIN
  printf,Unit,'undul_cdf'
ENDELSE
printf,Unit,'0'
printf,Unit,'1'
printf,Unit,'xshundul.sha'
printf,Unit,'xshundul.info'


IF shadow3_mode EQ 0 THEN BEGIN
  free_lun,Unit
  
  ;xsh_run,'undul_cdf < xsh_undul_cdf_tmp.inp'
  command = [command,'undul_cdf < xsh_undul_cdf_tmp.inp']
ENDIF 

;
; run input_source
;
IF shadow3_mode EQ 0 THEN BEGIN
  openw,Unit,'xsh_input_source_tmp.inp',/get_lun
ENDIF ELSE BEGIN
  printf,Unit,'input_source'
ENDELSE
printf,Unit,'1'
printf,Unit,'0'
printf,Unit,strcompress(str.nrays,/rem)
printf,Unit,strcompress(str.seed,/rem)
printf,Unit,'0'
printf,Unit,'2'
printf,Unit,'xshundul.sha'
printf,Unit,strcompress(str.sx,/rem)
printf,Unit,strcompress(str.sz,/rem)
printf,Unit,strcompress(str.ex,/rem)
printf,Unit,'0'
printf,Unit,strcompress(str.ez,/rem)
printf,Unit,'0'
printf,Unit,'3'
printf,Unit,'1'
printf,Unit,'1'

IF shadow3_mode EQ 0 THEN BEGIN
  free_lun,Unit
  ;xsh_run,'input_source < xsh_input_source_tmp.inp'
  command = [command,'input_source < xsh_input_source_tmp.inp']
ENDIF

; 
; run gen_source
;
;xsh_run,'gen_source start.00'
IF shadow3_mode EQ 0 THEN BEGIN
  command = [command,'gen_source start.00']
ENDIF ELSE BEGIN
  printf,Unit,'source'
  printf,Unit,'systemfile'
  printf,Unit,'exit'
  free_lun,Unit
  command = shadow3_binary+' < shadow3.inp'
ENDELSE

;
; run everything
;
xsh_run,command

if (keyword_set(remove) AND (shadow3_mode GT 0 ) ) then begin
  command='/bin/rm xsh_*_tmp.inp'
  message,/info,'Executing: '+command
  spawn,command
endif
print,'*************** SHADOW UNDULATOR SOURCE COMPLETED ***************'
end
;		
;========================================================================
;
PRO xshundul_event,event
;
; register the events
;
WIDGET_CONTROL, event.id, GET_UVALUE=eventuval
widget_control, event.top, GET_UVALUE=inp ; , /no_copy

CASE eventuval OF
	'QUIT': BEGIN
		WIDGET_CONTROL,event.top,/DESTROY
		return
		END
	'FILELOAD': BEGIN
		ffile = pickfile(title='Select Xwiggler input file...',/NOCONF)
		if strcompress(ffile,/rem) EQ '' then return
		version = ''
		restore,ffile,/VERBOSE
		if version NE xshundul_nameversion() then itmp = $
			widget_message( $
		  'Input file and current XShUndul have different versions.')
		END
	'FILEWRITE': BEGIN
		ffile = pickfile(/WRITE,file='xshundul.inp')
		if strcompress(ffile,/rem) EQ '' then goto,out
		version = xshundul_nameversion()
		command = 'save,version,inp,'+$
		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
		tmp = execute(command)
		itmp = widget_message(/INFO,'File '+ffile+ $
			' written to disk.')
		END
	'SETPAR': begin
		; help,'calling _set; event.top = ',event.top
		xshundul_set,inp,GROUP=event.top
		end
        'HELP': BEGIN
                 DOC_LIBRARY,'xshundul',PRINT='cat > xshundul.hlp'
                 XDISPLAYFILE1,'xshundul.hlp',GROUP=event.top,HEI=48,/REMOVE
                END
	'SH13':	begin
		if not(checkfile('begin.dat')) then begin
		  tmp = widget_message(/error,["File 'begin.dat' not found.",$
			'Please run SHADOW.'])
		  goto,out
		endif
		command = " plotxy,'begin.dat',1,3,/gauss"
		xwindow,group=event.top,wtitle=command,buffer=command,/edit
		end
	'SH46':	begin
		if not(checkfile('begin.dat')) then begin
		  tmp = widget_message(/error,["File 'begin.dat' not found.",$
			'Please run SHADOW.'])
		  goto,out
		endif
		command = "plotxy,'begin.dat',4,6,/gauss"
		xwindow,group=event.top,wtitle=command,buffer=command,/edit
		end
	'SH11':	begin
		if not(checkfile('begin.dat')) then begin
		  tmp = widget_message(/error,["File 'begin.dat' not found.",$
			'Please run SHADOW.'])
		  goto,out
		endif
		command = "histo1,'begin.dat',11"
		xwindow,group=event.top,wtitle=command,buffer=command,/edit
		end
	'SHINFOSH': begin
		if not(checkfile('begin.dat')) then begin
		  tmp = widget_message(/error,["File 'begin.dat' not found.",$
			'Please run SHADOW.'])
		  goto,out
		endif
		infosh,'begin.dat'
		end
	'SHSOURCINFO':	begin
		SOURCINFO
                XDISPLAYFILE1,'und1.par',GROUP=event.top,HEI=24
                XDISPLAYFILE1,'und1.info',GROUP=event.top,HEI=24
		end
ENDCASE
out:
widget_control,event.top,set_uvalue=inp ; ,/NO_COPY
END
;
;==============================================================================
;
PRO XSHUNDUL, input, GROUP=group, Only_Run=only_run
;
on_error,2

;
;if xregistered('xshundul') then return

if n_params() EQ 1 then begin
  ;if not(checkfile(file)) then begin
  ;  itmp = widget_message('Error opening file '+file,/ERROR)
  ;  return
  ;endif
  ;restore,file,/VERBOSE
  ;if version NE xshundul_nameversion() then begin
  ;  itmp = widget_message($
  ;  'Input file and current XShUndul have different versions.')
  ;  return
  ;endif
; help,input
  inp = *input
endif else begin
  inp = xsh_defaults('xshundul')
  input = 0
endelse

IF Keyword_Set(only_Run) THEN BEGIN
  XShUndul_Run,inp,group=group
  RETURN
ENDIF

if not(keyword_set(input)) then begin
  base=WIDGET_BASE(/COLUMN,TITLE=xshundul_nameversion())
  XPdMenu, [	'"File" {', $

			'"Load XShUndul input file..."   FILELOAD',$
			'"Write XShUndul input file..."  FILEWRITE',$
			'"Quit"				QUIT',$
                        '}',$
		'"Set parameters"			SETPAR',$
		'"Show" {',$
                        '"Real Space X-Z (Cols 1,3)"    	SH13',$
                        '"Divergence Space X-Z (Cols 4,6)"    	SH46',$
                        '"Energy dependence (Col 11)"    	SH11',$
                        '"Numerical values"    			SHINFOSH',$
                        '"Sourcinfo"    			SHSOURCINFO',$
                        '}',$
                '"Help"					HELP'$
          ], base


  case sdep() of
    'UNIX': font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'
    'WINDOWS': font = 'VERDANA*BOLD*ITALIC*36'  
    else: font=''
  endcase
  junk = WIDGET_LABEL( BASE, $
      FONT=font, VALUE=' SHADOWVUI ')
  junk = WIDGET_LABEL( BASE, $
      FONT=font, VALUE='   XShUndul')
  junk = WIDGET_LABEL( BASE, $
      FONT=font, VALUE='Shadow Undulator Source')
  ;help,base
  widget_control,base,set_uvalue=inp ; ,/NO_COPY
  WIDGET_CONTROL,/REALIZE,base
  XMANAGER,'xshundul',base,GROUP_LEADER=group,/no_block
endif else begin
  xshundul_set,inp,GROUP=group,input=input
endelse

end
;
