Pro xsh_pre_mlayer,inp,Group=group

;+
; NAME:
;	XSh_Pre_MLayer
;
; PURPOSE:
;	A driver for Pre_MLayer
;
; CATEGORY:
;	SHADOW GUI
;	Widgets.
;
; CALLING SEQUENCE:
;	XSh_Pre_MLayer
;
; OPTIONAL INPUTS:
;	inp: the structure with the input parameters.
;	
; KEYWORD PARAMETERS:
;	Group:	The ID of the caller Widget. It is used for the Dialog
;		windows to be positioned.
; OUTPUTS:
;	None.
;
; COMMON BLOCKS:
;	XSH_PRE_MLAYER_COMMON contains the data structure for next calls
;		of the application [when called with no input].
;
; SIDE EFFECTS:
;	Creates a temporary file (xsh_pre_mlayer_tmp.inp) and runs 
;	pre_mlayer.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Satraightforwerd.
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	December 9, 1997
;
;-

COMMON xsh_pre_mlayer_common,str1
common shadow3,shadow3_mode, shadow3_binary

IF n_elements(inp) NE 0 THEN str1=inp ELSE $
  IF n_elements(str1) EQ 0 THEN $
     str1 = xsh_defaults_preprocessors('XSH_PRE_MLAYER')

action=''
str = str1.parameters
XScrMenu,str,Titles=str1.titles,/Notype,Action=action,/Interp,NCol=2,$
 WTitle='Pre_MLayer inputs',Help=str1.help_text,Flags=str1.flags
IF action EQ 'DONT' THEN Return
str1.parameters = str

IF shadow3_mode EQ 0 THEN BEGIN
  Openw,unit,'xsh_pre_mlayer_tmp.inp',/Get_Lun
ENDIF ELSE BEGIN
  Openw,unit,'shadow3.inp',/Get_Lun
  PrintF,unit,'pre_mlayer'
ENDELSE
file = str.file
IF checkfile(file) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,/Question,$
	['File '+file+' exists.','Overwrite it?'])
  if itmp EQ 'No' then file = Dialog_Pickfile(/Write)
  if file EQ '' then return
  str1.parameters.file = file
ENDIF
PrintF,unit,file
PrintF,unit,StrCompress(str.e_min,/Rem)
PrintF,unit,StrCompress(str.e_max,/Rem)
;
; SUBATRATE, EVEN AND ODD  MATERIALS
;
FOR JJ=0,2 DO BEGIN
 CASE JJ OF
 0: BEGIN
	material=str.s_material
	density=str.s_density
	END
 1: BEGIN
	material=str.e_material
	density=str.e_density
	END
 2: BEGIN
	material=str.o_material
	density=str.o_density
	END
 ENDCASE
 ;
 ; parse the formula
 ;
 sym = 0 & frac = 0
 nn = parse_compound(material,sym,frac)
 ; help,nn
 ;
 ; density
 ;
 IF StrCompress(density,/Rem) EQ '?' THEN BEGIN
  dens = 1.0
  IF nn EQ 1 THEN dens = p_table(sym(0),/Density) ELSE $
	 itmp = Dialog_Message(Dialog_Parent=group,$
	 'I do not know the density for your compound. Set to 1') 
 ENDIF ELSE dens=density
 PrintF,unit,StrCompress(dens,/Rem)
 PrintF,unit,StrCompress(nn,/Rem)
 ;
 ; the symbol or formula
 ;
 FOR i=0,nn-1 DO BEGIN
  PrintF,unit,p_table(sym(i),/Shadow)
  PrintF,unit,StrCompress(fix(frac(i)),/Rem)
 ENDFOR
ENDFOR
 
;
; Nlayers
;
CASE StrCompress(str.type_thickness(0),/Rem) OF
  '0':BEGIN	
	PrintF,unit,StrCompress(str.n_pairs,/Rem)
	PrintF,unit,StrCompress(str.thickness,/Rem)+','+ $
		StrCompress(str.gamma,/Rem)
	PrintF,unit,'-1,-1'
	END
  '1':BEGIN
	file = str.file_thickness
	IF checkfile(file) NE 1 THEN BEGIN
	  itmp = Dialog_Message(Dialog_Parent=group,/Question,$
	        ['File '+file+' does not exists.','Load another one?'])
	  if itmp EQ 'No' then begin
	    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
		'Pre_Mlayer not run.')
	    Free_Lun,unit
	    GoTo,out
	  endif
	  file = Dialog_Pickfile()
	  if file EQ '' then begin
	    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
		'Pre_Mlayer not run.')
	    Free_Lun,unit
	    GoTo,out
	  endif
	  str1.parameters.file_thickness = file
	ENDIF
	tmp = read_textfile(file)
	PrintF,unit,StrCompress(N_Elements(tmp))
	FOR k=0,N_Elements(tmp)-1 DO PrintF,unit,tmp(k)
	END
ENDCASE
PrintF,unit,'0'
IF shadow3_mode NE 0 THEN PrintF,unit,'exit'
Free_Lun,unit

IF shadow3_mode EQ 0 THEN BEGIN
  Xsh_Run,'pre_mlayer < xsh_pre_mlayer_tmp.inp'
ENDIF ELSE BEGIN
  Xsh_Run,shadow3_binary+' < shadow3.inp'
ENDELSE

out:

IF shadow3_mode EQ 0 THEN BEGIN
  command  = '/bin/rm xsh_pre_mlayer_tmp.inp'
  Message,/info,'Executing: '+command
  Spawn, command
ENDIF
END


