PRO sourcinfo,name = name, Group = group, REMOVE = remove
;+
; NAME:
;	SOURCINFO
; PURPOSE:
;	an IDL interface of the SOURCINFO SHADOW's utility
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	sourcinfo
; INPUTS:
; OPTIONAL INPUT PARAMETERS:
; KEYWORD PARAMETERS:
;        NAME = ['name' a string with the name of the file to be
;              processed (default='end')
;        GROUP = the widget id of the group parent
;	 REMOVE = if set, remove temporary files.
; OUTPUTS:
;	a window or a text with the results of sourcinfo
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	creates temporal files and calls the SHADOW's sourcinfo
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, 8 July 1993
;	97-04-04 srio@esrf.fr adds xsh_defaults call. Cosmetics.
;       97-11-04 srio@esrf.fr uses xsh_run to spawn shadow process.
;       98-03-13 srio@esrf.fr adds Group keyword.
;       98-03-17 srio@esrf.fr checks for the existence of the file.
;       98-04-03 srio@esrf.fr cleans code, adds /Remove kw.
;-

common shadow3,shadow3_mode, shadow3_binary

on_error,2
if not(keyword_set(name)) then name='end'
file = name+'.00'

if checkfile(file) NE 1 then begin
 itmp = Dialog_Message(/Error,Dialog_Parent=group,$
	'SOURCINFO: File not found: '+file)
  return
endif
message,/info,'file analyzed is: '+file

IF shadow3_mode EQ 0 THEN BEGIN
  openw,unit,'xsh_sourcinfo_tmp.inp',/get_lun
ENDIF ELSE BEGIN
  openw,unit,'shadow3.inp',/get_lun
  printf,unit,'sourcinfo'
ENDELSE
printf,unit,file
printf,unit,'sourcinfo called from SHADOW VUI'
printf,unit,''
printf,unit,'xsh_sourcinfo_tmp.out'
IF shadow3_mode NE 0 THEN printf,unit,'exit'
free_lun,unit
;
IF shadow3_mode EQ 0 THEN BEGIN
  xsh_run,'sourcinfo < xsh_sourcinfo_tmp.inp'
ENDIF ELSE BEGIN
  xsh_run,shadow3_binary+' < shadow3.inp'
ENDELSE
wait,0.25

if sdep(/w) then begin
  xdisplayfile1,'xsh_sourcinfo_tmp.out',Group=group,Remove=remove
endif else begin
  a = read_textfile('xsh_sourcinfo_tmp.out')
  for i=0,n_elements(a)-1 do print,a(i)
  if keyword_set(remove) and (shadow3_mode EQ 0) then begin
    case sdep() of
      'UNIX': command='/bin/rm -f xsh_sourcinfo_tmp.out'
      'WINDOWS': command='del xsh_sourcinfo_tmp.out'
      else:  command = ''
    endcase
    message,/info,'Executing: '+command
    spawn,command
  endif
end
if keyword_set(remove) and (shadow3_mode EQ 0) then begin
  case sdep() of
   'UNIX': command='/bin/rm -f xsh_sourcinfo_tmp.inp'
   'WINDOWS': command='del xsh_sourcinfo_tmp.inp'
   else: command = ''
  endcase
  message,/info,'Executing: '+command
  spawn,command
endif
end
