FUNCTION vecrotvec,axisVector,vin,angle, deg=deg
;//
;+
;
; FUNCTION vecrotvec,axis,v,angle, deg=deg, noNorm=noNorm
;
; Written by M. Sanchez del Rio, ESRF, 2008
;
;// Function Name:
;//
;//   vecrotrot - Returns the vector resulting from a rotation  of vIN
;//               an angle (in rads, conterclockwise) around axisVector
;//
;// Calling Sequence:
;//
;//   vOut = vecrotvec(axisVector,vIn,angle);
;//
;// Parameters:
;//
;//   axisAngle : axis vector
;//   vIn : input vector
;//   angle : rotation angle defined in radians
;//   deg: set this flag to 1 to indicate that "angle" is in deg
;//   noNorm: Avoid normalization of axisVector (the input is normalized,
;//           this is to save execution time in loops).
;//
;// Description:
;//
;//   It uses Rodrigues' formula
;//
;-

IF keyword_set(deg) THEN angle1=angle*!dpi/180D ELSE angle1=Double(angle)

sn = sin(angle1);
cn = cos(angle1);

v1 = Double(vIn)

;
; force axis to be normalized
;
a1 = Double(axisVector)

IF Not(KEYWORD_SET(noNorm)) THEN a1 = vecnorm(a1,returnNormalized=1)


;
; Apply rodrigues' formula
;

nn = N_Elements(sn)
IF nn EQ 1 THEN BEGIN
  vOut =   v1*cn  + vecProduct(a1,v1,Norm=0)* sn + $
     vecDot(a1,v1)*(1D0-cn)*a1
ENDIF ELSE BEGIN
 Message,'Only a single angle is allowed.'
ENDELSE


; 
; apply srio's formula (rotvector.F in shadow)
;
; 
; axis_mod2 = vecdot(a1,a1)
; eta = vecdot(v1,a1)
; eta = eta/axis_mod2
; vctr0 = a1*eta
; vctr1 = v1-vctr0
; vctr3 = vecProduct(v1,a1,Norm=0)
; 
; sa = -sn/sqrt(axis_mod2)
; ca = cn
; vctr3 = sa*vctr3
; vctr1 = ca*vctr1
; 
; vctr2 = vctr1+vctr3
; vout = vctr0+vctr2
; 
; print,'vOut (srio): ',vect2string(vout)
; 
return,  vOut

END
