;
;
;extract from a data shadow-formatted file, the elements of a surface's grid
;
PRO __nrbreadshadowsurf, file, yy=yy, xx=xx, zz=zz, nx=nx, ny=ny

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(/Error,$
	'NURBS: nrbconvsurf_readshadow: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   RETURN
endif

openr, lun,file, /get_lun
readf,lun, nx,ny
nx=fix(nx)
ny=fix(ny)

yy=dblarr(ny)
readf, lun,yy

grid=dblarr(ny+1,nx)
readf, lun, grid
free_lun,lun

xx=reform(grid(0,*))

;===nx-by-ny  z grid==;
zz=reform(grid(1:ny,*))

END ; __nrbReadShadowSurf

