PRO sysinfo,n, Group = group, REMOVE = remove
;+
; NAME:
;	SYSINFO,n
; PURPOSE:
;	an IDL interface of the SYSINFO SHADOW's utility
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	sysinfo,n
; INPUTS:
;	n = the number of oe's to analyze
; OPTIONAL INPUT PARAMETERS:
; KEYWORD PARAMETERS:
;	GROUP = the id of the parent widget
;	REMOVE = if set, remove temporary files.
; OUTPUTS:
;	a window or a text with the results of sysinfo
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	creates temporal files and calls the SHADOW's sysinfo
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, 25 March 1994
;       97-04-02 MSR adds call to xsh_defaults to initialize shadow.
;       97-11-04 srio@esrf.fr uses xsh_run to spawn shadow process.
;       98-03-13 srio@esrf.fr adds Group kw
;       98-03-17 srio@esrf.fr checks if file exists
;       98-04-04 srio@esrf.fr removes /sh kw in spawn (read it from $SHELL),
;		changes file names, cleans system dependencies.
;-
on_error,2

common shadow3, shadow3_mode

if n_params() EQ 0 then n=1

file = 'end.0'+strcompress(n,/Rem)
if checkfile(file) NE 1 then begin
 itmp = Dialog_Message(/Error,Dialog_Parent=group,$
	'SYSINFO: File not found: '+file)
  return
endif

IF shadow3_mode EQ 0 THEN BEGIN
  openw,unit,'xsh_sysinfo_tmp.inp',/get_lun
ENDIF ELSE BEGIN
  openw,unit,'shadow3.inp',/get_lun
  printf,unit,'sysinfo'
ENDELSE
printf,unit,'Y'
printf,unit,n
printf,unit,'sysinfo called from SHADOW VUI'
printf,unit,''
printf,unit,'xsh_sysinfo_tmp.out'
IF shadow3_mode NE 0 THEN printf,unit,'exit'
free_lun,unit
;
IF shadow3_mode EQ 0 THEN BEGIN
  xsh_run,'sysinfo < xsh_sysinfo_tmp.inp'
ENDIF ELSE BEGIN
  xsh_run,'shadow3 < shadow3.inp'
ENDELSE
if sdep(/w) then begin
  xdisplayfile1,'xsh_sysinfo_tmp.out', Group = group , Remove = remove
endif else begin 
  a = read_textfile('xsh_sysinfo_tmp.out')
  for i=0,n_elements(a)-1 do print,a(i)
end
if keyword_set(remove) and (shadow3_mode EQ 0) then begin
  case sdep() of
    'UNIX': command='/bin/rm -f xsh_sysinfo_tmp.inp xsh_sysinfo_tmp.out'
    'WINDOWS': command='del xsh_sysinfo_tmp.*'
    else: command = ''
  endcase
message,/info,'Executing: '+command
spawn,command
endif
end
