;+
; NAME:
;       blv_rays_control
;
; PURPOSE:
;       This function creates and returns a widget base with all the widget 
;		element necessary to control
;		the property of rays.
;
; CATEGORY:
;       optic.
;
; CALLING SEQUENCE:
;		wBase=blv_rays_control, pInfo
;
; INPUTS:
;       pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

;
;====================================================================================================================
;
pro blv_rays_control_close, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_rays_control_close: error caught: '+!error_state.msg)
   RETURN
ENDIF


;purpose: close the widget
	temp=(*pInfo).wid.wRays
	(*pInfo).wid.wRays=(*pInfo).wid.tbl

	widget_control, temp, /destroy
end

;
;====================================================================================================================
;
pro blv_rays_control_add_event, event
;purpose: add rays to draw

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_rays_control_add_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.top, get_uvalue=info

widget_control, (*info.pInfoRays).wNb_rays_toAdd, get_value=quantity
widget_control, (*info.pInfoRays).wNb_rays_read, get_value=n_rays

if n_rays eq 0 then return
if quantity eq 0 then return

if quantity gt n_rays then begin
	quantity=n_rays
	widget_control, (*info.pInfoRays).wNb_rays, set_value=quantity
endif

widget_control, event.id, get_uvalue=ray
; widget_control, (*info.pInfoRays).wNB_rays_added , Get_value=ray

listRay=intarr(quantity)
for t=0, quantity-1 do begin
  listRay[t]=ray
  ray=ray+1
  if ray gt n_rays-1 then ray=0
endfor
widget_control, event.id, set_uvalue=ray


n_obj=(*info.pInfo).data.system->count()
for pos=0, n_obj-1 do begin
	((*info.pInfo).data.system->get_module(pos=pos))->getProperty, rays_image=rays_start
	n_rays_module=rays_start->count()
	if n_rays_module eq n_rays then begin
		for r=0, quantity-1 do begin
			module=(*info.pInfo).data.system->get_module(pos=pos)
;			print,'>>>> adding oe, ray: ', pos+1,listRay[r]
			module->add_ray_toDraw, listRay[r]
		;	module->getProperty, rays_element=beam
	;		ray=beam->get(listRay[r])
	;		print, '>'
	;		print, (ray->getVect())[0:2]
		endfor
	endif
endfor
blv_rays_control_print_property, info
(*info.pInfo).data.system->trace
blv_draw_system, info.pInfo
end



;
;====================================================================================================================
;
pro blv_rays_control_rays_color_event, event
;purpose: change rays color

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_rays_control_rays_color_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.top, get_uvalue=info
widget_control, event.id, get_uvalue=button
nb_module=(*info.pInfo).data.system->count()
if nb_module eq 0 then return
module=(*info.pInfo).data.system->get_module(pos=0)

case button of
	'good':begin
		module->getProperty, rays_good_color=color
		dim=Get_RGB((*info.pInfoRays).wBase, rgb=color)
		if dim.ok eq 1 then begin

			for p=0, nb_module-1 do begin
				module=(*info.pInfo).data.system->get_module(pos=p)
				module->setProperty, rays_good_color=dim.rgb
			endfor
		endif
		end
	'lost':begin
		module->getProperty, rays_lost_color=color
		dim=Get_RGB((*info.pInfoRays).wBase, rgb=color)
		if dim.ok eq 1 then begin
			nb_module=(*info.pInfo).data.system->count()
			for p=0, nb_module-1 do begin
				module=(*info.pInfo).data.system->get_module(pos=p)
				module->setProperty, rays_lost_color=dim.rgb
			endfor
		endif
		end
endcase
(*info.pInfo).data.system->trace
blv_draw_system, info.pInfo
end

;
;====================================================================================================================
;
pro blv_rays_control_print_property, info

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_rays_control_print_property: error caught: '+!error_state.msg)
   RETURN
ENDIF


nbMod=(*info.pInfo).data.system->count()
if nbMod gt 0 then begin
	module=(*info.pInfo).data.system->get_module()
	module->getProperty, rays_source=beam
	nb_rays=beam->count()
	nb_rays_added=module->count_ray_toDraw()
endif else begin
	nb_rays=0
	nb_rays_added=0
endelse

widget_control, (*info.pInfoRays).wNb_rays_read, set_value=string(nb_rays)
widget_control, (*info.pInfoRays).wNb_rays_added, set_value=string(nb_rays_added)

widget_control, (*info.pInfoRays).wAutoLoad, set_button=(*info.pInfo).data.rays_file

end

;
;====================================================================================================================
;
pro blv_rays_control_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_rays_control_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.top, get_uvalue=info
IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN begin
	blv_rays_control_close, info.pInfo
	return
endif
widget_control, event.id, get_uvalue=button
case button of
	'wTypeGroup':begin
			widget_control, (*info.pInfoRays).wTypeGroup, get_value=index
			(*info.pInfo).data.system->setProperty, rays_type_toDraw=index
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'wStyleGroup':begin
			widget_control, (*info.pInfoRays).wStyleGroup, get_value=index
			(*info.pInfo).data.system->setProperty, rays_style=index
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'VectSensitiveSource':begin
			widget_control, (*info.pInfoRays).wVectSensitiveSource, get_value=value
			(*info.pInfo).data.system->setProperty, vector_sensitive_source=value
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'VectSensitiveElement':begin
			widget_control, (*info.pInfoRays).wVectSensitiveElement, get_value=value
			(*info.pInfo).data.system->setProperty, vector_sensitive_Element=value
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end
	'VectSensitiveImage':begin
			widget_control, (*info.pInfoRays).wVectSensitiveImage, get_value=value
			(*info.pInfo).data.system->setProperty, vector_sensitive_image=value
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
			end

	'blv_rays_control_done_event': BEGIN
			;purpose: call a procedure to close the widget
			widget_control, event.top, get_uvalue=info
			blv_rays_control_close, info.pInfo
			end


	'blv_rays_control_load_event': BEGIN
			;purpose: load rays data in files.
			widget_control, /HOURGLASS
			widget_control, event.top, get_uvalue=info
			file=(*info.pInfo).data.last_file_name
			if file eq ''  then return
			;delete old beam
			widget_control, (*info.pInfo).wid.statut, set_value='Reading...'
			(*info.pInfo).data.system->delete_beam
			read_system_rays_file,(*info.pInfo).data.system, file

			n_obj=(*info.pInfo).data.system->count()
			if n_obj gt 0 then	begin
				((*info.pInfo).data.system->get_module(pos=0))->getProperty, rays_image=rays_start
				n_rays=rays_start->count()
			endif else n_rays=0
			widget_control, (*info.pInfoRays).wNb_rays_read, set_value=string(n_rays)
			widget_control, (*info.pInfo).wid.statut, set_value='Ready.'
			end

	'blv_rays_control_clear_event': BEGIN
			;purpose: remove all the draw to draw
			widget_control, event.top, get_uvalue=info
			widget_control, (*info.pInfoRays).wNb_rays_read, get_value=n_rays
			if n_rays eq 0 then return
			n_obj=(*info.pInfo).data.system->count()
			for pos=0, n_obj-1 do begin
    			  module=(*info.pInfo).data.system->get_module(pos=pos)
			  module->clear_rays_toDraw
			endfor
			blv_rays_control_print_property, info
			(*info.pInfo).data.system->trace
			blv_draw_system, info.pInfo
		
			; If restart counter is selected
			Widget_Control,event.id,Get_Value=button
			IF button EQ 'Clear+Restart' THEN Widget_Control,(*info.pInfoRays).wAdd,Set_UValue=0L

			end

	'blv_rays_control_flip_autoLoad_event': BEGIN
			widget_control, event.top, get_uvalue=info
			(*info.pInfo).data.rays_file=abs((*info.pInfo).data.rays_file-1)
			end



;	'APPLY': BEGIN
;			widget_control, (*info.pInfoRays).wNb_rays_added, Get_value=rays_shown
;
;			; first step: clean
;			widget_control, event.top, get_uvalue=info
;			widget_control, (*info.pInfoRays).wNb_rays_read, get_value=n_rays
;			if n_rays eq 0 then return
;			n_obj=(*info.pInfo).data.system->count()
;			for pos=0, n_obj-1 do begin
;    			  module=(*info.pInfo).data.system->get_module(pos=pos)
;rays_shown1=module->count_ray_toDraw()
;help,pos,rays_shown1
;			  module->clear_rays_toDraw
;			endfor
;			;blv_rays_control_print_property, info
;			widget_control, (*info.pInfoRays).wNb_rays_added, Set_value='0'
;			(*info.pInfo).data.system->trace
;			blv_draw_system, info.pInfo
;
;
;
;			; second step: draw
;
;			;widget_control, (*info.pInfoRays).wNb_rays_toAdd, get_value=quantity
;			;widget_control, (*info.pInfoRays).wNb_rays_read, get_value=n_rays
;			quantity = rays_shown
;
;			if n_rays eq 0 then return
;			if quantity eq 0 then return
;
;			if quantity gt n_rays then begin
;				quantity=n_rays
;				widget_control, (*info.pInfoRays).wNb_rays, set_value=quantity
;			endif
;
;			;widget_control, event.id, get_uvalue=ray
;			ray=0L
;			listRay=intarr(quantity)
;			for t=0, quantity-1 do begin
;			  listRay[t]=ray
;			  ray=ray+1
;			  if ray gt n_rays-1 then ray=0
;			endfor
;			;widget_control, event.id, set_uvalue=ray
;
;
;			n_obj=(*info.pInfo).data.system->count()
;			for pos=0, n_obj-1 do begin
;				((*info.pInfo).data.system->get_module(pos=pos))->getProperty, rays_image=rays_start
;				n_rays_module=rays_start->count()
;				if n_rays_module eq n_rays then begin
;					for r=0, quantity-1 do begin
;						module=(*info.pInfo).data.system->get_module(pos=pos)
;						module->add_ray_toDraw, listRay[r]
;					;	module->getProperty, rays_element=beam
;				;		ray=beam->get(listRay[r])
;				;		print, '>'
;				;		print, (ray->getVect())[0:2]
;					endfor
;				endif
;			endfor
;			blv_rays_control_print_property, info
;			(*info.pInfo).data.system->trace
;			blv_draw_system, info.pInfo
;
;			END


	else:return
endcase

end

;
;====================================================================================================================
;


;srio  ;**********************************************
;srio  ;*********************************************
;srio  ; purpose: call a procedure to close the widget and apply the current property on the current plane
;srio  pro blv_rays_control_apply_event, event
;srio  widget_control, event.top, get_uvalue=info
;srio  ;'VectSensitiveSource':begin
;srio  widget_control, (*info.pInfoRays).wVectSensitiveSource, get_value=value
;srio  (*info.pInfo).data.system->setProperty, vector_sensitive_source=value
;srio  ;'VectSensitiveElement':begin
;srio  widget_control, (*info.pInfoRays).wVectSensitiveElement, get_value=value
;srio  (*info.pInfo).data.system->setProperty, vector_sensitive_Element=value
;srio  ;'VectSensitiveImage':begin
;srio  widget_control, (*info.pInfoRays).wVectSensitiveImage, get_value=value
;srio  (*info.pInfo).data.system->setProperty, vector_sensitive_image=value
;srio  
;srio  (*info.pInfo).data.system->trace
;srio  blv_draw_system, info.pInfo
;srio  
;srio  end


function blv_rays_control, pInfo
;purpose: return and define the widget base

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_rays_control: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


wBase=widget_base(GROUP_LEADER=(*pInfo).wid.tbl,title='Rays Control',/col, /TLB_KILL_REQUEST_EVENTS, $
				event_pro='blv_rays_control_event', /floating)
	wButton=widget_base(wBase,/row)
		wDone=widget_button(wButton, value='Dismiss',UValue='blv_rays_control_done_event')
;		wApply=widget_button(wButton, value='Apply', UValue='APPLY')
	n_obj=(*pInfo).data.system->count()
		if n_obj gt 0 then begin
			((*pInfo).data.system->get_module(pos=0))->getProperty, rays_image=rays_start
			n_rays=rays_start->count()
		endif else n_rays=0

	wLoadBase=widget_base(wBase,/row)
		wLoad=widget_button(wLoadBase,value='Load',UValue='blv_rays_control_load_event')
		wLoadBaseInfo=widget_base(wLoadBase,/col)
			wTemp=widget_base(wLoadBaseInfo,/row)
				wtitle=widget_label(wTemp, value=' Stored rays:')
				wNb_rays_read=widget_label(wTemp, value=string(n_rays),/DYNAMIC_RESIZE)
			wTempBis=widget_base(wLoadBaseInfo,/NONEXCLUSIVE)
			wAutoLoad=widget_button(wTempBis,value='Auto Load', $
				UValue='blv_rays_control_flip_autoLoad_event')


	wTypeBase=widget_base(wBase,/row,/frame)
		wTypeTitle=widget_label(wTypeBase,value='Rays to visualize ')
		wTypeChoice=widget_base(wTypeBase,/col,/align_right)
			radioType=['All Rays', $
						'Good Only', $
						'Lost Only', $
						'None']
			(*pInfo).data.system->getProperty, rays_type_toDraw=rays_type_toDraw
		 	wTypeGroup=CW_BGROUP(wTypeChoice, $
            	            radioType, SET_VALUE=rays_type_toDraw, $
                	        /Col,/RETURN_INDEX, /EXCLUSIVE, $
                    	    /NO_RELEASE, uValue='wTypeGroup')
		wColorRay=widget_base(wBase,/row)
			wGoodColor=widget_button(wColorRay, value='Good rays color...', uvalue='good', $
				event_pro='blv_rays_control_rays_color_event')
			wLostColor=widget_button(wColorRay, value='Lost rays color...', uvalue='lost', $
				event_pro='blv_rays_control_rays_color_event')
	wStyleBase=widget_base(wBase,/row,/frame)
		wStyleTitle=widget_label(wStyleBase,value='Show rays as ')
		wStyleChoice=widget_base(wStyleBase,/col,/align_right)
			radioStyle=['Points', 'Vectors', 'Lines']
			(*pInfo).data.system->getProperty, rays_style=rays_style
		 	wStyleGroup=CW_BGROUP(wStyleChoice, $
            	            radioStyle, SET_VALUE=rays_style, $
                	        /Col,/RETURN_INDEX, /EXCLUSIVE, $
                    	    /NO_RELEASE, uValue='wStyleGroup')
		wVectorSensitive=widget_base(wStyleBase,/col,/base_align_right)
			wtitle=widget_label(wVectorSensitive,value='Vector Sensitive')
			(*pInfo).data.system->getProperty, vector_sensitive_source=vss, $
					vector_sensitive_element=vse, $
					vector_sensitive_image=vsi
			wVectSensitiveSource=cw_field(wVectorSensitive, title='Source ',$
					value=vss, xsize=5,/return_event,uvalue='VectSensitiveSource')
			wVectSensitiveElement=cw_field(wVectorSensitive, title='Element ',$
					value=vse, xsize=5,/return_event,uvalue='VectSensitiveElement')
			wVectSensitiveImage=cw_field(wVectorSensitive, title='Image ',$
					value=vsi, xsize=5,/return_event,uvalue='VectSensitiveImage')
	wControlBase=widget_base(wBase,/col,/base_align_right,/frame)
		wAddBase=widget_base(wControlBase,/row)
			wAdd=widget_Button(wAddBase,value='Add rays/Visualize',uValue=0L, $
				event_pro='blv_rays_control_add_event')
			wFree=widget_Button(wAddBase,value='Clear', UValue='blv_rays_control_clear_event')
			wFree=widget_Button(wAddBase,value='Clear+Restart', UValue='blv_rays_control_clear_event')
		wNb_rays_toAdd=cw_field(wControlBase,title='Number of rays to add ', $
					/integer,value=10, xsize=6)
		wNb_rays_added=cw_field(wControlBase,title='Rays shown ', $
					/integer,value=0, xsize=6)


pInfoRays=ptr_new({ wNb_rays_toAdd:wNb_rays_toAdd, $
					wNb_rays_read:wNb_rays_read, $
					wTypeGroup:wTypeGroup, $
					wStyleGroup:wStyleGroup, $
					wVectSensitiveSource:wVectSensitiveSource, $
					wVectSensitiveElement:wVectSensitiveElement, $
					wVectSensitiveImage:wVectSensitiveImage, $
					wBase:wBase, $
					wNb_rays_added:wNb_rays_added, $
					wAutoLoad:wAutoLoad, $
					wAdd:wAdd $
			 })
info={pInfoRays:pInfoRays, $
 		pInfo:pInfo}

widget_control, wBase, set_uValue=info
widget_control, wBase, /realize
blv_rays_control_print_property, info
xmanager, 'blv_rays_control', wBase, /no_block

return, wBase
end
