FUNCTION Div_Grid_Line,maxAperture,theta,npoints, $
  FILE=file,HORIZONTAL=horizontal,Group=group
;+
; NAME:
;	DIV_GRID_LINE
;
; PURPOSE:
;       This function returns the director cosines ("velocity vector")
;	of horizontal or vertical lines. 
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
;       v = Div_Grid_Line(maxAperture,npoints)
;
; INPUTS:
;       
;	maxAperture: the angular distance (rad) of the farest line from the
;		origin
;	theta: the angular length (rad) of lines, for the line that
;		sits in the origin
;	nPoints: The number of points over the line
;
; KEYWORD PARAMETERS
;	Horizontal: when set, generates horizontal lines (default=vertical)
;	File: a string cointaining a file name where to write
;		(optionally) the data. The file type is SHADOW binary.
;	Group: The widget ID of the caller. 
;
; OUTPUTS:
;       This function return the array v(3,npoints) with vx, vy and vz
;	in the columns 0,1 and 2, respectively.
;
; PROCEDURE:
;       
;       Easy.
;
; EXAMPLE:
;	v=Div_Grid_Line(0.1D0,0.1,100) &  plot,v[0,*],v[2,*]
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr), 99-12-23
;
;-

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'DIV_GRID_LINE: error caught: '+!error_state.msg)
   Catch, /Cancel
   On_Error,2
   RETURN,0
ENDIF

;
IF N_Elements(maxAperture) EQ 0 THEN maxAperture  = 0.1D0 ; rad
IF N_Elements(theta) EQ 0 THEN theta  = 0.1D0 ; rad
IF N_Elements(npoints) EQ 0 THEN npoints = 100L


mygrid = abscissas(-1.0D0*maxAperture,maxAperture,npoints)
r=1.0D0

IF Keyword_Set(horizontal) THEN BEGIN
  vz = r*theta
  vz = Replicate(vz,nPoints)
  vx = r*mygrid
ENDIF ELSE BEGIN
  vx = r*theta
  vx = Replicate(vx,nPoints)
  vz = r*mygrid
ENDELSE
vy = Sqrt( ( (vx*vx+vz*vz)*(-1.0D0)+1.0D0 )>0 )

; IF Keyword_Set(horizontal) THEN BEGIN
;   vz = r*theta
;   vx = r*tan(mygrid)
; ENDIF ELSE BEGIN
;   vx = r*theta
;   vz = r*tan(mygrid)
; ENDELSE
; vy = Replicate(1.0D0,N_Elements(mygrid))
; modv = Sqrt(vx*vx+vy*vy+vz*vz)
; vx = vx/modv
; vy = vy/modv
; vz = vz/modv                  



v=make_set(vx,vy,vz)
IF Keyword_Set(file) THEN BEGIN
  WriteSh,file,v,[4,5,6]
ENDIF
RETURN,v
end

