#
# prefs.tcl: routines for XMenu personal preferences
#
# ------------------------------------------------
# Mumit Khan <khan@xraylith.wisc.edu>
# Center for X-ray Lithography
# University of Wisconsin-Madison
# 3731 Schneider Dr., Stoughton, WI, 53589
# ------------------------------------------------
#
# Copyright (c) 1994-1996 Mumit Khan
#
#

#
# LOAD_PRES: load user-specific preferences
#
proc load_prefs {} {
    global gvars gprefs
    set pref_file $gvars(pref_file)
    vputs "Loading preferences from $pref_file..."
    if {[catch {uplevel #0 source [list $pref_file]} msg]} {
	dialog .pref {Load preferences} \
	    [build_msg \
	    "Error loading preferences from \"$pref_file\".($msg)\n" \
	    "This may be caused by files created by an older version of \n"\
	    "SHADOW. Please save the preference file again from the GUI"] \
	    {} 0 Dismiss
	return 1
    }
    vputs "Loaded preferences from $pref_file."
    return 0
}

#
# SAVE_PREFS: save current preference
#
proc save_prefs {} {
    global gvars gprefs
    set pref_file $gvars(pref_file)
    vputs "Saving preferences to $pref_file..."
    if {[catch "open $pref_file w" fid]} {
	dialog .pref {Load preferences} \
	    "Error opening preferences file \"$pref_file\"." \
	    {} 0 Dismiss
	return 1
    }
    foreach pname [array names gprefs] {
	set prefvar [format "%-35s" "set gprefs($pname)"]
	puts $fid "$prefvar [set gprefs($pname)]"
    }
    close $fid
    vputs "Saved preferences to $pref_file."
    return 0
}

proc reset_prefs_from_default {} {
    global gvars gprefs gdefprefs
    set gprefs(add_src_at_startup)	$gdefprefs(add_src_at_startup)
    set gprefs(edit_src_at_startup)	$gdefprefs(edit_src_at_startup)
    set gprefs(edit_added_obj)		$gdefprefs(edit_added_obj)
    set gprefs(show_cmd_window)		$gdefprefs(show_cmd_window)
    set gprefs(msg_window_at_bottom)	$gdefprefs(msg_window_at_bottom)
    set gprefs(balloon_help)		$gdefprefs(balloon_help)
    set gprefs(show_toolbar)		$gdefprefs(show_toolbar)
    set gprefs(cache_pages)		$gdefprefs(cache_pages)
}
