; 
;===============================================================================
;
Pro xshoe_fstat,oestr,GROUP=group,ACTION=action

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_FSTAT: Error caught: '+$
	!err_string,/error)
   return
endif

if n_elements(oestr) EQ 0 then oestr=read_gfile('exafin.exa')

titles=[ 'Angle of incidence [deg]',$
  'Distance from mirror',$
  'Z-rotation [deg]',$
  'offset X [cm] in MIRROR reference frame', $
  'offset Y [cm] in MIRROR reference frame', $
  'offset Z [cm] in MIRROR reference frame', $
  'offset X [cm] in SOURCE reference frame', $
  'offset Y [cm] in SOURCE reference frame', $
  'offset Z [cm] in SOURCE reference frame', $
  'rotation [ CCW, deg ] around X',$
  'rotation [ CCW, deg ] around Y',$
  'rotation [ CCW, deg ] around Z']

flags = replicate('1',n_elements(titles))
 
tmp =    { RTHETA:oestr.RTHETA, $
   RDSOUR:oestr.RDSOUR, $
   ALPHA_S:oestr.ALPHA_S, $
   OFF_SOUX:oestr.OFF_SOUX, $
   OFF_SOUY:oestr.OFF_SOUY, $
   OFF_SOUZ:oestr.OFF_SOUZ, $
   X_SOUR:oestr.X_SOUR, $
   Y_SOUR:oestr.Y_SOUR, $
   Z_SOUR:oestr.Z_SOUR, $
   X_SOUR_ROT:oestr.X_SOUR_ROT, $
   Y_SOUR_ROT:oestr.Y_SOUR_ROT, $
   Z_SOUR_ROT:oestr.Z_SOUR_ROT }

action=0
XScrMenu,tmp,/NOTYPE,/INTERPRET,wtitle='Source Movements',$
  FLAGS=flags,TITLES=titles,ACTION=action,GROUP=group,NCOL=2

if action eq 'DO' then copy_structure,tmp,oestr
help,oestr.Z_SOUR_ROT
print,oestr.Z_SOUR_ROT
return
end

