
;+
; 
; NAME: 
;	OE__DEFINE
;
; PURPOSE:
;	Object class and methods to handle SHADOW oe input variables.
;	Used with ShadowVUI application. 
;
; CATEGORY:
;	Object tools
;
; CALLING SEQUENCE:
;	oe1 = Obj_New('oe',input)
;	oe1-><method>
;
; F=Function, P=Procedure
;
; METHODS:
;	INIT(F)	called when the object is created with o1=Obj_New('oe',input)
;		INPUTS:
;			input: a SHADOW file 'start.00'
;
;	CLEANUP(P)	called when the object is destroyed with Obj_destroy,o1
;
;	INFO(P)	just prints a help
;
;	GETVALUE(F)   used to return the value of a variable
;		INPUTS:
;                     input: a string with the variable name
;	SETVALUE(P)   used to set the value of a variable
;		INPUTS:
;                     input: either a structure with all variables or a
;                            scalar variable with the value for the 
;                            tag set in NAME
;                     name: (optional) the tag name
;
; EXAMPLE:
;
;	oe1=obj_new('oe')
;       oe1->load,'start.01'
;       print,oe1->getValue('FMIRR')
;	oe1->setValue,3,'FMIRR'
;       print,oe1->getValue('FMIRR')
;       oe1->write,'tmp.01'
;       obj_destroy,oe1
;
;
; MODIFICATION HISTORY:
;	Initial version  by M. Sanchez del Rio, September 2011,
;
;-
;
;===============================================================================
;
PRO oe::load,file
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'oe::load: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

tmp = read_gfile(file)

copy_structure,tmp,*(self.str)

END

;
;===============================================================================
;
PRO oe::write,file
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'oe::write: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

write_gfile,*(self.str),file

END
;
;===============================================================================
;
FUNCTION oe::getvalue,input

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'oe::getvalue: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN,0
ENDIF

str =  *(self.str)
case type(input) of
 0: return,str  ; none
 7: BEGIN ; string
    itmp = tag_exist(str,input,index=index)
    IF index LT 0 THEN BEGIN
      print,'oe::getvalue: Error in keyword name: '+input
      RETURN,0
    ENDIF
    RETURN,str.(index)
    END
 2: BEGIN ; integer
    return,str.(input)
    END
 3: BEGIN ; long
    return,str.(input)
    END
 else:
endcase
 

END

;
;===============================================================================
;
PRO oe::setvalue,value,input

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'oe::setvalue: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF N_Elements(input) GT 0 THEN BEGIN 
    str =  *(self.str)
    ;command = 'str.'+StrCompress(input,/Remove_All)+' = value'
    ;itmp = execute(command)
    itmp = tag_exist(str,input,index=index)
    IF index LT 0 THEN BEGIN
      print,'oe::setvalue: Error in keyword name: '+input
      RETURN
    ENDIF
    str.(index)=value
    
     *(self.str) = str
    RETURN
ENDIF
copy_structure, value,*(self.str)

END

;
;===============================================================================
;
PRO oe::info

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'oe::info: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
help,/str,*self.str
help,/obj,self

END


;
;===============================================================================
;
PRO oe::cleanup

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
	'oe::cleanup: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF Ptr_Valid(self.str) THEN Ptr_Free,self.str
END

;
;===============================================================================
;
FUNCTION oe::init, input 



Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
    'oe::init: error caught: '+!err_string)
  Catch, /Cancel
  On_Error,2
  RETURN,0
ENDIF

IF ptr_valid( self.str ) EQ 0 THEN BEGIN
  ds=sdep(/ds)
  file = getenv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'+$
       ds+'/start_oe.nn'
;
  IF checkFile(file) NE 1 THEN BEGIN
    errMessage = 'oe__define: Error accessing file: '+file
    print,errMessage
    RETURN,0
  ENDIF

  tmp1 = read_gfile(file)
  self.str=ptr_new(tmp1)
ENDIF
CASE Type(input) OF 
 0: BEGIN       ; no input
    END
 7: BEGIN       ; string
  tmp=read_gfile(input)
  tmp1=*(self.str)
  copy_structure,tmp,tmp1
  *(self.str)=tmp1
  END
 8: BEGIN       ; structure
  tmp1=*(self.str)
  copy_structure,input,tmp1
  *(self.str)=tmp1
  END
 11: BEGIN       ; object (copy it)
  tmp=read_gfile(input)
  tmp1=*(self.str)
  copy_structure,tmp,tmp1
  *(self.str)=tmp1
  END
 else: 
ENDCASE

RETURN,1
END

;
;===============================================================================
;
PRO oe__define
  tmp = {oe, str:Ptr_New() }
END

