;+
; NAME:
;       blv_del_optical_module
;
; PURPOSE:
;       This procedure delete the current selected module.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       blv_del_optical_module, pInfo
;
; INPUTS:
;       pInfo:    A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

pro blv_del_optical_module, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_del_optical_module: error caught: '+!error_state.msg)
   RETURN
ENDIF


if (*pInfo).data.position gt -1 then begin
	(*pInfo).data.system->delete_module, posi=(*pInfo).data.position
	(*pInfo).data.position=(*pInfo).data.position-1
	;blv_show_element, pInfo
	(*pInfo).data.system->trace
	if (*pInfo).wid.wModule ne (*pInfo).wid.tbl then begin
		widget_control,(*pInfo).wid.wModule, get_uvalue=info
		widget_control, (*info.pInfoModule).wNbModule, set_value=string((*pInfo).data.system->count())
		widget_control, (*info.pInfoModule).wSelectedModule, set_value=(*pInfo).data.position+1
		blv_change_selected_module, pInfo
	endif
endif
end
