FUNCTION XSh_Defaults_Utils,program

on_error,2
program = strupcase(program)

case program of
	'XSH_BRAGG': begin
		xsh_bragg	  =  { Xbragg, $
		Structure: ['0','ZincBlende','Rocksalt','simple FCC', $
		  'CsCl structure','Hexagonal Close-Packed',  $
		  'Hexagonal Graphite'] , $
		Lattice_Cte_a: 5.43094,$
		Lattice_Cte_c: 1.0, $
		h_miller_index: 1, $
		k_miller_index: 1, $
		l_miller_index: 1, $
		Symbol_1st: 'Si', $
		Symbol_2nd: 'Si', $
		Absorption: ['1','No','Yes'], $
		Temperature_factor: 1.0, $
		Mosaic: ['0','No','Yes'] , $
		RC_mode: ['1', 'LAUE: diffr beam','BRAGG: diffr beam', $
		  'LAUE: transm beam','BRAGG: transm beam'] , $
		RC_energy: 8000., $
		Mosaic_fwhm: 0.1, $
		Thickness: 0.01, $
		Asymmetric_angle: 0.0, $
		Angular_range: 100.0, $
		Number_of_points: 200, $
		Sec_of_arc: ['0', 'Radians','Arc Sec'] , $
		Centered_curve: ['0','No','Yes'] }
		end
	'XSH_MLAYER': begin

		titles = ['Layer periodicity: ','Scanning variable: ',$
		  'Substrate: ','Odd layer material: ',$
		  'Even layer material: ', 'Photon energy [eV]:',$
		  'Grazing angle [degrees]:','Scanning variable step: ',$
		  'Number of scanning points', $
		  'Thickness [A] for odd material:', $
		  'Thickness [A] for even material:', $
		  'Number of layer pairs:','File with layer thicknesses:']
		flags = ['1','1','1','1','1','1','1','1','1',$
		  'w(0) eq 0','w(0) eq 0','w(0) eq 0','w(0) eq 1']
		xsh_mlayer	  =  { titles:titles, flags:flags, $
		parameters:{ Xmlayer, $
		mode: ['0','Periodic Layers','Individual Layers'], $
		scan: ['1','Grazing Angle','Photon Energy'], $
		Substrate: 'Si', $
		Odd_material: 'W', $
		Even_material: 'Si', $
		energy: 1000., $
		Theta: 0.42, $
		Scan_step: 100., $
		Npoints: 400, $
		Odd_thickness: 10.3, $
		Even_thickness: 41.4, $
		Nlayers: 100, $
		File: 'layers.dat'  }}
		end

	'XSH_SRCOMP': begin

		titles= [ 'Machine name', $
		          'B from:', $
		          'Machine Radius [m]', $
		          'Magnetic Field [T]', $
		          'Beam energy [GeV]', $
		          'Beam Current [A]', $
		          'Horiz div [mrad]', $
		          'Min Photon Energy [eV]', $
		          'Max Photon Energy [eV]', $
		          'Photon Energy step [eV]', $
		          'Vert div [mrad]' ]
		FLAGS=replicate('1',n_elements(titles))
		FLAGS(2) = 'w(1) EQ 0'
		FLAGS(3) = 'w(1) EQ 1'
		xsh_srcomp	  =  { titles:titles, flags:flags, $
		parameters:{Xsrcomp, $
		  Machine_name: 'ESRF', $
		  RB_choice:['1','Magnetic Radius','Magnetic Field'], $
		  Machine_R_m: 25.0, $
		  BField_T: 0.8, $
		  Beam_energy_Gev: 6.0, $
		  Current_A: 0.1, $
		  Hor_div_mrad: 1.0, $
		  Phot_energy_min: 100.0, $
		  Phot_energy_max: 100000.0, $
		  Phot_energy_step: 500.0, $
		  Vert_div_mrad: 10.0  }}
		end
	'XSH_TRANSMIT': begin
		xsh_transmit = {  Xtransmit, $
	        Empty_1: 0, $
	        Empty_2: 0, $
		Nelements:['1','1','2','3','4','5'], $
		Result: ['1', '# photons/0.1%bw', 'Watts/eV'], $
		;
		el1_des:['0','filter','mirror'], $
		el1_sym:'Be', $
		el1_thi:500.0, $
		el1_inc:88.8, $
		;
		el2_des:['1','filter','mirror'], $
		el2_sym:'Rh', $
		el2_thi:50.0, $
		el2_inc:89.83, $
		;
		el3_des:['1','filter','mirror'], $
		el3_sym:'Pt', $
		el3_thi:10.0, $
		el3_inc:88.8, $
		;
		el4_des:['0','filter','mirror'], $
		el4_sym:'Be', $
		el4_thi:10.0, $
		el4_inc:88.8, $
		;
		el5_des:['0','filter','mirror'], $
		el5_sym:'Be', $
		el5_thi:10.0, $
		el5_inc:88.8 }
		end
	'XSH_WIGGLER_SPECTRUM': begin
		titles= [ 'Magnetic field: ', $
			  'Number of periods', $
		          'Wiggler period [m]', $
		          'K value', $
		          'Beam energy [GeV]', $
		          'Min Photon Energy [eV]', $
		          'Max Photon Energy [eV]', $
		          'Photon Energy step [eV]', $
		          'Electron Beam Current [mA]' ,$
			  'File with Magnetic Field' ]
		Flags= ['1','1','w(0) ne 1','w(0) eq 0','1','1','1','1','1',$
		  'w(0) ne 0']
		xsh_wiggler_spectrum = { titles:titles, flags:flags, $
		kgap_tool:{Br:1.57,Bp:!pi},$
		parameters:{Xwiggler, $
		  Field: ['0','Sinusoidal','B from file', $
				'B from harmonics'], $
		  Nperiods: 12, $
		  Ulambda: 0.125, $
		  K: 14., $
		  Energy: 6.04, $
		  Phot_energy_min: 100.0, $
		  Phot_energy_max: 100100.0, $
		  Phot_energy_step: 10000.0 , $
		  Current: 100. , $
		  File: 'datafile' }}
		end
	else:   begin
		message,/info,'Error: Program not found'
		out = 0
		end
	endcase

;
; update values with values in
; files .shadow_defaults in that directories.
;
if sdep() EQ 'WINDOWS' then filedir = [getenv('XOP_HOME')] else $
	filedir = [getenv('XOP_HOME'),getenv('HOME')]
nfiles = n_elements(filedir)
if nfiles EQ 1 then filedir = [filedir]
for i=0,nfiles-1 do begin
  sep = sdep(/ds)
  if (sdep() EQ 'WINDOWS' and sdep(/vs) EQ '4') then $
	file = filedir(i)+sep+'shadow~1' else $
	file = filedir(i)+sep+'.shadow_defaults'
  tmp = checkfile(file)
  if tmp EQ 1 then begin
    openr,Unit,file,/GET_LUN
    command = ''
    while (not(eof(Unit))) do begin
      readf,Unit,command
      nn = strparse(command,'.',list)
      if program EQ strupcase(strcompress(list(0))) then begin
      ;print,'***'+command+'***'
      tmp = execute(command)
      endif
    endwhile
  free_lun,Unit
  message,/info,'Defaults from file: '+file+'
  endif
endfor
;
; return
;
out = 0
command = 'out = '+program
tmp = execute(command)

return,out
end
