PRO toroidmesh,Rt,Rs,ww=ww,ll=ll,nx=nx,ny=ny,x=x,y=y, $
  presurface=presurface, surf=surf, dialog_parent=dialog_parent
;+
;
;       NAME:
;               TOROIDMESH
;       PURPOSE:
;               This function calculates a mesh surface
;               with a torid.
;       CATEGORY:
;               SHADOW tools
;       CALLING SEQUENCE:
;               toroidmesh,Rt,Rs
;
; 	INPUTS:
;		Rs: Sagittal radius
;		Rt: Tangential radius (optical)
;	
; 	KEYWORD PARAMETERS
;		ww: the surface width in cm (along X)
;		ll: the surface length in cm (along Y)
;        	nx: number of points in X
;        	ny: number of points in Y
;        	x: The array with x (in this case, nx and ww are not used)
;        	y: The array with y (in this case, ny and ll are not used)
;
;		presurface: set to a file name to write the 
;			surface in SHADOW predurface format.
;		surf: set to a named variable to get the surface 
;			in a structuto of type { x:x, y:y, z:z}
;		dialog_parent: parent widget id to pass to i/o windows.
;
;       PROCEDURE:
;               Simply addition of the tangential and sagittal circles.
;
;	AUTHOR: 
;		M. Sanchez del Rio srio@esrf.eu
;	
;	MODIFICATION HISTORY:
;		2009-12-16 srio@esrf.eu written.
;
;-
on_error,2
;
; mesh
; 
IF N_Elements(x) GT 1 THEN BEGIn
  xx=x
ENDIF ELSE BEGIN
  IF N_Elements(nx) EQ 0 THEN nx = 21
  IF N_Elements(ww) EQ 0 THEN ww = 10
  xx = makearray1(nx,-double(ww)/2,double(ww)/2)
ENDELSE

IF N_Elements(y) GT 1 THEN BEGIn
  yy=y
ENDIF ELSE BEGIN
  IF N_Elements(ny) EQ 0 THEN ny = 11
  IF N_Elements(ll) EQ 0 THEN ll = 10
  yy = makearray1(ny,-double(ll)/2,double(ll)/2)
ENDELSE


zz = DblArr(nx,ny)

;
; sagittal 
;

FOR j=0,ny-1 DO BEGIN
      sagI = -xx^2
      sagI = -sqrt(sagI+rS^2) + rS
      zz[*,j]=zz[*,j]+sagI ; add sag
ENDFOR

;
; tangential
;

FOR i=0,nx-1 DO BEGIN
      tanI = -yy^2
      tanI = -sqrt(tanI+rT^2) + rT
      zz[i,*]=zz[i,*]+tanI ; add tan
ENDFOR

; xsurface1,zz,xx,yy

IF N_elements(presurface) THEN $
  matr2presur,zz,xx,yy,File=presurface

surf = {z:zz,x:xx,y:yy}

END




