PRO Xop_Ini,Old_dir=old_dir,Xop_home=xop_home

;+
; NAME:
;       XOP_INI
; PURPOSE:
;       Routine called by the main IDL procedure main.pro
;	This file if presented in binary code (xop_ini.sav) in the 
;	embedded version. 
;
; PROCEDURE:
;       Defines many variables and environment variables. 
;	
; MODIFICATION HISTORY:
;       Created 2003/12/08 version for xop 2.11 embedded with idl 6.0:
;		Merging main.pro and xop_ini.pro
;       2008/05/20 since xop 2.3, old_dir is not longer used, because 
;               XOP_WD *must* be defined at the script level.  
;               
;
;-


Forward_Function CheckFile, Read_TextFile
;Forward_Function Xop_Defaults
Forward_Function Xop_GetEnv, SDep, strsplit

;
; define common blocks
;
COMMON XHelp, FileDoc


IF Keyword_Set(xop_home) THEN SetEnv,'XOP_HOME='+xop_home

osversion = StrUpCase(!version.os_family)


;
; Get the XOP_HOME and IDL_DIR variables and set directory
; (ds) and path (ps) separators for supported systems
;
CASE osversion OF
  'UNIX': BEGIN
    XOP_HOME = GetEnv('XOP_HOME')
    IDL_DIR = GetEnv('IDL_DIR')
    ds = '/' & ps = ':'
  END
  'WINDOWS': BEGIN
    XOP_HOME = GetEnv('XOP_HOME')
    IDL_DIR = GetEnv('IDL_DIR')
    ds = '\' & ps = ';'
  END
  ELSE: BEGIN
    v = Dialog_Message(/Error, 'MAIN: Unsupported operating system')
    RETURN
  END
ENDCASE

;
; change to directory where idl was started (mainly for Unix)
;
;# srio@esrf.eu 2007-11-12 Commented!
;# For unknown reasons, the old_dir passed from the main.pro [embedded]
;# to xop_ini.sav is not the current directory, so this setup is now
;# needed.
;IF Keyword_Set(old_dir) THEN cd,old_dir

;
; Check for undefined variable XOP_HOME
;
IF (StrCompress(XOP_HOME, /Remove_all) EQ '') THEN BEGIN
      v = Dialog_Message(/Error, /Cancel, $
	 ['MAIN: XOP_HOME variable undefined.', $
          'Load XOP_HOME directory ?'])
      IF v EQ 'Cancel' THEN RETURN
      XOP_HOME = Dialog_PickFile(/Dir,Title='Load XOP_HOME directory')
      IF XOP_HOME EQ '' THEN BEGIN
        v = Dialog_Message(/Error, $
	   ['MAIN: XOP_HOME variable undefined.', $
           'Define XOP_HOME environment variable and try again!'])
	RETURN
      ENDIF
      SetEnv, 'XOP_HOME=' +XOP_HOME
ENDIF 

;
; Check for undefined variable IDL_DIR
;
IF (StrCompress(IDL_DIR, /Remove_all) EQ '') THEN BEGIN
      v = Dialog_Message(/Error, /Cancel, $
	 ['MAIN: IDL_DIR variable undefined.', $
          'Load IDL_DIR directory ?'])
      IF v EQ 'Cancel' THEN RETURN
      IDL_DIR = Dialog_PickFile(/Dir,Title='Load IDL_DIR directory')
      IF IDL_DIR EQ '' THEN BEGIN
        v = Dialog_Message(/Error, /Cancel, $
	   ['MAIN: IDL_DIR variable undefined.', $
           'Define IDL_DIR environment variable and try again!'])
	RETURN
      ENDIF
      SetEnv, 'IDL_DIR=' +IDL_DIR
ENDIF

;
; Get XOP mode 
;
XOP_MODE = Getenv('XOP_MODE')
IF XOP_MODE EQ '' THEN XOP_MODE = 'EMBEDDED'

;
; fix the IDL 5.5/Linux colour problem
;
;IF osversion eq 'UNIX' then begin
; device,true=24
; window,/pixmap &wdelete
; device,bypass_translation=0
; device,retain = 2
; device,decomposed=0
; ;print,'XOP_INI: Linux bug with colours fixed.'
;ENDIF

;
; Retain graphs by IDL
;
Device, Retain=2

;
; Set undecomposed colors for displays with more than 8-bit displays
;
Device, Get_Decomposed=decomposed ; needs IDL v5.2
IF decomposed THEN BEGIN
  Device, Decomposed=0
ENDIF
;
; Access to the xop idl code: 
;   in EMBEDDED mode, restore the modules in the "o_modules" directory
;
IF XOP_MODE EQ 'EMBEDDED' THEN BEGIN
  o_modules_dir = XOP_HOME +ds +'o_modules' +ds
  ; 
  ; load xoplibfull.sav, including all the xop idl modules
  ; 
  Message, /Info, 'Restoring main module xoplibfull.sav '
  restore,o_modules_dir+'xoplibfull.sav'

  ; 
  ; restore other modules in o_modules dir
  ;
  list_file = FindFile(o_modules_dir+'*.sav',Count=nModules)
  IF nModules GT 1 THEN BEGIN
    FOR i=0,nModules-1 DO BEGIN
      fname = list_file[i]
      IF (strpos(fname,'xoplibfull.sav'))[0] EQ -1 THEN BEGIN
        Message, /Info, 'Restoring optional module ' +fname
        command = "Restore, '" +fname +"'"
        stat = Execute(command)
        IF (stat NE 1) THEN BEGIN
          v = Dialog_Message(/Info, $
          ['XOP_INI: Error executing XOP_USER_INI: ' +command, $
          !error_state.msg]) 
        ENDIF
      ENDIF
    ENDFOR
  ENDIF
  ;
  ; Include "extensions" directory and subdirectories in IDL system path
  ;
  !path = !path +ps +Expand_Path('+'+XOP_HOME +ds +'extensions')
ENDIF ELSE BEGIN
  ; done now with environment variable
  ;!path = Expand_Path('+'+XOP_HOME +ds +'src_idl')+ps+!path
ENDELSE


;
; Read optional environment variables from the file $XOP_HOME/xop_ini.env 
; (if exists). This option is useful in Windows systems. In Unix, it is
; preferred to define the environment variables in the xop starting script. 
;
env_file = XOP_HOME  +ds +'xop_ini.env'

IF (File_info(env_file)).regular THEN BEGIN
  Message, /Info, 'Reading environment from file: ' +env_file
  text = Read_TextFile(env_file)
  nEnv = N_Elements(text)
  FOR i=0,nEnv-1 DO BEGIN
    ;command = StrCompress(text[i], /Remove_all)
    command = StrCompress(text[i])
    IF command NE '' AND StrMid(command, 0, 1) NE ';' THEN BEGIN
      Message, /Info, 'Setting environment variable: ' +command
      command = "xop_setenv, '" +command +"'"
      stat = Execute(command)
      IF (stat NE 1) THEN v = Dialog_Message(/Info, $
        ['XOP_INI: Error executing XOP_USER_INI: ' +command, $
          !error_state.msg]) 
    ENDIF
  ENDFOR
ENDIF 

;
; Get XOP auxiliar environmental variables 
;
XOP_MODE         = Xop_GetEnv('XOP_MODE')
;XOP_ENV          = Xop_GetEnv('XOP_ENV')
DABAX_PATH       = Xop_GetEnv('DABAX_PATH')
DABAX_HELP       = Xop_GetEnv('DABAX_HELP')
XOP_BINARIES     = Xop_GetEnv('XOP_BINARIES')
XOP_DEFAULTS_DIR = Xop_GetEnv('XOP_DEFAULTS_DIR')
;XOP_USER_HOME    = Xop_GetEnv('XOP_USER_HOME')
XOP_PROJECT      = Xop_GetEnv('XOP_PROJECT')

;
; Set some XOP default environment variables if undefined
;
IF StrCompress(DABAX_PATH, /Remove_All) EQ '' THEN $
  Xop_SetEnv, 'DABAX_PATH=' +XOP_HOME +ds +'data' +ds +'dabax'
IF StrCompress(DABAX_HELP, /Remove_All) EQ '' THEN $
  Xop_SetEnv, 'DABAX_HELP=' +XOP_HOME +ds +'doc'
IF StrCompress(XOP_BINARIES, /Remove_All) EQ '' THEN BEGIN
  CASE osversion OF 
    'UNIX': BEGIN
      tmp=''
      Spawn, XOP_HOME +'/xop_uname', tmp
      Xop_SetEnv, 'XOP_BINARIES=' +XOP_HOME +ds +'bin.' +tmp[0]
    END
    'WINDOWS': BEGIN
      Xop_SetEnv, 'XOP_BINARIES=' +XOP_HOME +ds +'bin.x86' 
    END
  ENDCASE
ENDIF

IF StrCompress(XOP_DEFAULTS_DIR, /Remove_All) EQ '' THEN BEGIN
  IF osversion EQ 'UNIX' THEN $
    Xop_SetEnv, 'XOP_DEFAULTS_DIR=' +Xop_GetEnv('HOME') +ds +'.xop' ELSE $
    Xop_SetEnv, 'XOP_DEFAULTS_DIR=' +XOP_HOME +ds +'mydefaults' 
ENDIF

; XOP will start its main window and load a menu bar from the file 
; $XOP_HOME/ifc/<XOP_PROJECT>.menu and a PNG image from file
; $XOP_HOME/ifc/<XOP_PROJECT>.png 
;
IF StrCompress(XOP_PROJECT, /Remove_All) EQ '' THEN Xop_SetEnv, 'XOP_PROJECT=xop'



;
; Define the help path for XHelp (in COMMON block)
;
tmp = expand_path('+'+Xop_Getenv('XOP_HOME')+ds+'doc',/all_dirs)
filedoc = strsplit(tmp,sdep(/ps),/extract)

; extend it with the "*doc" directories in $XOP_HOME/extensions 
tmp = expand_path('+'+Xop_Getenv('XOP_HOME')+sdep(/ds)+'extensions',/all_dirs)
list=strsplit(tmp,sdep(/ps),/extract)
goodi=where(strmatch(list,'*doc') eq 1)
IF goodi[0] NE -1 THEN filedoc=[filedoc,list[goodi]]

FOR i=0,N_Elements(filedoc)-1 DO !help_path=!help_path+sdep(/ps)+filedoc[i]


;
; Set XOP default working directory
;
Xop_WD, /Default

;
; Check it is writable
;
fileWritable:
IF file_test('.',/write) EQ 0 THEN BEGIN
   itmp = Dialog_Message(/Error,/Question,$
       ['Warning: XOP cannot write in the current directory','', $
	'XOP needs a working directory with write permission,',$
	'because it writes temporary files.','',$
	'Do you want to change directory now?']) & help,itmp
   IF itmp EQ 'Yes' THEN BEGIN
     Xop_WD
     GoTo,fileWritable
   ENDIF ELSE BEGIN
     cd,current=pwd
     itmp = Dialog_Message(['Warning: Current directory not writable: ',pwd])
   ENDELSE
ENDIF

;
; Start Xop task
;
XOP_TASK = Xop_GetEnv('XOP_TASK')
IF (StrCompress(XOP_TASK, /Remove_all) EQ '') THEN BEGIN
  XOP_TASK = 'XOP'
  setenv,'XOP_TASK=XOP'
ENDIF
stat = Execute(XOP_TASK)
IF (stat NE 1) THEN BEGIN
  v = Dialog_Message(/Error, 'MAIN: Unknown task "' +XOP_TASK + '"')
  RETURN
ENDIF

;print,'XOP_INI is at scope_level: ',scope_level()

END ; xop_ini
