PRO zoomset,set,set1
;+
; NAME:
;	ZOOMSET
;
; PURPOSE:
;	This procedure plot a set or two sets of data and allow s
;	a zoom.
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	ZOOMSET, set
;
; INPUTS:
;	set:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	set1:	fltarr(2,npoints) set of data to be overplotted
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Sucesive graphics
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		ZOOMSET,set,set1
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993
;-
;
on_error,2
n_par = n_params()
print,'n_par = ',n_par
;
settmp=set
plotset,settmp
if (n_par eq 2) then plotset,set1,/over
repeat begin
  print,' Please, click the lower left point for the zoom: ? '
  cursor,x1,y1,3
  plotset,[x1,y1],psym=1,/over
  print,' Please, click the upper right point for the zoom: ? '
  cursor,x2,y2,3
  plotset,[x2,y2],psym=1,/over
  ;
  rect=fltarr(2,5)
  rect(0,*)=[x1,x2,x2,x1,x1]
  rect(1,*)=[y1,y1,y2,y2,y1]
  plotset,rect,/over
  ;
  pause
  xmin=min([x1,x2])
  xmax=max([x1,x2])
  ymin=min([y1,y2])
  ymax=max([y1,y2])
  plotset,settmp,xrange=[xmin,xmax],yrange=[ymin,ymax],psym=-1
  if (n_par eq 2) then plotset,set1,/over
  ;
  i_again = getyesornot(' Zoom again ? [n]')
endrep until not(i_again)
;
return
end
