;
;======================================================================
;
pro xafs9_show,text
font = $
'-b&h-lucida-bold-r-normal-sans-34-240-100-100-p-216-iso8859-1'
;'-microsoft-ms serif-medium-r-normal--43-258-120-120-p-190-microsoft-ansi'
xdisplayfile1,text=text,font=font, /noscroll, $
	heigh=n_elements(text),widt=max(strlen(text))
end
;
;======================================================================
;
pro xafs9_demo

set1=0  & set2=0  &  set3=0  & set4=0  &e0=0
;
xafs9_show,'Starting XAFS 9 XAID demo'
;

MENU:
imenu = wmenu2(['Library demo','XAFS extraction demo',$
	'GUI demos','dabax data base (IDL GUI)','dabax data base (WWW GUI)',$
	'End'])
  case imenu of
    0: goto,LIBRARY
    1: goto,CNPICK
    2: begin
	xplot
	goto,MENU
       end
    3: begin
	dabax_gui
	goto,MENU
       end
    4: begin
	command = $
	'netscape -install http://expgb.esrf.fr:8080/cgi-bin/DBIntro &'
        message,/info,'Executing: '+command
	spawn,command
	goto,MENU
       end
    5: return
  endcase

LIBRARY:
;xafs9_show,'Getting file name...'
file = 'co.mu'
;
command = 'set1=rascii('+"'"+file+"')"
xafs9_show,['Loading file:',command]
message,/info,'Executing: '+command  &  itmp = execute(command)
;
;
command = 'plotset,set1'
xafs9_show,['Plotting set:',command]
message,/info,'Executing: '+command  &  itmp = execute(command)

command = 'e0 = gete0(set1)'
xafs9_show,['Getting Eo from max of derivative:',command]
message,/info,'Executing: '+command  &  itmp = execute(command)
xafs9_show,['Result = '+string(e0)]

command = 'plotset,[[e0,-1e5],[e0,1e5]],/over'
xafs9_show,['Showing Eo:',command]
message,/info,'Executing: '+command  &  itmp = execute(command)
xafs9_show,'Done'

commands = ['set2 = e2k(set1,e0='+strcompress(e0)+')','plotset,set2']
xafs9_show,['Changing to wavenumber:',commands]
for ii=0,n_elements(commands)-1 do begin
  message,/info,'Executing: '+commands(ii)  &  itmp = execute(commands(ii))
endfor

command = 'postedge,set2,set3'
xafs9_show,['Getting atomic absorption:',command]
Message,/info,'Executing: '+command  &  itmp = execute(command)
xafs9_show,'Done.'

command = 'plotset,set3,/over,psym=1'
xafs9_show,['Overplotting fit:',command]
Message,/info,'Executing: '+command  &  itmp = execute(command)

itmp='Yes'
while itmp EQ 'Yes' do begin
  command = 'zoomset,set2,set3'
  xafs9_show,['Zoom:',command]
  Message,/info,'Executing: '+command  &  itmp = execute(command)
  itmp = widget_message(/question, 'Again?')
endwhile

command = 'set3(1,*)  = (set3(1,*)  - set2(1,*) ) / set2(1,*)'
xafs9_show,['Normalization (experimental):',command]
Message,/info,'Executing: '+command  &  itmp = execute(command)

command = 'plotset,set3,xrange=[0,11],yrange=[-.2,.2]'
xafs9_show,['Plotting Exafs: ',command]
Message,/info,'Executing: '+command  &  itmp = execute(command)
xafs9_show,'End of Library Demo'
wdelete
goto,MENU

CNPICK:
command = 'cnpick'
xafs9_show,['Main program CNPICK: ',command]
Message,/info,'Executing: '+command  &  itmp = execute(command)
xafs9_show,'End of CNPICK Run'
wdelete

command = "xdisplayfile1,'cnpick.log',heigh=40"
xafs9_show,['Showing log file cnpick.log...','.run cnpick.log (to execute)']
Message,/info,'Executing: '+command  &  itmp = execute(command)
goto,MENU



end

