PRO        ftrset,setin1,fourier,XRANGE=xrange,RRANGE=rrange, WINDOW=window,   $
               KPOWER=kpower,LEEANDBENI=f_lb,LBCOEFF=a_lb,         $ 
	       WINDPAR=windpar, PLOTWINDOW=plotwindow,INQUIRE=inquire, $
	       METHOD=method,PLOTFOURIER=plotfourier,_EXTRA=extra
;
;+
; NAME:
;	FTRSET
;
; PURPOSE:
;	This procedure calculates the Fourier Transform of a Exafs spectrum
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	FTRSET, setin, fourier
;
; INPUTS:
;	setin:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	XRANGE=[xmin,xmax] : range of the abscisas for the transformation	
;	RRANGE=[rmin,rmax] : range of the congugated variable for 
;		the transformation	
;	WINDOW = kind of window:
;		0 Gaussian Window 
;		1 Hanning Window
;		2 No Window (default)
;		3 Parzen (triangular)
;		4 Welch
;		5 Hamming
;		6 Tukey
;		7 Papul
;		8 Kaiser
;	KPOWER Power of K to weight the spectrum (default=0)
;	LEEANDBENI Lee and Beni correction. If set to 1 use this
;		correction with coefficients defined in LBCOEFF
;	LBCOEFF A float*4 array with the 4 coefficients
;	WINDPAR Parameter for windowing
;		If WINDOW=(1,3,4,5) this sets the width of
;		the appodization (default=0.2)
;		If WINDOW=8 sets the t parameter 0<t<=10.
;	PLOTWINDOW  when set to 1 then plot the window
;	INQUIRE  when set to 1 ask about change parameters
;	METHOD method used for calculating the Fourier Transform:
;		0 Standard Fourier transform (default)
;		1 Fast Fourier Transform
;	PLOTFOURIER  when set to then plot the ftr:
;		1 plot Modulus; 2 plot Imag; 3 Real; 4 Mod+Imag
;
;	Any other keyword is passed to the calculating procedures FTR 
;	or FASTFTR
;
; OUTPUTS:
;	"This function returns a 4-columns array (fourier) with
;	the congugare variable (R) in column 0, the modulus of the
;	FT in col 1, the real part in col 2 and the imaginary part in
;	col 3.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	This procedure calls other IDL procedures such as FTR or FASTFTR
;	for calculating the F.T. and WINDOW_FTR to generate the window
;
; EXAMPLE:
;		FTRSET,setin,fourier,/inq
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	March, 1993	
;	98-10-02 srio@esrf.fr fix doc: kpower default is zero. 
;	  Added _EXTRA keyword to be passed to either ftr or fastftr.
;       2009-05-29 srio@esrf.eu debugging: input data sorted
;-
on_error,2
;
setin=setin1

xx=setin(0,*)
yy=setin(1,*)
npoint=n_elements(xx)

;
; sort data (necessary for "down" spectra, i.e., k in reverse order
; srio@esrf.eu 2009-05-29
;
isort = sort(xx)
xx=xx[isort]
yy=yy[isort]
setin = Make_Set(xx,yy)

;
; Keywords setup
;
if not(keyword_set(xrange)) then begin
  xmin = min(xx)
  xmax = max(xx)
endif else begin
  xmin=xrange(0)
  xmax=xrange(1)
endelse
;
if not(keyword_set(rrange)) then begin
  rmin = 0.0
  rmax = 6.0
endif else begin
  rmin=float(rrange(0))
  rmax=float(rrange(1))
endelse
;
if not(keyword_set(window)) then begin
  window = 2
endif
;
if not(keyword_set(kpower)) then kpower=0
;
if not(keyword_set(LeeAndBeni)) then f_lb=0
;
if not(keyword_set(windpar)) then begin
   if (window eq 8) then windpar=40.0 else windpar=0.2
endif
;
if keyword_set(leeandbeni) then begin
  if not(set_keyword(lbcoeff)) then begin
    a_lb = fltarr(4)
  endif
endif
;
if not(keyword_set(method)) then method=0
;
; inquire about changes
;
if keyword_set(inquire) then begin
  command = ' '
  repeat begin
    print,'*************************************************************'
    print,'       xmin = ',xmin
    print,'       xmax = ',xmax
    print,'       rmin = ',rmin
    print,'       rmax = ',rmax
    print,'       kpower (power of the k) = ',kpower
    print,'       method = ',method
    print,'          0 = Standard Fourier Transform'
    print,'          1 = Fast Fourier Transform'
    print,'       window = ',window
    print,'          0 = Gaussian Window'
    print,'          1 = Hanning Window'
    print,'          2 = boxcar window (no window)'
    print,'          3 = Parzen (triangular) window'
    print,'          4 = Welch window '
    print,'          5 = Hamming window'
    print,'          6 = Tukey window'
    print,'          7 = Papul window'
    print,'          8 = Kaiser window'
    if ((window eq 1) or $
        (window eq 3) or $
        (window eq 4) or $
        (window eq 5) or $
        (window eq 6) or $
        (window eq 7) )  then $
        print,'                windpar (width of appodization) = ',windpar
    if (window eq 8) then $
        print,'                angle for Bessel function [deg] = ',windpar
;
    print,'       f_lb (lee & beni correction) = ',f_lb
    if (f_lb eq 1) then begin
      print,'     the 4 coefficients of lee&beni correction are: '
      for i=0,3 do begin
        print,'   '+strcompress( 'a_lb('+i+') = ' )+' '+a_lb(i)
      endfor
    endif
    print,'*************************************************************'
    i_change = getyesornot(' Do you want to change these parameters ? [y/n] ')
    if (i_change eq 1) then begin
     i_ok = 0
     print,' For changing, type "parameter = newvalue". "-1" to end'
     repeat begin
       read,command
         if (command eq '-1') then begin
           i_ok=1
         endif else begin
           i_flag = execute(command)
           if (i_flag ne 1) then print,'Error asigning variable.'
         endelse
     endrep until i_ok
    endif
  endrep until (i_change eq 0)
endif
;                                                                               
; prepare the ftr windows 
;                                                                               
cutset,setin,zz1,xrange=[xmin,xmax]
window_ftr,zz1,wind,zz2,window=window,windpar=windpar
tk=zz2(0,*)
; debuug srio 96/08/21
;tchi=zz2(1,*)*wind(1,*)
tchi=zz2(1,*) 
npoint2=n_elements(tk)
;
if keyword_set(plotwindow) then begin
;  print,'plotting window, weighted and original spectra...'
  plot,wind(0,*),wind(1,*),xrange=[xmin,xmax],yra=[-1.1,1.1]
  oplot,tk,tchi
  oplot,xx,yy
  pause
endif
;
; weight the data and correct the phase if necessary
;
ichi=fltarr(npoint2)
if (kpower ne 0) then tchi=tchi*tk^kpower 
if (f_lb eq 1) then begin
  for i=0,j-1 do begin
    phi=a_lb(0)+a_lb(1)*tk(i)+a_lb(2)*tk(i)^2+a_lb(3)/tk(i)^3             
    phi=-phi                                                                
    ichi(i)=-tchi(i)*sin(phi)                                               
    tchi(i)=tchi(i)*cos(phi)                                                
  endfor
endif
;                                                                               
; main calculation
;                                                                               
ftrin=fltarr(3,npoint2)
ftrin(0,*)=tk
ftrin(1,*)=tchi
ftrin(2,*)=ichi
nf = 512                                                                
;
if not(keyword_set(method)) then begin            ; standard ft
  ftr,ftrin,fourier,npoint=nf,rrange=[rmin,rmax],_extra=extra
endif else begin                                  ; fft
  fastftr,ftrin,fourier,rrange=[rmin,rmax],_extra=extra
endelse
;
; plot results 
;
if keyword_set(plotfourier) then begin
  ;plot,fourier(0,*),fourier(3,*),xra=[rmin,rmax] 
  case plotfourier of
  1: plotset,fourier([0,1],*),xra=[rmin,rmax] 
  2: plotset,fourier([0,3],*),xra=[rmin,rmax] 
  3: plotset,fourier([0,2],*),xra=[rmin,rmax] 
  4: begin	
	ymax = max( [max(fourier(1,*)),max(fourier(3,*))] )
	plotset,fourier([0,1],*),xra=[rmin,rmax],yra=[-ymax,ymax] 
	plotset,fourier([0,3],*),/over
	end
  endcase
  ;oplot,fourier(0,*),fourier(1,*)
endif
;
return                                                                  
end                                                                     
