pro fitset,exper,fitout, VERBOSE=verbose, PLOT=plot, DEGREE=degree, $
METHOD = method, XRANGE=xrange
;+
; NAME:
;	FITSET
;
; PURPOSE:
;	This procedure fits the part of the spectrum defined between 
;	the limits in xrange with a polynomial using either the 
;	Least square method or the SVD
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	FITSET, set_in, set_out
;
; INPUTS:
;	set_in:	fltarr(2,npints) set of input data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	VERBOSE: when set to 1 prints the statistics of the fit
;	PLOT: when selected, overplots the fitted set
;	DEGREE: degree of polynomial for fitting (Default=1)
;	METHOD: method for the fitting:
;		[0] Linear fit 
;		[1] Polynomial Least-Square fit (Default) 
;		[2] Polynomial Singular Value Decomposition
;		[3] Victoreen fit (not working yet)
;
; OUTPUTS:
;	set_out: set of output data (with the pre-edge fit)
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Uses the IDL procedures LINFIT (Linear fit) POLY_FIT (Least 
;	Squares) and SVDFIT (Singular Value Decomposition)
;
; EXAMPLE:
;
;		FITSET, myset, myfit
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	93-04-08 MSR adds polynomial features
;	93-05-24 MSR changes name from PREEDGE to FITSET; adds XRANGE
;	03-12-09 MSR adds LINFIT for linear fit.
;-
;
;on_error,2
;
if not(keyword_set(degree)) then degree=1
if N_Elements(method) EQ 0 then method=1
if not(keyword_set(xrange)) then xrange=[min(exper),max(exper)]
;
; select only the points in the interval
;
cutset,exper,smallset,xrange=xrange
npoints = n_elements(smallset(0,*))
smallsetx = fltarr(npoints)  &  smallsety = fltarr(npoints)
smallsetx(*) = smallset(0,*)     &  smallsety(*) = smallset(1,*)
;
; makes the fit 
;     coeff = coefficients
;     fitset = fitted line
;
;yfit = 1.
;help,yfit
;print,' **** method is:',method
;print,' **** degree is:',degree
case method of
  0:  coeff=linfit(smallsetx,smallsety)
  1:  coeff=poly_fit(smallsetx,smallsety,degree,yfit,error,sigma,amatrix)
  2:  coeff=svdfit(smallsetx,smallsety,degree+1,yfit=yfit) 
  3:  print,'Not implemented yet'
;coeff=svdfit(smallsetx,smallsety,degree+1,funct='tcheb',yfit=yfit)
endcase
;
;help,yfit
;oplot,smallsetx,yfit,psym=1
;oplot,smallsetx,smallsety,psym=2
;
; print parameters
;
if keyword_set(verbose) then begin
  print,' the fitting parameters are y = c(0) + c(1)x + c(2)x^2 + ...  with: '
  for i=0,degree do begin
    print,' c(',i,') = ',coeff(i)
  endfor
  ;  print,'fitted values are: '
  ;  print,foo
  ; print,'error estimation is: '
  ; print,error
  ; print,'mean deviation = ',sigma
  ; print,'Correlation Matrix is: '
  ; print,amatrix
endif
fitset=exper
fitset(1,*)=coeff(0)
for i=1,degree do fitset(1,*) = fitset(1,*) + (fitset(0,*)^i)*coeff(i)
;
fitout=fitset
;
if keyword_set(plot) then plotset,fitout,/over
;
return
end 
