function GETJUMP, exper, ask=ask, Dialog_Parent=dialog_parent,$
  iMode=iMode,nomouse=nomouse,noplot=noplot
;
;+
; NAME:
;	GETJUMP
;
; PURPOSE:
;	This function inputs the jump of a xafs spectrum
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	myjump = GETJUMP(myset)
;
; INPUTS:
;	myset:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;       IMODE: 0 (default) Uses the default value
;	       1 gets jump from cursor 
;	       2 inputs data
;	DIALOG_PARENT: this keyword is passed to dialogs for centering
;		the widget with a parent widget.
;	NOPLOT: set this keyword to avoid refreshing plots when IMODE=1
;
; OUTPUTS:
;	myjump: the value with the jump
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The jump value is read with the mouse 
;
; EXAMPLE:
;
;		jump = GETJUMP (set2)
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	93-05-24 MSR small modifications
;	94-10-10 MSR NOMOUSE keyword.
;	96-08-13 MSR (srio@esrf.fr) changes wmenu->wmenu2 and 
;		xtext->Dialog_Message
;	00-02-12 MSR (srio@esrf.fr) adds Dialog_Parent keyword
;	06-03-06 srio@esrf.fr removes non-widget code. IMODE kw.
;		NOMOUSE no longer used (kept for compatibility)
;	09-05-20 srio@esrf.eu changes the default algorithm
;-
;
on_error,2
IF N_Elements(imode) EQ 0 THEN imode=0
jump=0.0
;

CASE imode OF
  0: BEGIN
       ;
       ; automatic calculation of jump (mean value of the points sitting
       ; in the normalized interval interval [0.05,0.15]*spectum_length 
       ; after Eo
       ;
       ;IF not(keyword_set(noplot)) then plotset,exper
       e0 = gete0(exper)

       ;
       ; remove pre-edge linear fit
       ;
       t0 = Min(exper[0,*],max=t1)
       IF (t1-t0) GT 10 THEN kev_flag=0 ELSE kev_flag=1
       str = xaid_defaults('defaults')
       eStart=str.eStart
       eEnd=str.eEnd
       IF kev_flag THEN eStart=eStart*1e-3
       IF kev_flag THEN eEnd=eEnd*1e-3

       xrange=[t0+eStart,e0-eEnd]
       fitset,exper,fit1,method=0,xrange=xrange
       fit11 = exper
       fit11[1,*] = exper[1,*]-fit1[1,*]
       IF not(keyword_set(noplot)) then plotset,fit11
       cutset,exper,tmpSet,xrange=xRange
       meanPre = Mean(exper[1,*])

       xmin_good = e0 + 0.05*abs(t1-t0)
       xmax_good = e0 + 0.15*abs(t1-t0)
       cutset,fit11,good,xrange=[xmin_good,xmax_good]

       jump=abs(mean(good(1,*)))

       ;good(1,*) = good(1,*)*0.0+meanpre
       ;IF not(keyword_set(noplot)) then plotset,good,/over
       IF not(keyword_set(noplot)) then oplot,good(0,*),good(1,*)*0
       IF not(keyword_set(noplot)) then oplot,good(0,*),good(1,*)*0+jump
     END
  1: BEGIN ; cursor
       itmp = Dialog_Message(/info,['Click two points:', $
	  'The baseline and the ', $
	  ' upper point for jump'],Dialog_Parent=dialog_parent)
       cursor,tmp,tmp2,3
       plotset,[tmp,tmp2],/over,psym=1
       cursor,tmp,tmp1,3
       plotset,[tmp,tmp1],/over,psym=1
       jump = Abs(tmp1-tmp2)
      END
   2: BEGIN  ; input value
       tmp = { n:1.0 }
       XscrMenu,tmp,/NoType,Titles='Jump value:',Wtitle='Input Jump', $
	 action=action,Dialog_Parent=dialog_parent
         if action eq 'DO' then jump=Abs(tmp.n)
      END
ENDCASE
;
return,jump
end
