FUNCTION getedge,setin,value,sort=sort
;+
; NAME:
;	GETEDGE
;
; PURPOSE:
;	This function calculates the EDGE of a curve
;
; CATEGORY:
;	XAID package
;
; CALLING SEQUENCE:
;
;	value = getedge(set [,value])
;
; INPUTS:
;	set: a fltarr(2,npts) with the curve
;
; OPTIONAL INPUTS:
;	value: a float number in the (0,1] interval indicating the 
;		height level for the curve edge.
;
; KEYWORD PARAMETERS:
;	GROUP = The widget ID of the widget that calls GETEDGE.
;		When this ID is specified, and GETEDGE fails to calculate
;		a result, them a widget message appears.
;
; OUTPUTS:
;	The EDGE value
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		set = fltarr(2,100) 
;		set[0,*] = findgen(100)+1 & set[1,*]=sin(!pi*set[0,*]/100)
;		a = GetEdge(set,0.8)
;		print,a
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio.
;	November 2nd, 1998. Based on GetFWHM()	
;
;-

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(/Error,$
	'GETEDGE: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   return,0
endif


IF N_Elements(value) EQ 0 THEN value=0.5
set=setin
IF keyword_set(sort) THEN BEGIN
  good = uniq( set[0,*], sort(set[0,*]))
  set = fltarr(n_elements(setin[*,0]),n_elements(good))
  for i=0,n_elements(setin[*,0])-1 do set[i,*]=setin[i,good]
ENDIF
z1=set(1,*)
x = set(0,*)
;
tmp=0
hm = (value*abs( max(z1,min=tmp)-tmp ))+tmp
npts = n_elements(z1)
;
;
xleft = 0L
j = 1L & i_found = 0
while (i_found eq 0) and (j le npts-1) do begin
  if (z1(j-1) lt hm) and (z1(j) ge hm) then begin
    xleft = j
    i_found = 1
  endif
  j = j+1
end
;
; linear interpolation  left
m = (z1(xleft-1) - z1(xleft)) / (x(xleft-1) - x(xleft))
n = z1(xleft) - m*x(xleft)
xxl = (hm - n)/m

;
return,xxl
end
