;
;========================================================================
;

PRO xaid_mu2chi_calc,set,str ,out=out, coltitles=coltitles, $
  xplot=xplot, write=write, file=file, dialog_parent=dialog_parent

;+
;
;PRO xaid_mu2chi_calc,set,str ,out=out, coltitles=coltitles, $
;  xplot=xplot, write=write, file=file, dialog_parent=dialog_parent
;
;
; xplot=0 no xplot window
; xplot=1 start xplot
; xplot=2 ask for confirmation (/write must be set)
;
; output: out, coltitles
;
; 2006-07-21 srio@esrf.fr fix a bug with jump
;
;-

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(Dialog_Parent=id,$
       /Error,'XAID_MU2CHI_CALC: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif


x_e=Reform(set[0,*])
y_mu=Reform(set[1,*])

;
; calculate k
;
tmp = e2k(set,e0=str.e0)
x_e0=x_e-str.e0
x_k=Reform(tmp[0,*])


; 
; preedge
;
y_pre = y_mu*0
IF str.preMin NE str.preMax THEN BEGIN
     fitset,Make_Set(x_e,y_mu),fit1,method=0, $
     xrange=[str.preMin,str.preMax],/VERBOSE
     y_pre = Reform(fit1[1,*])
ENDIF 
y_mupre = y_mu - y_pre

;
; normalization
;
y_muNor=y_mupre
IF str.jump NE 0 THEN y_muNor=y_mupre/Abs(str.jump)     

;
; postedge
spl = postedge_evaluate(Make_Set(x_k,y_mupre),spl_n=str.npol,$
    spl_degree=str.degree, spl_knots=str.knots)

IF N_Elements(spl) LE 1 THEN y_pos = x_k*0 ELSE $
  y_pos = Reform(spl[1,*])


CASE  Fix((str.extraction)[0]) OF
   0: BEGIN; experimental
      IF str.jump EQ 0 THEN y_chi=x_k*0 ELSE $
        y_chi  = (y_mupre - y_pos) / str.jump
      END
   1: BEGIN ; constant
        y_chi  = (y_mupre - y_pos) / y_pos
      END
   2: BEGIN ; lengeler
      IF str.jump EQ 0 THEN y_chi=x_k*0 ELSE $
        y_chi  = (y_mupre - y_pos) / str.jump  $
		/( 1. - (8./3.)*(x_e-str.e0)/str.e0 )
      END
ENDCASE

out=Make_Set(x_e,x_e0,x_k,y_mu,y_mupre,y_munor,y_pre,y_pos,y_chi,$
   y_chi*x_k,y_chi*x_k*x_k,y_chi*x_k*x_k*x_k)
coltitles=['E [eV]','E-Eo [eV]','k [A^-1]','Mu','Mu-PreEdge',$
	'Mu Norm','PreEdge','PostEdge','Chi','Chi*k','Chi*k^2','Chi*k^3']

IF Keyword_Set(write) THEN BEGIN
  IF N_Elements(file) EQ 0 THEN BEGIN
    back:
    file=Dialog_Pickfile(/Write,File='xaid_mu2chi.spec', $
	Dialog_Parent=dialog_parent)
    IF file EQ '' THEN Return
    IF checkfile(file) THEN BEGIN
	itmp = Dialog_Message(/Question,['File exists: '+file,$
		'Overwrite it? '],Dialog_Parent=dialog_parent)
        IF itmp EQ 'No' THEN GoTo,back
    ENDIF
  ENDIF 
  OpenW,unit,file,/get_Lun
    PrintF,unit,'#F '+file
    PrintF,unit,'#D '+SysTime()
    PrintF,unit,'#C File written by XOP/XAID_MU2CHI'
    PrintF,unit,'#UXAID_MU2CHI file = '+str.file
    PrintF,unit,'#UXAID_MU2CHI preMin = '+StrCompress(str.preMin)
    PrintF,unit,'#UXAID_MU2CHI preMax = '+StrCompress(str.preMax)
    PrintF,unit,'#UXAID_MU2CHI e0 = '+StrCompress(str.e0)
    PrintF,unit,'#UXAID_MU2CHI jump = '+StrCompress(str.jump)
    PrintF,unit,'#UXAID_MU2CHI npol = '+StrCompress(str.npol)
    PrintF,unit,'#UXAID_MU2CHI degree = '+str.degree
    PrintF,unit,'#UXAID_MU2CHI knots = '+str.knots
;    PrintF,unit,'#UXAID_MU2CHI kkmin = '+StrCompress(str.kkmin)
;    PrintF,unit,'#UXAID_MU2CHI kkmax = '+StrCompress(str.kkmax)
    PrintF,unit,'#UXAID_MU2CHI extraction = '+str.extraction[0]
    PrintF,unit,'#S 1 '
    PrintF,unit,'#N '+StrCompress(N_Elements(coltitles))
    tmp = '#L'
    FOR i=0,N_Elements(coltitles)-1 DO tmp=tmp+'  '+coltitles[i]
    PrintF,unit,tmp
    FOR i=0,N_Elements(out[0,*])-1 DO $
	PrintF,unit,out[*,i], $
	Format='('+StrCompress(N_Elements(coltitles),/Rem)+'F15.5)'
    Free_Lun,unit
ENDIF
IF Keyword_Set(write) THEN BEGIN
  IF Keyword_Set(xplot) THEN BEGIN
   IF xplot EQ 2 THEN BEGIN
      itmp = Dialog_Message(/Question,Dialog_Parent=dialog_parent, $
	'Load file in xplot (for checking)?')
      IF itmp EQ 'No' THEN Return
   ENDIF
   xplot,spec=file,/No_block
  ENDIF
ENDIF ELSE BEGIN
  IF Keyword_Set(xplot) THEN $
  xplot,out,coltitles=coltitles,/No_Block 
ENDELSE
END ; xaid_mu2chi_calc

