;+
; =================================  xaid_ff ===============================
;
;   The documentation for XAID (the XOP's XAFS toolbox) can be found at:
;   http://www.esrf.fr/computing/scientific/xop/xaid/doc/
;
;		
;   xaid_ff is a widget based graphical interface to perform the
;   XAFS Fourier Filetering. It presents in three windows the XAFS
;   signal, the Fourier transform and the Back Fourier Transform, together
;   with widget controls to change the transformation parameters and limits.
;   
;   The main window contains the following controls
;
;	FILE Menu:
;	  LOAD FILE: To Load a File with Data. The file must contain 
;		the data in ascii formatted in two columns. It
;		may content comments becoming by a non-numeric (nor + - .)
;		character. The program stores the data and reads 
;		automatically all the points and columns
;	  SAVE FILE: wites an ASCII file with the signal, FT and BFT.
;		It is written in ASCII with header keywords as in the
;		SPEC data files in order to be read with XPLOT. 
;		Use XPLOT with this saved file for printing.
;		
;	  QUIT:	Exit or Quit the program
;
;       HELP:   Shows documentation to several related XAFS routines.
;
;		
; LAST REVISION: msr/msr 99/02/18
;
; ============= Non interactive use of xaid_ff ========================
;
;	NAME:
;		XAID_FF
;	PURPOSE:
;		 X user interface for Fourier Filtering. To analyse EXAFS data
; 	CATEGORY:
;		Widgets. XAFS data analysis.
;	CALLING SEQUENCE:
;		XAID_FF ,filename 
;	OPTIONAL INPUT PARAMETERS:
;		filename: a string containing the file name to be
;		plotted or an idl variable [fltarr(2,n_points]
;		with data. The file must be ascii data arranged in 
;		columns. Lines starting with characters [except . + -]
;		are comments and not considered for the plot.
;	KEYWORD PARAMETERS:
;		GROUP = The widget ID of the widget that calls Xplot.
;		When this ID is specified, a death of the caller results 
;		in a death of XAID_Mu2Chi.
;               NO_BLOCK = If set, starts Xmanager with the No_Block keyword.
;		DELIAID = the structure with the widgets ids when xaid_ff is
;		  called from the DELIA program.
;	OUTPUTS:
;		Open a widget utility and present a graphic.
;	COMMON BLOCKS:
;		None
;	SIDE EFFECTS:
;		If not active, starts Xmanager
;	RESTRICTIONS:
;		Unknown.
;	PROCEDURE:
;		Uses XAID data analysis IDL library.
;	MODIFICATION HISTORY:
;		Written by  Manuel Sanchez del Rio. ESRF. 96-08-26.
;		97-09-08 MSR adds NO_BLOCK keyword
;		97-09-30 srio@esrf.fr READ_ASCII renamed to RASCII
;		98-10-02 use of catch. Adapts for delia.
;		99-02-18 adapted for xop2.0
;		05-03-14 srio@esrf.fr adapted for delia2.0
;
;-

;
;=================================================================
;
Pro xaid_ff_draw,state,save=file,group=group

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(Dialog_Parent=group,$
	/Error,'XAID_FF_DRAW: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   return
endif
;
; get parameters
;
widget_control,state.wids.kpower,get_value = skpower
kpower = fix(skpower)
widget_control,state.wids.display1,get_value = idisp

widget_control,state.wids.krange,get_value = skrange
krange = 0
itmp = execute('krange = '+skrange(0))

plotfile,state.h1,set,/nodata

if keyword_set(file) then begin
  openw,Unit,file,/get_lun
  printf,Unit,'#F '+file
  printf,Unit,'#S 1 Original set'
  printf,Unit,'#N 2'
  printf,Unit,'#L k  chi(k)'
  printf,Unit,set
endif

;
; plot signal
;
widget_control,state.wids.Dr1,get_value = tmp  &  wset,tmp
widget_control,state.wids.filter,get_value=win
win = 1+fix(win)
widget_control,state.wids.WinPar,get_value=WinPar
WinPar = float(winPar(0))
if ( (win EQ 2) or (win EQ 4) or (win EQ 5) or (win EQ 6) ) then begin
  widget_control,state.wids.WinBase,map=1
  widget_control,state.wids.WinLabel,set_value='Appodization width:'
endif else if (win EQ 9) then begin
  widget_control,state.wids.WinBase,map=1
  widget_control,state.wids.WinLabel,set_value='t-value:'
endif else begin
  widget_control,state.wids.WinBase,map=0
endelse
	

case idisp of
  '0': begin
	newset=set   &  newset(1,*) = set(1,*)*set(0,*)^kpower
	; new!
	cutset,newset,zz1,xrange=krange
	plotfile,zz1,ytitle='chi*k^'+skpower ;signal
	end
  '1': begin
	cutset,set,zz1,xrange=krange
	window_ftr,zz1,wind,zz2,window=win,windpar=winpar
	newset=zz2   &  newset(1,*) = zz2(1,*)*zz2(0,*)^kpower
	plotfile,newset,ytitle='chi*k^'+skpower ;filtered signal
	end
  '2': begin
	cutset,set,zz1,xrange=krange
	window_ftr,zz1,wind,zz2,window=win,windpar=winpar
	newset=set   &  newset(1,*) = set(1,*)*set(0,*)^kpower
	cutset,newset,zz1,xrange=krange
	plotfile,zz1,ytitle='chi*k^'+skpower 
	newset=zz2   &  newset(1,*) = zz2(1,*)*zz2(0,*)^kpower
	plotset,newset,/over
	end
  '3': begin
	cutset,set,zz1,xrange=krange
	window_ftr,zz1,wind,window=win,windpar=winpar
	plotset,wind
	end
  else:
endcase

oplot, [krange(0),krange(0)],[-1e5,+1e5]
oplot, [krange(1),krange(1)],[-1e5,+1e5]
;
; plot FT
;
widget_control,state.wids.Dr2,get_value = tmp  &  wset,tmp

widget_control,state.wids.rrange,get_value = srrange
rrange = 0
itmp = execute('rrange = '+srrange(0))

widget_control,state.wids.kpower,get_value = skpower
kpower = fix(skpower)

widget_control,state.wids.filter,get_value=win
win = 1+fix(win)

widget_control,state.wids.display2,get_value=idisp
idisp = 1+fix(idisp)

ftrset,set,setf,xrange=krange,rrange=rrange,kpower=kpower, $
	window=win,method=1,plotfourier=idisp,windpar=winpar

if keyword_set(file) then begin
  printf,Unit,'#S 2 Fourier Transform'
  printf,Unit,'#N 4'
  printf,Unit,'#L R  Modulus  Real  Imag'
  printf,Unit,setf
endif


widget_control,state.wids.rrrange,get_value = srrrange
rrrange = 0
itmp = execute('rrrange = '+srrrange(0))
oplot, [rrrange(0),rrrange(0)],[-1e5,+1e5]
oplot, [rrrange(1),rrrange(1)],[-1e5,+1e5]

;
; plot BFTR
;

widget_control,state.wids.Dr3,get_value = tmp  &  wset,tmp

widget_control,state.wids.display3,get_value=idisp
idisp = 1+fix(idisp)

widget_control,state.wids.kkrange,get_value = skkrange
kkrange = 0
itmp = execute('kkrange = '+skkrange(0))

widget_control,state.wids.rshell,get_value = srshell
rshell = float(srshell(0))


if idisp EQ 4 then tmp = 1 else tmp = idisp
bftrset,setf,setbf,rrange=rrrange, krange=kkrange, $
	window=win,wrange=krange,method=1,plotbftr=tmp,$
	rshell=rshell,windpar=winpar
if idisp EQ 4 then begin
  newset=set   &  newset(1,*) = set(1,*)*set(0,*)^kpower
  plotset,newset,/over,linestyle=1
endif

if keyword_set(file) then begin
  printf,Unit,'#S 3 Back Fourier Transform'
  printf,Unit,'#N 4'
  printf,Unit,'#L k  Real  Modulus  Phase'
  printf,Unit,setbf
  free_lun,Unit
endif

;
; update delia panels
;

if type(state.wids.delia) EQ 8 then begin
  widget_control,state.wids.delia.ft.kMin,set_value=kRange[0]
  widget_control,state.wids.delia.ft.kMax,set_value=kRange[1]
  widget_control,state.wids.delia.ft.rMin,set_value=rRange[0]
  widget_control,state.wids.delia.ft.rMax,set_value=rRange[1]
  widget_control,state.wids.delia.ft.filter,set_value=win-1
  widget_control,state.wids.delia.ft.app_value,set_value=winpar
  widget_control,state.wids.delia.ft.kpower,set_value=kpower
  widget_control,state.wids.delia.ft.r2Min,set_value=rrRange[0]
  widget_control,state.wids.delia.ft.r2Max,set_value=rrRange[1]
  widget_control,state.wids.delia.ft.k2Min,set_value=kkRange[0]
  widget_control,state.wids.delia.ft.k2Max,set_value=kkRange[1]
  widget_control,state.wids.delia.ft.rshell,set_value=rShell[0]
  delia_mappanels,state.wids.delia
endif


end ; xaid_ff_draw

;
;=================================================================
;
PRO xaid_ff_loadfile,id,file

Widget_Control,id,Get_UValue=state

IF N_Elements(file) EQ 0 THEN BEGIN
	file = Dialog_pickfile(/Read,Dialog_Parent=id)
	if file eq '' then return
ENDIF
IF Type(file) EQ 7 THEN set1=rascii(file) ELSE set1=file

;xrange=[min(set1(0,*)),max(set1(0,*))]
;widget_control,state.wids.krange,set_value=vect2string(xrange)	
handle_value,state.h1,Set1,/set
Widget_Control,id,Set_UValue=state

widget_control,/hourglass
xaid_ff_draw,state,group=id

END
;
;=================================================================
;
PRO xaid_ff_event,event

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   if sdep(/w) then itmp = Dialog_Message(Dialog_Parent=event.top,$
	/Error,'XAID_FF_EVENT: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   goto,out
endif
Widget_Control, event.id, get_UValue=UValue
Widget_Control, event.top, get_UValue=state

CASE UVALUE OF
  'Quit': BEGIN
	widget_control,event.top,/destroy
	return
	END
  'Load File': xaid_ff_loadfile,event.top
  'Save File': BEGIN
	file = Dialog_pickfile(/WRITE,file='xaid_ff.out')
	if (file eq '') then goto,out
	if checkfile(file) eq 1 then begin
	  tmp = widget_message(['File '+ File+' already exists.', $
	  'Overwrite it?'],/CANCEL,/DEFAULT_CANCEL)
	  if tmp EQ 'Cancel' then goto,out
	endif
	widget_control,/hourglass
	xaid_ff_draw,state,save=file,group=event.top
	tmp = widget_message('File '+ File+' written to disk.',/INFO)
	END
  'About': XAID_Help,Group=event.top
  'Help': BEGIN
     widget_control,event.id,get_value=tmp
     xhelp,tmp,GROUP=event.top
    END
  'DO': BEGIN
	widget_control,/hourglass
	xaid_ff_draw,state,group=event.top
	END
  'Execute': BEGIN
	widget_control,event.id,get_value=tmp
	command = tmp+',No_Block='+StrCompress(state.no_block,/Rem) 
        ;+',group='+strcompress(event.top,/rem)+'L'
	message,/info,'Executing: '+command & itmp = execute(command)
	END
  else:
ENDCASE

out:
if n_elements(state) GT 0 then WIDGET_CONTROL,event.top,SET_UVALUE=state

END
;
;================================================================================
;

PRO xaid_ff, GROUP=group, SETIN, NO_BLOCK=no_block, DeliaId=deliaId,$
	KRange=KRange, Parent=wbase

   catch, error_status
   if error_status ne 0 then begin
      message,/info,'error caught: '+!err_string
      if sdep(/w) then itmp = Dialog_Message(Dialog_Parent=event.top,$
 	  /Error,'XAID_FF: error caught: '+!err_string)
      catch, /cancel
      on_error,2
      return
   endif

   ;
   ; Input data
   ;
   if n_elements(no_block) EQ 0 then no_block=1
   if n_elements(setin) EQ 0 then setin=[[0,0],[1,0]]
   if type(setin) EQ 7 then  set = rascii(setin) else set = setin

   ;
   ; Input parameters
   ;
   data = xaid_defaults('xaid_ff')
   IF Keyword_Set(KRange) THEN BEGIN
	data.krange=krange
	data.kkrange=krange
   ENDIF
   if type(deliaId) EQ 8 then begin
     widget_control,deliaId.ft.kMin,Get_value=kMin
     widget_control,deliaId.ft.kMax,Get_value=kMax
     widget_control,deliaId.ft.k2Min,Get_value=k2Min
     widget_control,deliaId.ft.k2Max,Get_value=k2Max
     widget_control,deliaId.ft.rMin,Get_value=rMin
     widget_control,deliaId.ft.rMax,Get_value=rMax
     widget_control,deliaId.ft.r2Min,Get_value=r2Min
     widget_control,deliaId.ft.r2Max,Get_value=r2Max
     widget_control,deliaId.ft.filter,Get_value=filter
     widget_control,deliaId.ft.app_value,Get_value=winpar
     widget_control,deliaId.ft.rshell,Get_value=rshell
     widget_control,deliaId.ft.kpower,Get_value=kpower
     
     data.krange = [kMin,kMax]
     data.rrange = [rMin,rMax]
     data.kkRange=[k2Min,k2Max]
	f = data.filter
	f[0] = filter
	data.filter=f
	k = data.kpower
	k[0] = StrCompress(kpower,/Rem)
	data.kpower=k
     data.rshell=rshell
     data.winpar=winpar
   endif

   ; Determine the hardware device size in pixels.
   DEVICE, GET_SCREEN=screendims

   if screendims(0) ge 1100 then i = 2 $        ;General screen sizing
   else if screendims(0) ge 800 then i = 1 $
   else i = 0

     ; Number of views and view size in pixels (device).
   viewsize = ([ 192, 192, 256])(i)
   nviews = ([ 2, 3, 3 ])(i)


   wBase = WIDGET_BASE(TITLE="XAID_FF 1.0 (XAFS Fourier Filtering)", /COLUMN, $
			MBAR=wMenuBar)
   wstate = WIDGET_BASE(wBase) ; where to store the state


   wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
     wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Load File', Uvalue= 'Load File')
     wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Save File', Uvalue= 'Save File')
     wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'Quit',/Separator)


  wTools =  WIDGET_BUTTON(wMenuBar, VALUE='Tools', /MENU)
      wtmp=WIDGET_BUTTON(wTools, VALUE='xaid', Uvalue= 'Execute')
      wtmp=WIDGET_BUTTON(wTools, VALUE='Xplot', Uvalue= 'Execute')

   wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
     wHelp1 = WIDGET_BUTTON(wHelpMenu, VALUE='xaid', UVALUE='About')
     wHelp1 = WIDGET_BUTTON(wHelpMenu, VALUE='xaid_ff', UVALUE='Help')

   ; Define a sub-base belonging to wBase.
   viewbase = WIDGET_BASE(wBase, SPACE=5, /ROW)

   ; Define the view windows.
   wtmpbase = WIDGET_BASE(viewbase, /FRAME, /COLUMN)
   wtmp = WIDGET_LABEL(wtmpbase, VALUE='Signal Window')
   wDr1 = WIDGET_DRAW(wtmpbase, XSIZE=VIEWSIZE, YSIZE=VIEWSIZE, RETAIN=2)
   wDisplay1 = cw_droplist(wtmpbase, $
	VALUE=['0','Signal','Windowed signal','Both','Window'], $
	TITLE='Show: ', UVALUE='DO')
   wtmp = WIDGET_LABEL(wtmpbase, /align_left, $
	VALUE='k limits for Fourier Transform:')
   wkrange = WIDGET_TEXT(wtmpbase, SCR_XSIZE=VIEWSIZE,/EDIT,UVALUE='DO', $
	VALUE=vect2string(data.krange) )
   ;windowlist = 1 & window_ftr,names=windowlist
   wFilter = cw_droplist(wtmpbase, $
	VALUE=data.filter, TITLE='Window: ', UVALUE='DO')
   wWinBase = WIDGET_BASE(wtmpbase, /ROW)
   wWinLabel = WIDGET_LABEL(wWinBase, /align_left, $
	VALUE='Appodization width:')
   wWinPar = WIDGET_TEXT(wWinBase, /EDIT,UVALUE='DO', $
	VALUE=strcompress(data.winPar),XSIZE=10)
   wKpower = cw_droplist(wtmpbase, VALUE=data.kpower, $
	TITLE='K Power: ', UVALUE='DO')
   

   wtmpbase = WIDGET_BASE(viewbase, /FRAME, /COLUMN)
   wtmp = WIDGET_LABEL(wtmpbase, VALUE='Fourier Window')
   wDr2 = WIDGET_DRAW(wtmpbase, XSIZE=VIEWSIZE, YSIZE=VIEWSIZE, RETAIN=2)
   wDisplay2 = cw_droplist(wtmpbase, VALUE=$
	['0','Modulus','Imag','Real','Modulus+Imag'],$
        TITLE='Show: ', UVALUE='DO', XSIZE=0)
   wtmp = WIDGET_LABEL(wtmpbase, /align_left, $
	VALUE='R interval:')
   wrrange = WIDGET_TEXT(wtmpbase, SCR_XSIZE=VIEWSIZE,/EDIT,UVALUE='DO', $
	VALUE=vect2string(data.rrange))
   wtmp = WIDGET_LABEL(wtmpbase, /align_left, $
	VALUE='R limits for the Back Fourier:')
   wrrrange = WIDGET_TEXT(wtmpbase, SCR_XSIZE=VIEWSIZE,/EDIT,UVALUE='DO', $
	VALUE=vect2string(data.rrrange))

   wtmpbase = WIDGET_BASE(viewbase, /FRAME, /COLUMN)
   wtmp = WIDGET_LABEL(wtmpbase, VALUE='Back Fourier Window')
   wDr3 = WIDGET_DRAW(wtmpbase, XSIZE=VIEWSIZE, YSIZE=VIEWSIZE, RETAIN=2)
   wDisplay3 = cw_droplist(wtmpbase, VALUE=$
	['0','Real','Modulus','Phase','Original(...)+Real'],$
        TITLE='Show: ', UVALUE='DO')
   wtmp = WIDGET_LABEL(wtmpbase, /align_left, $
	VALUE='K limits for the conjugated variable:')
   wkkrange = WIDGET_TEXT(wtmpbase, SCR_XSIZE=VIEWSIZE, /EDIT,UVALUE='DO', $
	VALUE=vect2string(data.kkrange))
   wtmp = WIDGET_LABEL(wtmpbase, /align_left, $
	VALUE='Shell radius for the back phase: ')
   wRshell = WIDGET_TEXT(wtmpbase, SCR_XSIZE=VIEWSIZE,/EDIT,UVALUE='DO', $
	VALUE=strcompress(data.rshell,/rem))

   if n_elements(deliaId) EQ 0 then deliaId=0L
   wids = { krange:wkrange,rrange:wrrange,rrrange:wrrrange,kkrange:wkkrange,$
	filter:wfilter,kpower:wkpower,rshell:wrshell, $
	Dr1:wDr1,Dr2:wDr2,Dr3:wDr3, $
	Display1:wDisplay1,Display2:wDisplay2,Display3:wDisplay3, $
	WinBase:wWinBase, WinLabel:wWinLabel, WinPar:wWinPar, $
	delia:deliaId}

   h1 = handle_create(value=set)
   state = {data:data, wids:wids, h1:h1, no_block:no_block}

;   if type(deliaId) EQ 8 then begin
;     widget_control,deliaId.ft.kMin,set_value=data.krange[0]
;     widget_control,deliaId.ft.kMax,set_value=data.krange[1]
;     widget_control,deliaId.ft.k2Min,set_value=data.kkrange[0]
;     widget_control,deliaId.ft.k2Max,set_value=data.kkrange[1]
;     widget_control,deliaId.ft.rMin,set_value=data.rRange[0]
;     widget_control,deliaId.ft.rMax,set_value=data.rRange[1]
;     widget_control,deliaId.ft.r2Min,set_value=data.rrRange[0]
;     widget_control,deliaId.ft.r2Max,set_value=data.rrRange[1]
;     widget_control,deliaId.ft.filter,set_value=data.filter-1
;     widget_control,deliaId.ft.app_value,set_value=data.winPar
;     widget_control,deliaId.ft.rshell,set_value=data.rshell
;   endif

     ; Display HOURGLASS during setup.
   WIDGET_CONTROL, wBase, /REALIZE, /HOURGLASS, set_uvalue=state
   xaid_ff_draw,state,group=group
   XManager, "xaid_ff", wBase, GROUP_LEADER=group, NO_BLOCK = no_block


END
