
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
pro PLOTSET, set, XRANGE=xrange,YRANGE=yrange, XYRANGE=xyrange, $
TITLE=title, XTITLE=xtitle,YTITLE=ytitle,                       $
PSYM=psym, OVER=over, tit_str=title_str,LINESTYLE=linestyle
;+
; NAME:
;	PLOTSET
;
; PURPOSE:
;	This procedure produces a graphic with a data set.
;
; CATEGORY:
;	XAID xafs data analysis package 
;
; CALLING SEQUENCE:
;
;	PLOTSET,set
;
; INPUTS:
;	set:	fltarr(ncol,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	XRANGE=[xmin,xmax] range of the x variable for the plot
;	YRANGE=[ymin,ymax]              y
;	XYRANGE=[xymin,xymax] sets XRANGE and YRANGE simultaneously.
;	TITLE='top_title' title to be written at the top
;	XTITLE='x_title'  title of x axis
;	YTITLE='y_title'           y
;	TIT_STR= the titles in a structure of type title_str = 
;	 {name:'set name', x:'x title', y:'y title', top:'top title'}
;	 (title_str has lower priority than title,xtitle and ytitle)
;	OVER  = if set to 1 then overplots the previous plot
;	PSYM = symbol of the plot (0=cont. line, default):
;		1 Plus sign
;		2 Asterisk
;		3 Period
;		4 Diamond
;		5 Triangle
;		6 Square
;		7 X
;		8 (See IDL users guide, D-15)
;		9 Undefined
;		10 Histogram mode
;
; OUTPUTS:
;	a plot
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		PLOTSET,myset,xrange=[0,15]
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	January, 1993	
;	93-05-27 MSR adds title_str keyword
;-
on_error,2
if keyword_set(title_str) then begin
  if not(keyword_set(title)) then title=title_str.top
  if not(keyword_set(xtitle)) then xtitle=title_str.x
  if not(keyword_set(ytitle)) then ytitle=title_str.y
endif
;
;
if ( not(keyword_set(title_str)) and not(keyword_set(title)) ) then title=''
if ( not(keyword_set(title_str)) and not(keyword_set(xtitle)) ) then xtitle=''
if ( not(keyword_set(title_str)) and not(keyword_set(ytitle)) ) then ytitle=''
;
if not(keyword_set(psym)) then psym = 0
if not(keyword_set(linestyle)) then linestyle=0
;
; define the arrays
;
arr1 = set(0,*)
arr2 = set(1,*)
;
;  search for extrema
;
if not(keyword_set(xrange)) then begin
  xrange = fltarr(2)
  off1 = 0.1*abs( max(arr1)-min(arr1) )
  xrange =[min(arr1)-off1,max(arr1)+off1]
endif
if not(keyword_set(yrange)) then begin
  yrange = fltarr(2)
  off2 = 0.1*abs( max(arr2)-min(arr2) )
  if off2 lt 1e-10 then off2 = 0.1*max(arr2)
  yrange =[min(arr2)-off2,max(arr2)+off2]
endif
if keyword_set(xyrange) then begin
   yrange = xyrange
   xrange = xyrange
endif
;
if not(keyword_set(over)) then begin
   plot,arr1,arr2,xrange=xrange,yrange=yrange, $
   xtitle=xtitle,ytitle=ytitle,title=title,psym=psym,/xstyle,/ystyle,$
   linestyle=linestyle
endif else begin
   oplot,arr1,arr2,psym=psym,linestyle=linestyle
endelse
;
return
end
