
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
function GETVALUE,text,default
;+
; NAME:
;	GETVALUE
;
; PURPOSE:
;	This function ask for a value, and allows the possibility of 
;	including a default value. The returned value has the same 
;	type of the default one. If default value is not present, the
;	returned value is string type.
;
; CATEGORY:
;	XAID XAFS data analysis package.
;
; CALLING SEQUENCE:
;
;	Result = GETVALUE('Give me a number',10)
;
; INPUTS:
;	text:	the message to be displayed
;
; OPTIONAL INPUTS:
;	default: the default value
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	Results a number
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;	Result = ('Chose between 10 and 20 ?', 20)
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993	
;-
;
on_error,2
;
n_par = n_params()
if (n_par eq 1) then default=''
atype = size(default)
;
answer = ''
read,strcompress(text),answer
if (answer eq '') then out=default else out=answer 
case atype(1) of
  1: out = byte(out)
  2: out = fix(out)
  3: out = long(out)
  4: out = float(out)
  5: out = double(out)
  6: out = complex(out)
  7: out = string(out)
  else: print,' Error from GETVALUE'
endcase
;
return,out
end
