;+
;
; This application creates a file containing a mesh surface
; with slope error. 
;
; Reference: 
; M. Snchez del Ro and A. Marcelli
; Waviness effects in ray-tracing of "real" optical surfaces
; Nuclear Instruments and Methods A 319 (1992) 170-177
;
; http://dx.doi.org/10.1016/0168-9002(92)90550-N
;
;
;
; Author: M. Sanchez del Rio
; Modification history:
;    2006, written in IDL based on Fortran code
;    2007-11-07 srio@esrf.eu added doc. Added PSD. Debugged. 
;    2008-04-15 srio@esrf.eu fixes  bugs with output file names. Added
;		slopes to Exodus. V 1.02
;
;
;-
FUNCTION  xsh_waviness_version
  Return,'1.02'
END
;
;
;
PRO xsh_waviness_event,event
;
; Interface for Waviness
; srio@esrf.fr 06.02.23 
;
Widget_Control, event.id, get_UValue=eventUValue

; ignore tab events
;help,/str,event
;help,eventUValue
;IF Type(eventUValue) EQ 7 THEN $
;  IF eventUValue EQ 'TAB' THEN RETURN

;Widget_Control, event.id, get_Value=Value
 
;if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
;if not(keyword_set(eventuvalue)) then eventuvalue = ''
 
;stateid = Widget_Info(event.handler,/Child)
;Widget_Control, stateid, get_UValue=state, /No_Copy
 
;help,eventUValue
Case eventUValue OF
    'CLOSE': BEGIN
	Widget_Control,event.top,/Destroy
	END
    'LOAD_XSH_WAVINESS': BEGIN
	file = Dialog_Pickfile(FILTER='*.inp',Title= $
	  'Select a .inp file for XSH_WAVINESS')
	IF file EQ '' THEN RETURN
	tmp = Waviness_Read(file)
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	xsh_waviness_updatewidgets,state.wids,tmp
	END
    'TABLEY': BEGIN ; update table length when changing # harmonics
	Widget_Control,event.id,Get_Value=nn
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	Widget_Control,state.wids.table,Table_YSize=nn+1
	END
    'TAB': BEGIN ; cp npointx and slp from first panel to third panel
	IF event.tab EQ 2 THEN BEGIN ; click on third panel
	  stateid = Widget_Info(event.handler,/Child)
	  Widget_Control, stateid, get_UValue=state
	  Widget_Control,state.wids.npointx,Get_Value=npointx
	  Widget_Control,state.wids.slp,Get_Value=slp
	  Widget_Control,state.wids.npointx2,Set_Value=npointx
	  Widget_Control,state.wids.slp2,Set_Value=slp
	ENDIF
	END
    'CALC': BEGIN ; calculate surface
	  stateid = Widget_Info(event.handler,/Child)
	  Widget_Control, stateid, get_UValue=state

	  ; cp parametric values to first panel
	  Widget_Control,state.wids.npointx2,Get_Value=npointx
	  Widget_Control,state.wids.npointx,Set_Value=npointx

	  Widget_Control,state.wids.slp2,Get_Value=slp
	  Widget_Control,state.wids.slp,Set_Value=slp

	  XSH_WAVINESS_UPDATEVALUES,state
	  Widget_Control, stateid, Set_UValue=state

	  Waviness_Calc,state.str,out
	  tmp = slopes(out,slopesrms=slopesrms)
	  txt = [' ','---- Slope: '+StrCompress(state.str.slp,/Rem)+$
		' arc sec ----'+StrCompress(state.str.npointx,/Rem)+' points',$
		'X (width):  '+$
		StrCompress(slopesrms[0],/Rem)+' arc sec ='+$
		StrCompress(slopesrms[2],/Rem)+' microrad', $
		'Y (length): '+$
		StrCompress(slopesrms[1],/Rem)+' arc sec ='+$
		StrCompress(slopesrms[3],/Rem)+' microrad']
	  Widget_Control,state.wids.slope,Set_Value=txt,/Append
	END
    'CLEAR': BEGIN ; 
	  stateid = Widget_Info(event.handler,/Child)
	  Widget_Control, stateid, get_UValue=state
	  Widget_Control,state.wids.slope,Set_Value=''
	  END
    'WRITEFILE': BEGIN ; 
	  stateid = Widget_Info(event.handler,/Child)
	  Widget_Control, stateid, get_UValue=state
	  XSH_WAVINESS_UPDATEVALUES,state
	  Widget_Control, stateid, Set_UValue=state

	  Waviness_Calc,state.str,out ; ,/write
	  tmp = slopes(out,slopesrms=slopesrms)
	  IF checkfile(state.str.file) NE 1 THEN  BEGIN
	    itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
		'XSH_WAVINESS_EVENT Problem creating file '+state.str.file)
	  ENDIF ELSE BEGIN
	    txt = ['File written to disk: '+state.str.file,$
		'  ',$
		'  X (width) slope error RMS:  '+$
		StrCompress(slopesrms[0],/Rem)+' arc sec',$
		'  Y (length) slope error RMS: '+$
		StrCompress(slopesrms[1],/Rem)+' arc sec', ' ', $
	        'Open file (for checking)?']
	    itmp = Dialog_Message(/Question,txt,Dialog_Parent=event.top)
	    IF itmp EQ 'Yes' THEN xdisplayfile1,state.str.file,Group=event.top
	  ENDELSE
	  END
    'NEWFILE': BEGIN
	  stateid = Widget_Info(event.handler,/Child)
	  Widget_Control, stateid, get_UValue=state
	  Widget_Control, state.wids.file, get_Value=newFile
	  state.str.file = newFile
	  Widget_Control, stateid, set_UValue=state
          END
    'PRESURFACE1': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	filesha=strmid(filedat,0,strpos(filedat,'.'))+'.sha'

	; delete .sha
	openw,unit,filesha,/delete,/get_lun
	free_lun,unit
	
	
	; create new file
	CASE SDep() OF
	'UNIX': BEGIN
	  command = "printf '"+filedat+" \n"+filesha+"\n' | presurface"
	  xsh_run,command
	  END
	'WINDOWS': BEGIN
	  OpenW,unit,'presurface_tmp.inp',/Get_Lun
	  PrintF,unit,filedat
	  PrintF,unit,filesha
	  Free_Lun,unit
	  xsh_run,'presurface < presurface_tmp.inp'
	  END
	 ELSE: itmp = Dialog_Message(/Error,'OS not implemented: '+SDep(),$
		Dialog_Parent=event.top)
	ENDCASE

	IF checkfile(filesha) NE 1 THEN  BEGIN
	  itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
		'XSH_WAVINESS_EVENT Problem creating file '+filesha)
	ENDIF ELSE BEGIN
	  itmp = Dialog_Message(/Info,Dialog_Parent=event.top, $
		'File (binary) written to disk: '+filesha)
	ENDELSE
	END
    'PRESURFACE2': xsh_run," xterm -e presurface " 
    'VIEW': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	presurface,filedat,out,/NoPlot
	xsurface1,out.z,out.x,out.y,xtitle='x',ytitle='y',wtitle=filedat
	END
    'VIEWI': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	presurface,filedat,out,/NoPlot
	iSurface,out.z,out.x,out.y,xtitle='x',ytitle='y'
	END
    'WRITEINP': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	fileinp=strmid(filedat,0,strpos(filedat,'.'))+'.inp'
	waviness_write,state.str,fileinp
	IF checkfile(fileinp) NE 1 THEN  BEGIN
	  itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
		'XSH_WAVINESS_EVENT Problem creating file '+fileinp)
	ENDIF ELSE BEGIN
	  itmp = Dialog_Message(/Question,Dialog_Parent=event.top, $
	    ['File written to disk: '+fileinp,'Open it (for checking)?'])
	  IF itmp EQ 'Yes' THEN xdisplayfile1,fileinp,Group=event.top
	ENDELSE
	END
    'PROFILES': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	presurface,filedat,out,/NoPlot
	exodus,/only,/quit,parent=p,Wtitle='Profiles from: '+filedat
	exodus,/only,/quit,parent=p2,Wtitle='Slopes from: '+filedat
        slp = slopes(out)
	FOR i=0,N_Elements(out.x)-1 DO BEGIN
	    tmp = Make_Set(Reform(out.y),Reform((out.z)[i,*]))
	    slp1 = StdDev(slp[1,i,*])
	    tmp2 = Make_Set(Reform(out.y),Reform(slp[1,i,*]))
            IF i EQ 0 THEN BEGIN 
              alltmp=tmp 
              allslope = slp1*180/!pi*3600
            ENDIF ELSE BEGIN 
              alltmp=alltmp+tmp
              allslope = allslope + slp1*180/!pi*3600
            ENDELSE
	    title='Z(Y) profile at x:'+ Strcompress((out.x)[i])+$
		'; slope='+StrCompress(slp1*180/!pi*3600,/Rem)+' arc sec'
	    exodus_loadfile,p,data=tmp,title=title
	    title="Z'(Y) slope at x:"+ Strcompress((out.x)[i])+$
		'; slope='+StrCompress(slp1*180/!pi*3600,/Rem)+' arc sec'
	    exodus_loadfile,p2,data=tmp2,title=title
	ENDFOR
        alltmp = alltmp/N_Elements(out.x)
        allslope = allslope/N_Elements(out.x)
	exodus_loadfile,p,data=alltmp,title=$
         '  MEAN Z(Y) profile. Mean slope: '+ $
         StrCompress(allslope,/Rem)+' arc sec'
	FOR i=0,N_Elements(out.y)-1 DO BEGIN
	    tmp = Make_Set(Reform(out.x),Reform((out.z)[*,i]))
	    slp1 = StdDev(slp[0,*,i])
	    tmp2 = Make_Set(Reform(out.x),Reform(slp[0,*,i]))
            IF i EQ 0 THEN BEGIN 
              alltmp=tmp 
              allslope = slp1*180/!pi*3600
            ENDIF ELSE BEGIN 
              alltmp=alltmp+tmp
              allslope = allslope + slp1*180/!pi*3600
            ENDELSE
	    title='Z(X) profile at y:'+ Strcompress((out.y)[i])+$
		'; slope='+StrCompress(slp1*180/!pi*3600,/Rem)+' arc sec'
	    exodus_loadfile,p,data=tmp,title=title
	    title="Z'(X) slope at y:"+ Strcompress((out.y)[i])+$
		'; slope='+StrCompress(slp1*180/!pi*3600,/Rem)+' arc sec'
	    exodus_loadfile,p2,data=tmp2,title=title
	ENDFOR
        alltmp = alltmp/N_Elements(out.y)
        allslope = allslope/N_Elements(out.y)
	exodus_loadfile,p,data=alltmp,title=$
         '  MEAN Z(X) profile. Mean slope: '+ $
         StrCompress(allslope,/Rem)+' arc sec'
	END


    'PSD': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	presurface,filedat,out,/NoPlot
	exodus,/only,/quit,parent=p,/xlog,/ylog,Wtitle='PSD from: '+filedat
	FOR i=0,N_Elements(out.x)-1 DO BEGIN
            s=prof2psd(Reform(out.y),Reform((out.z)[i,*]),f=f, $
             positive_only=1)
	    tmp = Make_Set(f,s)
	    ;slp1 = StdDev(slp[1,i,*])
            ;IF i EQ 0 THEN BEGIN 
            ;  alltmp=tmp 
            ;  allslope = slp1*180/!pi*3600
            ;ENDIF ELSE BEGIN 
            ;  alltmp=alltmp+tmp
            ;  allslope = allslope + slp1*180/!pi*3600
            ;ENDELSE
	    title='PSD of Z(Y) at x:'+ Strcompress((out.x)[i])
	    exodus_loadfile,p,data=tmp,title=title
	ENDFOR
	FOR i=0,N_Elements(out.y)-1 DO BEGIN
            s=prof2psd(Reform(out.x),Reform((out.z)[*,i]),f=f, $
             positive_only=1)
	    tmp = Make_Set(f,s)
            ;IF i EQ 0 THEN BEGIN 
            ;  alltmp=tmp 
            ;  allslope = slp1*180/!pi*3600
            ;ENDIF ELSE BEGIN 
            ;  alltmp=alltmp+tmp
            ;  allslope = allslope + slp1*180/!pi*3600
            ;ENDELSE
	    title='PDS of Z(X) profile at y:'+ Strcompress((out.y)[i])
	    exodus_loadfile,p,data=tmp,title=title
	ENDFOR
	END



    'WRITEINP': BEGIN
	stateid = Widget_Info(event.handler,/Child)
	Widget_Control, stateid, get_UValue=state
	filedat=state.str.file
	fileinp=strmid(filedat,0,strpos(filedat,'.'))+'.inp'
	waviness_write,state.str,fileinp
	IF checkfile(fileinp) NE 1 THEN  BEGIN
	  itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
		'XSH_WAVINESS_EVENT Problem creating file '+fileinp)
	ENDIF ELSE BEGIN
	  itmp = Dialog_Message(/Question,Dialog_Parent=event.top, $
	    ['File written to disk: '+fileinp,'Open it (for checking)?'])
	  IF itmp EQ 'Yes' THEN xdisplayfile1,fileinp,Group=event.top
	ENDELSE
	END
    'HELP': BEGIN 
	xhelp,'xsh_waviness',group=event.top
	END
    else: print,'EventUValue NOT FOUND: ',eventUValue
EndCase


;out:
;Widget_Control, stateid, set_UValue=state, /No_Copy
end
;
;====================================================================
;
PRO xsh_waviness,input, Group=group

if NOT(Keyword_Set(input)) THEN BEGIN
  str = Waviness_Read(/Default)
endif

wbase=widget_base(/col,title='xsh_waviness '+xsh_waviness_version())
wtmp = widget_base(wbase) ; to store state

wtmp0 = widget_base(wbase,/Row) ; Main Buttons
  wtmp = widget_button(wtmp0,Value='Close',UValue='CLOSE')
  wtmp = widget_button(wtmp0,Value='Help',UValue='HELP')
 
;
; different bases
;
wTab=Widget_Tab(wbase,UVal='TAB') 
  wInputs=Widget_Base(wTab,Title='Inputs', Column=1)
  wHarmonics=Widget_Base(wTab, Title='Harmonics', Column=1) 
  wOptimize=Widget_Base(wTab, Title='Optimize calculations', Column=1) 
  wOutputs=Widget_Base(wTab, Title='Create Outputs', Column=1) 

;
; inputs
;
w1 = Widget_Base(wInputs,/col,/Frame)

wtmp0=Widget_Base(w1,Row=1)
  wtmp = Widget_Button(wtmp0,Value='Load xsh_waviness input file... ',$
	UValue='LOAD_XSH_WAVINESS')

wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value=' Number of points (<201) X(width): ')
  wNpointx = Widget_Text(wtmp0,Value=StrCompress(str.npointx,/Rem), $
	/edit,xsize=15)
  wtmp = Widget_Label(wtmp0,Value=' Y(length): ')
  wNpointY = Widget_Text(wtmp0,Value=StrCompress(str.npointy,/Rem), $
	/edit,xsize=15)
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value=' Dimensions [cm]         X(width): ')
  wWidth = Widget_Text(wtmp0,Value=StrCompress(str.width,/Rem), $
	/edit,xsize=15)
  wtmp = Widget_Label(wtmp0,Value=' y(length): ')
  wXlength = Widget_Text(wtmp0,Value=StrCompress(str.Xlength,/Rem), $
	/edit,xsize=15)
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value=' Estimated Slope Error RMS [arcsec]: ')
  wSlp = Widget_Text(wtmp0,Value=StrCompress(str.Slp,/Rem), $
	/edit,xsize=20)
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value=' Monte Carlo initial seed:           ')
  wIseed = Widget_Text(wtmp0,Value=StrCompress(str.iseed,/Rem), $
	/edit,xsize=20)

;
; harmonics
;
w1 = Widget_Base(wHarmonics,/col,/Frame)
wtmp0 = Widget_Base(w1,/row)
  wtmp = Widget_Label(wtmp0,Value=' Harmonic Maximum Index: ',$
	UValue='TABLEY')
  wN = Widget_Text(wtmp0,Value=StrCompress(str.n,/Rem), $
	/edit,xsize=20,UValue='TABLEY')
tmp = Make_Set(str.c,str.y,str.g)
wtable = Widget_Table (w1, xsize=3, ysize=str.n+1, $
           value=tmp, /Editable, /All_Events, /Scroll, $
           column_labels=['c','y','g'], $
           scr_xsize=180, scr_ysize=260, UValue='') 



; 
; Optimization
;
w1 = Widget_Base(wOptimize,/col,/Frame)
  wtmp = Widget_Label(w1,Value= $
	' ** Values to play with (<enter> to apply): **')
  wtmp0 = Widget_Base(w1,/row)
    wtmp = Widget_Label(wtmp0,Value=' Estimated Slope Error RMS [arcsec]: ')
    wSLP2 = Widget_Text(wtmp0,Value=StrCompress(str.Slp,/Rem), $
	/edit,xsize=20,UVALUE='CALC')
  wtmp0 = Widget_Base(w1,/row)
    wtmp = Widget_Label(wtmp0,Value=' Number of points (<201) X(width):   ')
    wNPOINTX2 = Widget_Text(wtmp0,Value=StrCompress(str.npointx,/Rem), $
	/edit,xsize=20,UValue='CALC')
  wtmp0 = Widget_Base(w1,/col,/Frame)
    wtmp1 = Widget_Base(wtmp0,/Row)
      wtmp = Widget_Button(wtmp1,Value='CALCULATE',UVALUE='CALC')
      wtmp = Widget_Button(wtmp1,Value='CLEAR',UVALUE='CLEAR')
    wtmp = Widget_Label(wtmp0,Value=' Resulting Slope Errors: ')
    wSlope = Widget_Text(wtmp0,Value=' ',XSize=60,YSize=8,/Scroll)
; 
; Outputs
;
w1 = Widget_Base(wOutputs,/col,/Frame)
  wtmp = Widget_Label(w1,Value= $
	' ** Create Output Files **')
  wFile = CW_Pickfile(w1,Title=' Output file [.dat]: ',Value=str.file, $
	Path=0,/Button_Last,UValue='NEWFILE')
  wtmp = Widget_Label(w1,Value= ' Tasks: ')

  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value= '1) WRITE .dat FILE (MANDATORY)') 
    wtmp0 = Widget_Button(wtmp,Value='GO', UVALUE='WRITEFILE')

  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp, Value='2) RUN PRESURFACE (.dat -> .sha) (MANDATORY)')
    wtmp0 = Widget_Button(wtmp, Value='GO (automatic)', UVALUE='PRESURFACE1')
    wtmp0 = Widget_Button(wtmp, Value='GO (manual)', UVALUE='PRESURFACE2')

  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value='3) VISUALIZE .dat OUTPUTS (OPTIONAL)')
    wtmp0 = Widget_Button(wtmp,Value='XSurface1',UVALUE='VIEW')
    wtmp0 = Widget_Button(wtmp,Value='iSurface',UVALUE='VIEWI')
  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value='4) WRITE XSH_WAVINESS .inp INPUT FILE (OPTIONAL)')
    wtmp0 = Widget_Button(wtmp,Value='GO',UVALUE='WRITEINP')
  wtmp = Widget_Base(w1,/Row)
    wtmp0 = Widget_Label(wtmp,Value='5) ANALYZE PROFILES (OPTIONAL)')
    wtmp0 = Widget_Button(wtmp,Value='Profiles+Slope',UVALUE='PROFILES')
    wtmp0 = Widget_Button(wtmp,Value='PSD',UVALUE='PSD')



wids = { $
	file:wFile, npointx:wnpointx, npointy:wnpointy, $
	width:wwidth, xlength:wxlength, $
        n:wn, slp:wslp, $
	iseed:wiseed, $
	table:wTable, slp2:wSlp2, npointx2:wNpointx2, $
	slope:wSlope }
state = {wids:wids, str:str}

;
;
;
widget_control,Widget_Info(wbase,/Child),set_uvalue=state


widget_control,wbase,/realize
xmanager,'xsh_waviness',wbase,GROUP=group,/NO_BLOCK
end
