;
; this is used to restore shadowvui .sav files when running 
; XOP in embedded mode.
;
; 
PRO shadowvui, Group=group,idebug=idebug

;
; Modified srio@esrf.eu 2008-03-31 adapted for xop2.3 Cleaned a lot
; Modified srio@esrf.fr 99/03/10 to adapt top XOP2.0beta1 embedded.
;

;
; This program starts the SHADOW VUI
; If starting shadowvui with the unix script, this file
; should not be customized. 
; Otherwise, you should customize this file (comment the getenv commands
; and define the related variables) and start it at the
; IDL prompt with:
; @/your_path.../start_shadowvui.pro
;
;
common xsh_f0, wk_names, wk_data
common shadow, xshgeom, xshoe, shadow_start
forward_function shadow_version, xop_getenv

IF N_Elements(idebug) EQ 0 THEN idebug=0
ds = SDep(/ds)
; ********************* STEP 1 ***********************************
;
; directory where you installed the SHADOW VUI files
;
shadowvui_home = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'
IF idebug THEN itmp=Dialog_Message(/Info,'SHADOWVUI: shadowvui_home='+shadowvui_home)
;
;
; ********************* END STEP 1 *******************************
;
; restore saved sets
;
file = shadowvui_home+ds+'data'+ds+'shadowvui_data.sav'
message,/info,'Restoring '+file
IF idebug THEN itmp=Dialog_Message(/Info,'SHADOWVUI: Restoring '+file)
restore,file

file = shadowvui_home+ds+'data'+ds+'shadowvui_vui.sav'
message,/info,'Restoring '+file
IF idebug THEN itmp=Dialog_Message(/Info,'SHADOWVUI: Restoring '+file)
restore,file
;
;
; ********************* STEP 2 ***********************************
;
; customize shadow initialization 
;
; Under Unix this is done by calling the .shadowrc.sh file.
; Customize shadow initialization (by default we use Bourne shell)
; Please check that the file .shadowrc.sh is correctly customized:
;      1) the directory paths are correctly set,
;      2) the SHADOW_START_FORMAT is set to GFILE (not FORTRAN)
;      3) the SHADOW_ENV_FILE points to /tmp/shadow-env-${USER} (this
;             is necessary to run sources without using make_id)
;
;shadow_start='. /pgexp/applications1/XRayOptics/shadow-2.2.0.sun5/.shadowrc.sh'
;setenv,'SHELL=/bin/sh'
shadow_start=getenv('SHADOW_START')
IF idebug THEN itmp=Dialog_Message(/Info,'SHADOWVUI: shadow_start: '+shadow_start)
;
; in the case you want to use the csh you must comment the above commands
; and uncomment and customize the following two commands:
;
; shadow_start='source /usr/local/shadow/.shadowrc'
; setenv,'SHELL=/bin/csh'
;
;
; Under Windows, you should define the corresponding initialization
; commands. Very important: type all in a single command line (not use 
; continuation symbols).
; (This is overwritten done in shadowvui_preferences.pro, if exists)
; shadow_start=['set SHADOW_ROOT=c:/shadow/shadow-2.3.0','set SHADOW_ENV_FILE=xsh_env_file.inp','set PATH=c:/shadow/shadow-2.3.0/bin;c:\windows\command.com"]
; ********************* END STEP 2 *******************************
;
;
; in case you want a define a starting working directory, uncomment and
; customize the next command. Warning: the selected directory must
; exists, otherwise SHADOWVUI will not start.
; This SHADOWVUI_WD variable can be defined in the Unix script or the 
; windows .bat file that start SHADOWVUI, instead of here.
; If defined in both places, the one defined here will be considered.
; The default is the current directory under Unix.
;
; setenv,'SHADOWVUI_WD=/tmp'
;
print,'******************************************************************'
print,'******************************************************************'
print,'    SHADOW Visual User Interface ('+shadow_version()+')'
print,'    (c) Manuel Sanchez del Rio (srio@esrf.eu) '
print,'    (c) European Synchrotron Radiation Facility'
print,'    (c) BP 220, F-38043 Grenoble Cedex (France)'
print,'******************************************************************'
print,'******************************************************************'
print,' '
print,'NOTE: to restart the SHADOW VUI from the IDL prompt just type "shadow"'
print,' '
;
;
;
IF idebug THEN itmp=Dialog_Message(/info,'SHADOWVUI: starting shadow... ')
shadow
END
