;***************mirror ellip definition************
function blv_mirror_inf, baseX, baseY, nb_cotte=nb_cotte, prof=hauteur, Color=color


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_mirror_inf: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


if n_elements(hauteur) eq 0 then hauteur=0.03
if n_elements(color) eq 0 then color=[100,100,255]
if n_elements(nb_cotte) eq 0 then nb_cotte=16
da=(2*!dpi/nb_cotte)
point=fltarr(nb_cotte*2,3)
a=0
freq=0
dfreq=da*7
for p=0, nb_cotte-1 do begin
	l=((cos(freq)))/40
;	print,l
	point[p*2,*]=[(baseX+l)*cos(a),(baseY+l)*sin(a),-hauteur]
	point[p*2+1,*]=[(baseX+l)*cos(a),(baseY+l)*sin(a),0]
	a=a+da
	freq=freq+dfreq
endfor
t=size(point)
mirror=obj_new('idlgrmodel')
; le tour
connex=intarr(5,nb_cotte)
for p=0, nb_cotte-2 do begin
	connex[*,p]=[4,(p*2),(p*2)+1,(p*2)+3,(p*2)+2]
end
connex[*,nb_cotte-1]=[4,((nb_cotte-2)*2)+2,((nb_cotte-2)*2)+3,1,0]

pointH=fltarr(nb_cotte,3)
pointB=fltarr(nb_cotte,3)
for p=0, nb_cotte-1 do begin
	pointH[p,*]=point[p*2,*]
	pointB[p,*]=point[p*2+1,*]
endfor
centerH=[0,0,-hauteur]
centerB=[0,0,0]

mirror->add, obj_new('idlgrpolygon', Point[*,0],Point[*,1],Point[*,2], $
						POLYGONS =connex, Color=color,/shading)

;tops
for r=0, nb_cotte-2 do begin
	mirror->add, obj_new('idlgrpolygon', [PointH[r,0],PointH[r+1,0],centerH[0]], $
										[PointH[r,1],PointH[r+1,1],centerH[1]], $
										[PointH[r,2],PointH[r+1,2],centerH[2]], $
										Color=color)
endfor
mirror->add, obj_new('idlgrpolygon', [PointH[nb_cotte-1,0],PointH[0,0],centerH[0]], $
									[PointH[nb_cotte-1,1],PointH[0,1],centerH[1]], $
									[PointH[nb_cotte-1,2],PointH[0,2],centerH[2]], $
									Color=color)

for r=0, nb_cotte-2 do begin
	mirror->add, obj_new('idlgrpolygon', [PointB[r,0],PointB[r+1,0],centerB[0]], $
										[PointB[r,1],PointB[r+1,1],centerB[1]], $
										[PointB[r,2],PointB[r+1,2],centerB[2]], $
										Color=color)
endfor
mirror->add, obj_new('idlgrpolygon', [PointB[nb_cotte-1,0],PointB[0,0],centerB[0]], $
									[PointB[nb_cotte-1,1],PointB[0,1],centerB[1]], $
									[PointB[nb_cotte-1,2],PointB[0,2],centerB[2]], $
									Color=color)

return, mirror
end
;**********************************************
