;+
; NAME:
;       SAVE_OPTICAL_SYSTEM
;
; PURPOSE:
;		this procedure create a file with all informations contain 
;		in an optical system
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       Save_optical_system
;
; INPUTS:
;		pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;
; MODIFICATION HISTORY:
;       Written by CP:     ESRF, EXP, May 2001.
;-


pro blv_save_optical_system, pInfo, Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_save_optical_system: error caught: '+!error_state.msg)
   RETURN
ENDIF


file=dialog_pickfile(title='Save System...',FILTER = '*.blv',/write, file='blviewer.blv', $
	Dialog_Parent=group)
if file ne '' then begin
  	nb_module=(*pInfo).data.system->count()
  	s=(*pInfo).data.system->get_source()
  	s->getProperty, mesh_file=mesh_file_source
  	mesh_file_source=mesh_file_source
  	type_name_tab=strarr(nb_module)
	t_source_tab=fltarr(nb_module)
	t_image_tab=fltarr(nb_module)
	t_incidence_tab=fltarr(nb_module)
	t_reflection_tab=fltarr(nb_module)
	alpha_tab=fltarr(nb_module)
	rwidx1_tab=fltarr(nb_module)
	rwidx2_tab=fltarr(nb_module)
	rlen1_tab=fltarr(nb_module)
	rlen2_tab=fltarr(nb_module)
	prof_tab=fltarr(nb_module)
	file_name_tab=strarr(nb_module)
	color_R_tab=intarr(nb_module)
	color_G_tab=intarr(nb_module)
	color_B_tab=intarr(nb_module)
	mesh_file_tab=strarr(nb_module)

	for p=0, nb_module-1 do begin

		obj=(*pInfo).data.system->get_module(pos=p)
		obj->getProperty, t_source=t_source, t_image=t_image, $
				t_incidence=t_incidence, t_reflection=t_reflection, alpha=alpha , $
				rwidx1=rwidx1, rwidx2=rwidx2, rlen1=rlen1, rlen2=rlen2, prof=prof, $
				type_name=type_name, file_name=file_name, color=color, mesh_file=mesh_file

		type_name_tab[p]=type_name
		t_source_tab[p]=t_source
		t_image_tab[p]=t_image
		t_incidence_tab[p]=t_incidence
		t_reflection_tab[p]=t_reflection
		alpha_tab[p]=alpha
		rwidx1_tab[p]=rwidx1
		rwidx2_tab[p]=rwidx2
		rlen1_tab[p]=rlen1
		rlen2_tab[p]=rlen2
		prof_tab[p]=prof
		file_name_tab[p]=file_name
		color_R_tab[p]=color[0]
        color_G_tab[p]=color[1]
        color_B_tab[p]=color[2]
        mesh_file_tab[p]=mesh_file
		;element
		;source
		;image
		;rayon
		;graphic


		;out_transform
		;distance_scale
		;dimension_scale
		;dimension_private_scale
		;log
		;trans
		;selected
		;color
		;rayon_source
		;rayon_element
		;rayon_image
	endfor
	g_data={nb_module:nb_module, $
            type_name:type_name_tab, $
            mesh_file_source:mesh_file_source, $
		    t_source:t_source_tab, $
		    t_image:t_image_tab, $
		    t_incidence:t_incidence_tab, $
		    t_reflection:t_reflection_tab, $
		    alpha:alpha_tab, $
		    rwidx1:rwidx1_tab, $
		    rwidx2:rwidx2_tab, $
		    rlen1:rlen1_tab, $
		    rlen2:rlen2_tab, $
		    prof:prof_tab, $
		    file_name:file_name_tab, $
		    color_R:color_R_tab, $
        	color_G:color_G_tab, $
        	color_B:color_B_tab, $
        	mesh_file:mesh_file_tab $
		    }

	write_gfile, g_data, file

endif


end
