function histosh,arr2,w,nbins=nbins,xrange=xrange, $
  plot=plot,swap=swap,erase=erase,fill=fill,yrange=yrange, $
  noshift=noshift, $
  _extra=extra, binSize=binSize ; output
;+
;
; function histosh,arr2,w,nbins=nbins,xrange=xrange, $
;  plot=plot,swap=swap,erase=erase,fill=fill,yrange=yrange, $
;  _extra=extra, binSize=binSize
;
; (to be used internally bu plotxy and histo1)
;
; extra: Kwywords passed to plotHisto
; binSize: output keyword
; 
;
; M. Sanchez del Rio, ESRF, June 1995
;	97-04-03 srio@esr.fr adds catch.
;
; 06-02-21 srio@esrf.fr Make calculations in double
; 07-06-12 srio@esrf.fr reformes it using new histogramW
;          and plotHisto
; 08-09-12 srio@esrf.eu forces output to have nBins bins (eliminated
;          a possible extra bin with expurious round values). 
;
;-

catch,error
if error NE 0 then begin
  message,/info,'Error detected. Returning [0,0].'
  catch,/cancel
  on_error,2
  return,[0,0]
endif


if n_params() EQ 1 then w = 0.D0*arr2+1
IF N_Elements(swap) EQ 0 THEN swap=0
if not(keyword_set(nbins)) then nbins = 26
if keyword_set(erase) then erase
if not(keyword_set(xrange)) then begin
  p_min=min(arr2,max=p_max)
  off2 = 0.1D0*abs( p_max-p_min )
  if off2 lt 1D-10 then off2=0.5D*p_max
  xrange =[p_min-off2,p_max+off2]
  xrange = round1( xrange,fix(alog(xrange(1)-xrange(0))/alog(10))-2)
endif else begin
  xrange=DOUBLE(xrange)
  p_min = xrange[0]
  p_max = xrange[1]
endelse

;print,'xrange,p_min,p_max: ',xrange,p_min,p_max
;
; Warning: the nbins for me (srio) is the number of bins, however, for IDL
; histogram(), nbins is the number of histogram points, thus
; for IDL : binsize =(p_max-p_min)/double(nbins-1)
;
binsize =(p_max - p_min)/double(nbins)
;print,'binsize: ',binsize
;print,'max: ',p_min + binsize*nbins
;print,'nbins: ',nbins
;print,'p_min,p_max: ',p_min,p_max

;
; For avoiding round error and other undesirable effects, 
; call histogram with only the keywords that are used in the definition
; of histogram (see IDL doc), i.e., MIN and BINSIZE
;
; note that in this way the histogram is not limited to p_max
;

hy = histogramw(arr2,w,min=p_min,binsize=binsize, xval=hx)
;
; use always nbins (eliminate truncation value)
;
nhy=N_Elements(hy)
IF nhy EQ nbins+1 THEN BEGIN
  Message,/Info,'Histo resized to nBins: '+StrCompress(nbins)
  hy[nhy-2]=hy[nhy-2]+hy[nhy-1]
  hy=hy[0:nhy-2]
  hx=hx[0:nhy-2]
ENDIF

; cut points > p_max
igood = Where(hx LE p_max)
IF igood[0] NE -1 THEN BEGIN
   hx = hx[igood]
   hy = hy[igood]
ENDIF
nhy = N_Elements(hy)
;print,'histogramw: ',hx,hy

;
; prepare output (shifted and zero the edges...)
;

IF hy[nhy-1] NE 0 THEN BEGIN
  hx = [hx,hx[nhy-1]+binsize]
  hy = [hy,0]
ENDIF
IF hy[0] NE 0 THEN BEGIN
  hx = [hx[0]-binsize,hx]
  hy = [0,hy]
ENDIF
IF Keyword_Set(noshift) THEN BEGIN 
  hout = Make_Set(hx,hy)
ENDIF ELSE BEGIN
  hout = Make_Set(hx+binsize/2,hy)
ENDELSE

;
; plot
;

if keyword_set(plot) then begin
  if not(keyword_set(yrange)) then yrange = [0,1.1*max(hy)]
  plotHisto,hx,hy,/noerase,xrange=xrange,yrange=yrange,swap=swap,_extra=extra
endif
;print,'hout: ',hout
return,hout
end
