PRO xsh_plotxy_controls_update,wids,pstr

;
; Updates the widgets in the control panel of XSh_Plotxy from
; the values in PStr (pointer to a structure).
; To be used internally my xsh_plotxy_controls.pro
;
; srio@esrf.fr 97-12-4
; srio@esrf.fr 06-02-16 added retrace entry
;

;
; set defaluts
;

;
;general 
;
Widget_Control,wids.shadow_in, Set_Value= (*pstr).shadow_in
Widget_Control,wids.retrace, Set_Value= StrCompress( (*pstr).retrace,/Rem)
Widget_Control,wids.col1, Set_Value=(*pstr).col1
Widget_Control,wids.col2, Set_Value=(*pstr).col2

widget_control,wids.xrange,set_value=[(*pstr).xrange(0),(*pstr).xrange(1)]
if (*pstr).default_xrange EQ 1 then $
  widget_control,wids.xrange,set_value='Default' 

widget_control,wids.yrange,set_value=[(*pstr).yrange(0),(*pstr).yrange(1)]
if (*pstr).default_yrange EQ 1 then $
  widget_control,wids.yrange,set_value='Default'

widget_control,wids.nolost,set_value=strcompress((*pstr).nolost,/rem)
widget_control,wids.cart,set_value=strcompress((*pstr).cart,/rem)
widget_control,wids.contour,set_value=strcompress((*pstr).contour,/rem)
;
; histograms
;
widget_control,wids.histo,set_value=strcompress((*pstr).histo,/rem)
widget_control,wids.nbins,set_value=strcompress((*pstr).nbins,/rem)
widget_control,wids.nc_bins,set_value=strcompress((*pstr).nc_bins,/rem)
widget_control,wids.nLevels,set_value=strcompress((*pstr).nLevels,/rem)
widget_control,wids.calfwhm,set_value=strcompress((*pstr).calfwhm,/rem)
widget_control,wids.gaussfit,set_value=strcompress((*pstr).gaussfit,/rem)
;
; color
;
Widget_Control,wids.cfile, Set_Value= (*pstr).cfile
Widget_Control,wids.cbins, Set_Value= (*pstr).cbins
Widget_Control,wids.ccol, Set_Value=(*pstr).ccol
Widget_Control,wids.climits, Set_Value=[(*pstr).climits(0),(*pstr).climits(1)]
if (*pstr).default_climits EQ 1 then $
  Widget_Control,wids.climits, Set_Value='Default'
widget_control,wids.cref,set_value=strcompress((*pstr).cref,/rem)
;
; presentation
;
widget_control,wids.title,set_value=(*pstr).title
widget_control,wids.slit,set_value=	[(*pstr).slit(0),$
					(*pstr).slit(1),$
					(*pstr).slit(2),$
					(*pstr).slit(3)]
widget_control,wids.nocomm,set_value=strcompress((*pstr).nocomm,/rem)
widget_control,wids.charsize,set_value=strcompress((*pstr).charsize,/rem)
widget_control,wids.mulfac,set_value=strcompress((*pstr).mulfac,/rem)
;widget_control,wids.nlevels,set_value=strcompress((*pstr).nlevels,/rem)
widget_control,wids.publish,set_value=strcompress((*pstr).publish,/rem)
widget_control,wids.smooth,set_value=strcompress((*pstr).smooth,/rem)
;
; Others
;
widget_control,wids.AutoRefresh,set_value=(*pstr).AutoRefresh

end
