
;
;+
;
;==============================  XSh_Histo1   ==================================
;
; XSh_Histo1 is a widget based graphical interface for the Histo1
; IDL implementation of the SHADOW Histo1 tool.
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  Menu bar
;  ========
;  File:
;    XSh_Histo1 input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
;  Help:   Shows the XSh_Histo1 help (this text) and Histo1 help.
;
;  Other controls
;  ==============
;  
;  "Quit" button: quite sthe program
;  "Show contols": starts an application allowing to change interactively 
;	the parameters. 
;  "Refresh" refresh the screen by exucuting the command written at the 
;	bottom (which may be different to the parameters input with
;	"Show controls").
;  "Refresh in a new window" creates a new clone window and executes
;	Histo1 with parameters defined in the "Show controls". This
;	option is useful when tracing running SHADOW as a second time
;	with some changed parameters and wanted to compare with the 
;	previous run without destoying the previous Histo1 graph.
;  The bottom editable line can be used to enter by hand any Histo1
;	command. Enter <return> for updating the graph. Note that 
;	entering a command here does not update the parameters available
;	under the "Show controls" button. Also, by using this button, 
;	the previous existing command is overwritten.
;	
;  
;
;
; COPYRIGHT:
;	XSH_Histo1  belongs to SHADOWVUI package and it is distributed 
;	as an XOP extension.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;	http://www.esrf.fr/computing/scientific/xop/
;
; CREDITS:
;	Published calculations made with SHADOW and SHADOWVUI should refer:
;
;	C. Welnak, G.J. Chen and F. Cerrina "SHADOW: a synchrotron
;	radiation X-ray optics simulation tool", Nucl. Instr. and Meth. A347
;	(1994) 344-347 
;	
;	M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	SPIE proceedings vol. 3448, pp.340-345, 1998.
;
; LAST MODIFICATION: msr/msr/00-07-10
;
;-
;
; -----------------------------------------------------------------------
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF
;	00/07/10 srio@esrf.fr version 1.1 for xop 2.0. Documented.
;
;
;========================================================================
;
FUNCTION xsh_histo1_version
RETURN,'1.1'
END
;
;===============================================================================
;
PRO xsh_histo1_event,event


!p.position=0 

Widget_Control, event.id, get_UValue=eventUValue
;Widget_Control, event.id, get_Value=Value

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

widget_control,state.wids.draw,get_value=windownum
wset,windownum

;
; Action
;
Case eventUValue OF
     'RESIZE': BEGIN
	if sdep() eq 'UNIX' then begin
	  widget_control,state.wids.draw,$
		scr_xsize=event.x-5,scr_ysize=event.y-105
          Widget_Control,state.wids.command,xsize=(event.x-5)/8
          Widget_Control,state.wids.base,xsize=event.x-5
	endif else begin
	  widget_control,state.wids.draw,$
		scr_xsize=event.x+5,scr_ysize=event.y-65
          Widget_Control,state.wids.command,xsize=(event.x+5)/6.2
          Widget_Control,state.wids.base,xsize=event.x+5
	endelse
        Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
        tmp = execute(command(0)+',group=event.top')
     END
    'QUIT': Begin
	; Free pointer if input type is not a pointer
	IF state.type_input NE 10 THEN Ptr_Free,state.StrPtr
	;
	Widget_Control, event.top, /destroy
	Return
	End


    'FILEINPUT': BEGIN
        action=''
        Widget_Control,event.id, Get_Value=action
        CASE action OF
            'Load from file...': BEGIN
              ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
              str_par = Xop_Input_Load(Title=$
              'Select XSh_Histo1 input file...',$
              /NoConf,Filter=filter,Group=event.top)
              IF Type(str_par) EQ 8 THEN BEGIN
                tmp = *(state.strptr)
                Copy_Structure,str_par, tmp, Group=event.top , /OnlyFirstField
                *(state.strptr) = tmp
              ENDIF
	     ; copied from APPLY section
             ; update window bar
             wTitle = 'Histo1: '+ (*(state.strPtr)).shadow_in
             state.wTitle=wTitle
             Widget_Control,state.wids.base,TLB_Set_Title= wTitle
	     ;update command
	     tmp=state.StrPtr
	     Command = XSh_Histo1_Command(tmp)
	     Widget_Control,state.wids.command,Set_Value=Command,/HourGlass
	     tmp = execute(command(0)+',group=event.top')
	     state.psysvar.x=!x
	     state.psysvar.y=!y
	     state.psysvar.p=!p
            END
            'Save to file...': BEGIN
              str_par = *(state.strPtr)
              Xop_Input_Save,str_par,File='xsh_histo1.xop',$
                /Write, Group=event.top, Comment='; xop/xsh_histo1(v'+$
              xsh_histo1_version()+') input file on '+SysTime()
            END
            'Save as default': BEGIN
              str_par = *(state.strPtr)
              Xop_Input_Save,str_par,Group=event.top, $
                Default='xsh_histo1.xop',Comment='; xop/xsh_histo1(v'+$
              xsh_histo1_version()+') input file on '+SysTime()
            END
          ENDCASE
        END


    'APPLY': Begin
        ; update window bar
        wTitle = 'Histo1: '+ (*(state.strPtr)).shadow_in
        state.wTitle=wTitle
        Widget_Control,state.wids.base,TLB_Set_Title= wTitle
	;update command
	tmp=state.StrPtr
	Command = XSh_Histo1_Command(tmp)
	Widget_Control,state.wids.command,Set_Value=Command,/HourGlass
	tmp = execute(command(0)+',group=event.top')
	state.psysvar.x=!x
	state.psysvar.y=!y
	state.psysvar.p=!p
	End
    'PRINT': Begin
	Widget_Control,state.wids.command,Get_Value=Command
	XPrint,Buffer=command(0), Group=event.top
	End
    'REFRESH': Begin
	Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
	if strcompress(Command(0),/Rem) NE '' then begin
	  tmp = execute(command(0)+',group=event.top')
	  state.psysvar.x=!x
	  state.psysvar.y=!y
	  state.psysvar.p=!p
          Widget_Control,state.wids.base,TLB_Set_Title= 'Histo1: '+command[0]
	endif
	End
    'REFRESHNEW': Begin
	Widget_Control,state.wids.command,Get_Value=Command,/HourGlass
	IF StrCompress(command[0],/Rem) EQ '' THEN BEGIN 
	  XSh_Histo1,/NoExecute
	ENDIF ELSE BEGIN
	  str = *state.strPtr
	  XSh_Histo1,str,wTitle=state.wTitle
	ENDELSE
	END
    'SHOWHIDE': Begin
	Case state.controls_status of
	'hiden': Begin
		Widget_Control,state.wids.showhide,set_value='Hide controls'
		state.controls_status='shown'
		p=0
		Widget_Control,/HourGlass
		Widget_control,state.wids.refresh,sensitive=0
		Widget_control,state.wids.refreshNew,sensitive=0
		xsh_histo1_controls,state.strptr,TLB_ID=p,Group=event.top, $
			Caller_ID=event.handler
		state.wids.controls=p
		End
	'shown': Begin
		Widget_Control,state.wids.showhide,set_value='Show controls'
		state.controls_status='hiden'
		Widget_control,state.wids.refresh,sensitive=1
		Widget_control,state.wids.refreshNew,sensitive=1
		IF state.wids.controls NE 0L THEN $
			Widget_Control,state.wids.controls,/destroy
		state.wids.controls=0L
		End
	EndCase
	End
    'CURSOR': Begin
		widget_control,state.wids.draw,get_value=windownum
		wset,windownum
		!p=state.psysvar.p
		!x=state.psysvar.x
		!y=state.psysvar.y
		coords_d = [event.x,event.y]
		if (coords_d(0) GT !d.x_size or coords_d(0) LT 0 or $
		  coords_d(1) GT !d.y_size or coords_d(1) LT 0) then return
		;if keyword_set(state.dthcurrent) then begin
		  coords = convert_coord(event.x,event.y,/device,/to_data)
		;endif else coords = coords_d
		widget_control,state.wids.cursor,SET_VALUE='  ('+$
			strcompress(coords(0),/REM)+','+$
			strcompress(coords(1),/REM)+')'
	End
    'Help.XSh_Histo1': xhelp,'xsh_histo1',GRO=event.top
    'Help.Histo1': xhelp,'histo1',GRO=event.top
    else: print,'else : ',eventUValue
ENDCASE


Widget_Control, stateid, Set_UValue=state, /No_Copy

END
;
;===============================================================================
;
PRO xsh_histo1,input, Group = group , File=file, Col=col, Wtitle=wtitle, $
 NOEXECUTE=noexecute

on_error,2
;
; analyse input
;
CASE type(input) OF
  0: BEGIN ; undefined
	str = XSh_Defaults('XSH_HISTO1')
	ptr = Ptr_New(str)
     END
  8: BEGIN ; structure
	ptr = Ptr_New(input)
     END
  10: BEGIN ; pointer
	ptr = input
     END
ENDCASE

if keyword_set(file) then (*ptr).shadow_in=file
if keyword_set(col) then (*ptr).col=col


; check if file exists
if checkfile((*ptr).shadow_in) NE 1 then begin
  itmp = Dialog_Message(/Question,Dialog_Parent=group,$
  ['XSH_HISTO1: Input file does not exist: '+(*ptr).shadow_in,'Abort?'])
  if itmp EQ 'Yes' then return
endif

if not(keyword_set(wtitle)) then wtitle='Histo1 window'
; 
; Create widgets
;
wbase=widget_base(/col,MBAR=wMenuBar,Title=wtitle,$
 /TLB_Size_Events,UVALUE='RESIZE')
wstate=widget_base(wbase) ; to store state

;Menu bar
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wtmp0 = widget_button(wFileMenu,VALUE='XSh_Histo1 input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Print...', Uvalue= 'PRINT',/Separator)
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'QUIT',/Separator)

wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='XSh_Histo1', $
	UVALUE='Help.XSh_Histo1')
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Histo1', UVALUE='Help.Histo1')


wblk =widget_base(wbase,/col)

wtmp0 = Widget_Base(wbase,/Row)
wtmp = Widget_Button(wtmp0,Value='Quit',UValue='QUIT')
wshowhide = Widget_Button(wtmp0,Value='Show controls',UValue='SHOWHIDE')
wrefresh = Widget_Button(wtmp0,Value='Refresh',UValue='REFRESH')
wrefreshNew = Widget_Button(wtmp0,Value='Refresh in a new window', $
	UValue='REFRESHNEW')
wtmp0 = Widget_Base(wbase,/Row)
wcursor = Widget_Label(wtmp0,Value='**************************',UValue='DUMMY')

WDraw = widget_draw(wbase,xsize=400,ysize=400,$
	/MOTION_EVENTS,UVALUE='CURSOR',RETAIN=2, $ 
	BUTTON_EVENTS=1)

if sdep() EQ 'UNIX' then xsize=55 else xsize=66
wCommand = Widget_Text(wbase,Value='',/Align_Left,XSize=xsize,/Edit,$
	UValue='REFRESH')

wids = {showhide:wshowhide,command:wcommand, controls:0L, draw:wdraw,$
	base:wbase,cursor:wcursor,refresh:wrefresh,refreshNew:wRefreshNew}
state = {wids:wids, controls_status:'hiden', strptr:ptr, $
	type_input:type(input), psysvar:{x:!x,y:!y,p:!p}, $
	wtitle:wTitle}

stateid = Widget_Info(wbase,/Child)
Widget_Control, stateid, Set_UValue=state, /No_Copy

widget_control,wbase,/realize

Command = XSh_Histo1_Command(ptr)
if not(keyword_set(noexecute)) then begin
  Widget_Control,/HourGlass
  itmp = execute(command(0)+',group=group')
  Widget_Control,wcommand,Set_Value=command(0)
endif 

xmanager, 'xsh_histo1', wbase, GROUP=group, /No_Block

end

