function p_table,input,density=density,symbol=symbol,shadow=shadow
;+
; function p_table
; periodic table of the elements
; under construction v 0.1 MSR/94/03/02
;
; the returned value depends on the keyword set
; /density returns density
; /symbol returns the atomic symbol
; /shadow returns the symbol as shadow wants (i.e. CC for carbon)
;
; Modification: MSR 16/1/95 add entries for Diamond and He20 (He at 20 degrees)
; srio@esrf.fr C density is 2.62 and not 2.22 <bagnasco@SLAC.Stanford.EDU>
;-
on_error,2


n_elems = 106
z = indgen(n_elems)
symbols = strarr(n_elems)
densities = fltarr(n_elems)
symbols(0:10) = ['Vacuum','H','He','Li','Be','B','C','N','O','F','Ne']
symbols(11:20) = ['Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca']
symbols(21:30) = ['Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn']
symbols(31:40) = ['Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y','Zr']
symbols(41:50) = ['Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn']
symbols(51:60) = ['Sb','Te','I','Xe','Cs','Ba','La','Ce','Pr','Nd'] 
symbols(61:70) = ['Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb']
symbols(71:80) = ['Lu','Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg']
symbols(81:90) = ['Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th']
symbols(91:100)= ['Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm']
symbols(101:103)= ['Md','No','Lw']
symbols(104:105)= ['Diamond','He20' ]
;
; densities (g/cm^3) (frm X-ray booklet)
;
densities(0:50) = $
 [ 0.0 ,0.0708, 0.122, 0.533, 1.845, 2.34, 2.62, 0.81, 1.14, 1.108, 1.207, $
        0.969, 1.735, 2.6941, 2.32, 1.82, 2.07, 1.56, 1.40, 0.860, 1.55, $
	2.980, 4.53, 6.10, 7.18, 7.43, 7.860, 8.9, 8.876, 8.94, 7.112, $
	5.877, 5.307, 5.72, 4.78, 3.11, 2.6, 1.529, 2.54, 4.456, 6.494, $
	8.55, 10.20, 11.48, 12.39, 12.39, 12.00, 10.48, 8.63, 7.30, 7.30 ]
densities(51:103) = $
       [6.679, 6.23, 4.92, 3.52, 1.870, 3.5, 6.127, 6.637, 6.761, 6.994, $
	7.20, 7.51, 5.228, 7.8772, 8.214, 8.525, 8.769, 9.039, 9.294, 6.953, $
	9.811, 13.29, 16.624, 19.3, 20.98, 22.53, 22.39, 21.41, 18.85, 13.522, $
	11.83, 11.33, 9.730, 9.30, -1., 4.4, -1., 5., 10.05, 11.70, $
	15.34, 18.92, 20.21, 19.80, 13.64, 13.49, 14, -1, -1, -1, $
	-1, -1, -1 ]
densities(104:105) = [3.515,0.155e-3]

found = 0
i = 0
while not(found) do begin
   i = i + 1
   if (i GT n_elems-1) then begin
     print,'Error from P_TABLE: Element not Found'
     return,0
   endif
   if (strcompress(strupcase(input),/REM)  eq strupcase(symbols(i)) or $
       strcompress(strupcase(input),/REM) eq $
		strupcase(symbols(i)+symbols(i))   ) then begin
	found=1
	at_number = i
   endif
endwhile
;
; returning values
;
if keyword_set(density) then begin
  density = densities(at_number)
  print,'P_TABLE: Density for element '+symbols(at_number)+' is ',density
  return,density
endif
if keyword_set(symbol) then begin
  symbol = symbols(at_number)
  print,'P_TABLE: Symbol for element '+symbols(at_number)+' is ',symbol
  return,symbol
endif
if keyword_set(shadow) then begin
  symbol = strupcase(symbols(at_number))
  if strlen(symbol) eq 1 then symbol = symbol+symbol
  if at_number EQ 104 then symbol = 'CC'
  if at_number EQ 105 then symbol = 'HE'
  print,'P_TABLE: SHADOW symbol for element '+symbols(at_number)+' is ',symbol
  return,symbol
endif
end
