;+
;
;======================   XSh_Wiggler_Spectrum    ==============================
;
; XSh_Wiggler_Spectrum is an widget based graphical interface to calculate
; the spectrum of a Wiggler Synchrotron Radiation source.
;
; It interfaces the program wiggler_spectrum. This program belongs to 
; the ray-tracing package SHADOW.
;
; DESCRIPTION OF THE MAIN WINDOW CONTROLS:
;	FILE:
;	  LOAD  XSH_WIGGLER_SPECTRUM INPUT FILE: Load  xsh_wiggler_spectrum 
;		inputs from a binary file.
;         WRITE  XSH_WIGGLER_SPECTRUM  INPUT FILE: Writes the current inputs 
;		to a binary file. This file can be loaded with the previously
;               described option.
;	  WRITE FILES FOR Transmit: Saves the selected result file in
;	            the Flux file XSH_SRCOMPE and the Power file XSH_SRCOMPW.
;	  QUIT:     Exit the interface program and deletes temporary files.
; 	SET_PARAMETERS:
; 	  K(Gap) Tool:  Opens the K(Gap) tool application that permits to
;		calculate the K value as a function of the wiggler gap.
; 	  Set Paramaters:  Opend the main window for parameter definition. 
; 		The effect of this menu option is identical to pressing
;               the "Set Parameters: button in the main xsh_wiggler_spectrum 
;		window.
; 	  Set Defaults:  Initializes all the parameters to their default
; 		values.
; 	SHOW:       Plot Results (trajectories and Spectra) or Show Result 
;		Parameters.
;	HELP:       Shows the xsh_wiggler_spectrum help text. 
;
; CUSTOMIZATION OF XSH_WIGGLER_SPECTRUM INPUT PARAMETERS:
;	The input parameters of xsh_wiggler_spectrum are hard-coded in the file
;	xsh_defaults.pro which, in general, is not available for 
;	user-modifications.
;	It is possible to customize the default values by adding/changing
;	entries in the .xsh_defaults file. 
;	Two copies of .xsh_defaults are sequentially read by the application: 
;	the first one, sitting in $XSH_HOME, is the "installation" copy,
;	and the purpose is to place the defaults of the particular xop 
;	installation. The system-administrator should do that.
;	The second .xsh_defaults file is placed in $HOME (user's home 
;	directory). The users should place his/her defaults here and
;	will only affect his xop session.
;	If you are running XSH on a PC, the file to customize is 
;	the "installation" one: %XSH_HOME%\.xsh_defaults
;	The entries in .xsh_defaults concerning the xsh_wiggler_spectrum 
;	application are described below. Customize ONLY the ones that differ 
;	from the default. This will save initialization time. 
;
;	xsh_wiggler_spectrum.parameters.field='0' 	
;					; 0=Sinusoidal, 1=B from file,
;					; 2=B from harmonics
;	xsh_wiggler_spectrum.parameters.Nperiods=12
;	xsh_wiggler_spectrum.parameters.Ulambda=0.125
;	xsh_wiggler_spectrum.parameters.K= 14.
;	xsh_wiggler_spectrum.parameters.Energy= 6.04
;	xsh_wiggler_spectrum.parameters.Phot_energy_min= 100.0
;	xsh_wiggler_spectrum.parameters.Phot_energy_max= 100100.0
;	xsh_wiggler_spectrum.parameters.Phot_energy_step= 10000.0
;	xsh_wiggler_spectrum.parameters.Current= 100.
;	xsh_wiggler_spectrum.parameters.File: 'datafile'
;	xsh_wiggler_spectrum.kgap_tool.Br:1.57     ; K(GAP) Tool parameters.
;	xsh_wiggler_spectrum.kgap_tool.Bp:!pi
;
; COPYRIGHT:
;	xsh_wiggler_spectrum (version 1.2) belongs to XSH package and it is 
;	distributed within XSH.
;	PLEASE REFER TO THE XSH COPYRIGHT NOTICE BEFORE USING IT.
;
; LAST MODIFICATION: msr/msr/97-12-05
;
;-
;       Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF, Jan 1994
;       Modification history:
;		94-02-17 MSR includes the asymmetrical wiggler
;		94-10-27 MSR Removes common blocks. General cosmetics.
;		95-11-07 MSR adds file in/out. Adapts to xop 1.3b
;       	96/01/19 MSR changes labels Xtransmit -> XOP/Optics
;       	97/01/23 MSR adapts for Windows95. Cosmetics,version 1.1
;       	97/10/01 MSR renames read_ascii by rascii, uses sdep(),
;			 uses coltitles in xplot.
;       	97/10/02 MSR makes use of xop_wd,/default 
;       	97/10/27 MSR updates doc.
;       	97/11/10 MSR adds K(GAP) Tool.
;       	97/12/05 MSR adapts for SHADOW-GUI. version 1.2
;
;
;========================================================================
;
FUNCTION XSH_WIGGLER_SPECTRUM_VERSION
return,'1.2'
end
;		
;========================================================================
;
PRO XSH_WIGGLER_SPECTRUM_INP_WRITE,inp
;
; write the contents of the structure with parameters for running 
; wiggler_spectrum
;
OPENW,unit,'xsh_ws_epath_tmp.inp',/GET_LUN
;
; write xsh_ws_epath_tmp.inp in the case of standard wiggler (sinusoidal)
;
if (strcompress(inp.Field(0),/rem) EQ '0') then begin
  PRINTF,Unit,'1'
  PRINTF,unit,inp.Nperiods
  PRINTF,Unit,'1'
  PRINTF,unit,inp.Ulambda
  PRINTF,unit,inp.K
  PRINTF,unit,STRCOMPRESS(inp.Energy,/REMOVE_ALL)
  PRINTF,unit,'101'
  PRINTF,unit,'1'
  PRINTF,unit,'xsh_ws_epath_tmp.par'
  PRINTF,unit,'xsh_ws_epath_tmp.traj'
endif 
;
; Magnetic field in external file
;
if (strcompress(inp.Field(0),/rem) EQ '1') then begin
  printf,unit,'0'
  printf,unit,inp.File
  printf,unit,inp.Nperiods
  PRINTF,unit,STRCOMPRESS(inp.Energy,/REMOVE_ALL)
  printf,unit,'xsh_ws_epath_tmp.par'
  printf,unit,'xsh_ws_epath_tmp.traj'
endif 
;
;Magnetic field from file with harmonics
;
if (strcompress(inp.Field(0),/rem) EQ '2') then begin
  printf,unit,'1'
  printf,unit,inp.File
  PRINTF,unit,inp.Ulambda
  printf,unit,inp.Nperiods
  printf,unit,'41'
  PRINTF,unit,STRCOMPRESS(inp.Energy,/REMOVE_ALL)
  printf,unit,'xsh_ws_epath_tmp.par'
  printf,unit,'xsh_ws_epath_tmp.traj'
  printf,unit,'0'
endif 
FREE_LUN,unit
;
OPENW,unit,'xsh_wiggler_spectrum_tmp.inp',/GET_LUN
PRINTF,unit,'xsh_ws_epath_tmp.traj'
PRINTF,unit,'1'
PRINTF,unit,STRCOMPRESS(inp.Phot_energy_min,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(inp.Phot_energy_max,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(inp.Phot_energy_step,/REMOVE_ALL)
PRINTF,unit,'xsh_wiggler_spectrum_tmp.out'
PRINTF,unit,'2'
PRINTF,unit,STRCOMPRESS(inp.Current,/REMOVE_ALL)
FREE_LUN,unit
;
END
;
;==========================================================================
;
PRO xsh_wiggler_spectrum_event,event
;
; register the events
;
Widget_control, event.id, Get_uvalue=eventuval

stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_Copy

CASE eventuval OF
	'QUIT': BEGIN
		case sdep() of
		  'WINDOWS': command = ['del xsh_wiggler_spectrum_tmp.inp ',$
		  	'del xsh_ws_epath_tmp.inp','del xsh_ws_epath_tmp.traj',$
			'del xsh_ws_epath_tmp.par','del xsh_wiggler_spectrum_tmp.out']
		  'UNIX': command = $
		        '/bin/rm -f xsh_wiggler_spectrum_tmp.inp xsh_ws_epath_tmp.inp '+ $
			'xsh_ws_epath_tmp.traj xsh_ws_epath_tmp.par xsh_wiggler_spectrum_tmp.out'
		  else: 
		endcase
		xsh_run,command
		WIDGET_CONTROL,event.top,/DESTROY
		Return
		END
	'FILELOAD': BEGIN
		if sdep() EQ 'UNIX' then filter='*.inp' else filter=0
		ffile = Dialog_Pickfile(title= $
		'Select XSh_wiggler_spectrum input file...',/NOCONF,$
		FILTER=filter,GROUP=event.top)
		if strcompress(ffile,/rem) EQ '' then goto,out
		version = 0
		restore,ffile,/VERBOSE
		if version NE xsh_wiggler_spectrum_version() then $ 
		  itmp = Dialog_message(dialog_parent=event.top,$
		  'Input file and current XSh_wiggler_Spectrum have '+$
		  'different versions.')
		state.str.parameters = str_par
		END
	'FILEWRITE': BEGIN
		str_par = state.str.parameters
		ffile = Dialog_Pickfile(/WRITE,file='xsh_wiggler_spectrum.inp')
		if strcompress(ffile,/rem) EQ '' then GoTo,out
		version = xsh_wiggler_spectrum_version()
		command = 'save,version,str_par,'+$
		'FILENAME='+"'"+strcompress(ffile,/rem)+"'"+',/VERBOSE'
		tmp = execute(command)
		END
	'SETDEF': BEGIN
		itmp = Dialog_Message(dialog_parent=event.top, $
		/Question,['This option initializes the',$
		'xSh_wiggler_spectrum parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Please confirm'],title='xsh_wiggler_spectrum: set defaults')
		if itmp eq 'No' then goto,out
		tmp = xop_defaults('xsh_wiggler_spectrum')
		state.str.parameters = tmp.parameters
		END
	'KGAP_TOOL': BEGIN
		K=state.str.parameters.K
		Period=state.str.parameters.Ulambda
		Br=state.str.kgap_tool.Br
		Bp=state.str.kgap_tool.Bp
		kgap_tool,K=K,Period=Period,group=event.top,Br=Br,Bp=Bp
		state.str.parameters.K=K
		state.str.parameters.Ulambda=Period
		state.str.kgap_tool.Br=Br
		state.str.kgap_tool.Bp=Bp
		END
	'SETPAR': BEGIN
		inp = state.str.parameters

                if sdep() EQ 'WINDOWS' then helpcmd = "xdisplayfile1,'"+$
                  getenv('XSH_HOME')+$
		  "\doc\xsh_wiggler_spectrum.par', group=event.top" else $
                  helpcmd = "xdisplayfile1,'"+getenv('XOP_HOME')+$
                  "/doc/xsh_wiggler_spectrum.par',group=event.top"

		XSCRMENU,inp,GROUP=base,NCOLUMN=2,/NOTYPE,$
		  TITLES=state.str.titles, FLAGS=state.str.flags,  $
		  ACTION=action, WTITLE='xsh_wiggler_spectrum input values',$
		  /INTER, HELP=helpcmd
		if action eq 'DONT' then GoTo,out
		state.str.parameters = inp
		widget_control,/hourglass
		if (strcompress(inp.Field(0),/rem) EQ '0') then begin
		  ;PRINT,'############# start running epath ####################'
		  XSH_WIGGLER_SPECTRUM_INP_WRITE,inp
		  command = 'epath < xsh_ws_epath_tmp.inp'
		  ;xsh_run,command
		  ;PRINT,'############# end running epath ######################'
		endif else begin
		  ;
		  ; check if files exist
		  ;
		  openr,Unit,inp.File,Error=error,/Get_lun
		  if (error NE 0) then begin
		    tmp=Dialog_Message(dialog_parent=event.top, $
			/error,'Error reading File')
		    GoTo,out
		  endif 
		  free_lun,Unit
		  ;PRINT,'############# start running btraj ####################'
		  XSH_WIGGLER_SPECTRUM_INP_WRITE,inp
		  command = 'btraj < xsh_ws_epath_tmp.inp' 
		  ;xsh_run,command
		  ;PRINT,'############# end running epath ######################'
		endelse
		;PRINT,'######### start running wiggler_spectrum #############'
		;command = 'wiggler_spectrum < xsh_wiggler_spectrum_tmp.inp'
		 command = [command , $
		  'wiggler_spectrum < xsh_wiggler_spectrum_tmp.inp']
		;xsh_run,command
		;PRINT,'########### end running wiggler_spectrum #############'
		xsh_run,command
		END
        'HELP': xhelp,'xsh_wiggler_spectrum',Group=event.top
        'WRITE': BEGIN
		;
		; Prepare file with Power, needed for XOP/Optics
		;
		tmp = rascii('xsh_wiggler_spectrum_tmp.out')
		IF not(keyword_set(tmp) ) THEN BEGIN
		  message,/info,$
		    'Data in  xsh_wiggler_spectrum_tmp.out not found. '
		  itmp = Dialog_Message(dialog_parent=event.top, $
			/ERROR,['wiggler data not found...',$ 
			' Set Parameters before...  '])
		  GoTo,out
		ENDIF ELSE BEGIN
		  tmp2 = tmp
		  tmp2(1,*)=tmp(1,*)*1.602189E-16
		  openw,Unit,'XSH_SRCOMPW',/GET_LUN
		  printf,Unit,tmp2
		  FREE_LUN,Unit
		  if sdep() EQ 'WINDOWS' then command = $
		    'copy xsh_wiggler_spectrum_tmp.out XSH_SRCOMPE' else $
		     command = $
		    '/bin/cp xsh_wiggler_spectrum_tmp.out XSH_SRCOMPE'
		  message,/info,'Executing: '+command
		  spawn,command
		  itmp = Dialog_Message(dialog_parent=event.top, $
			/INFO,'files XSH_SRCOMPE and XSH_SRCOMPW'+ $
			' written to disk.')
		ENDELSE
		END
	'PARAMETERS':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		tmp = rascii('xsh_wiggler_spectrum_tmp.out')
		IF not(keyword_set(tmp) ) THEN BEGIN
		 message,/info,'Data in file xsh_wiggler_spectrum_tmp.out not found. '
		 itmp =  Dialog_Message(dialog_parent=event.top, $
			/ERROR,['wiggler data not found...',$ 
			' Set Parameters before...  '])
		 goto,out
		ENDIF 
		XDISPLAYFILE1,'xsh_ws_epath_tmp.par',GROUP=event.top,title=$
		'xsh_wiggler_spectrum parameters'
		END
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		widget_control,/hourglass
		tmp = rascii('xsh_wiggler_spectrum_tmp.out')
		IF not(keyword_set(tmp) ) THEN BEGIN
		 message,/info,'Data in file xsh_wiggler_spectrum_tmp.out not found. '
		 itmp =  Dialog_Message(dialog_parent=event.top, $
			/ERROR,['wiggler data not found...',$ 
			' Set Parameters before...  '])
		 goto,out
		ENDIF 
		titles=['Photon Energy [eV]','Flux[Phot/sec/eV]',$
			'Flux[Phot/sec/0.1%bw]','Power[Watts/eV]',$
			'Power[Watts/0.1%bw]']
 		tmp2 = fltarr(5,n_elements(tmp(0,*))) 
		tmp2(0,*) = tmp(0,*)
		tmp2(1,*) = tmp(1,*)/(tmp(0,*)*.1e-2)
		tmp2(2,*) = tmp(1,*)
		tmp2(3,*) = tmp(1,*)*1.602189E-16
		tmp2(4,*) = tmp(1,*)*tmp(0,*)*1.602189E-19
		XPLOT,tmp2,GROUP=event.top,coltitles=titles,xtitle='-1',$
		ytitle='-1', wtitle='xsh_wiggler_spectrum results',$
		xcol=1,ycol=3,/XLOG,/YLOG
		  END
	'TRAJ':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		widget_control,/hourglass
;		if sdep() EQ 'WINDOWS' then file = 'epath.tra' else $
		  file = 'xsh_ws_epath_tmp.traj'
		tmp = rascii(file)
		IF not(keyword_set(tmp)) THEN BEGIN
		  message,/info,'Data in xsh_epath_tmp.traj not found. '
		  itmp = Dialog_Message(dialog_parent=event.top, $
			/ERROR,['wiggler data not found...',$ 
			' Set Parameters before...  '])
		  goto,out
		ENDIF 
		trajTitles = ["x[m]","y[m]","z[m]",$
			"BetaX","BetaY","BetaZ","Curvature"]
		XPLOT,tmp,XCOL=2,YCOL=1,GROUP=event.top,coltitles=trajTitles,$
		  xtitle='-1',ytitle='-1',$
		  WTITLE='xsh_wiggler_spectrum: trajectories'
		END
ENDCASE
out:
Widget_Control, stateid, Set_Uvalue=state, /No_Copy
END
;
;==============================================================================
;
PRO XSH_WIGGLER_SPECTRUM, GROUP=group
;
on_error,2
;
if xregistered('xsh_wiggler_spectrum') then return

;
; widget definition
;

base=WIDGET_BASE(/COLUMN,TITLE='xsh_wiggler_spectrum '+$
	xsh_wiggler_spectrum_version(),MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)
  wtmp = widget_button(wFile,VALUE='Load XSh_wiggler_spectrum input file...', $
		UVALUE='FILELOAD')
  wtmp = widget_button(wFile,VALUE='Write XSh_wiggler_spectrum input file...', $
		UVALUE='FILEWRITE')
  wtmp = widget_button(wFile,VALUE='Write Files for Transmit', $
		UVALUE='WRITE')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='K(Gap) Tool', UVALUE='KGAP_TOOL')
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wSpec = widget_button(wResults,VALUE='Spectra',UVALUE='SHOW')
  wTraj = widget_button(wResults,VALUE='Trajectories',UVALUE='TRAJ')
  wtmp = widget_button(wResults,VALUE='Parameters',UVALUE='PARAMETERS')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='xsh_wiggler_spectrum', UVALUE='HELP')
;
wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')

if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

;junk = WIDGET_LABEL( BASE, FONT=font, VALUE=' SHADOW utilities:')
junk = WIDGET_LABEL( BASE, FONT=font, VALUE='   WIGGLER_SPECTRUM   ')
junk = WIDGET_LABEL( BASE, FONT=font, VALUE='  Wiggler  Radiation  ')
junk = WIDGET_LABEL( BASE, FONT=font, VALUE='  (SHADOW utilities)  ')

;
;state
;
str = xsh_defaults_utils('xsh_wiggler_spectrum')
wids = {dummy:0L}
state = { str:str, wids:wids}
;
;actions
;
Widget_control,Widget_Info(base,/Child),Set_uvalue=state,/No_Copy
Widget_control,base,/Realize
Xmanager,'xsh_wiggler_spectrum',base,Group_leader=group,/No_Block
end
