PRO waviness_calc,str,out,slopes=slopes,nowrite=nowrite
;c+++
;c
;c	PROGRAM		WAVINESS_GEN
;c
;c	PURPOSE		This program generates a random slope error surface
;c
;c	ALGORITHM       See M. Sanchez del Rio and A. Marcelli,
;c			NIM-A319 (1992) 170-177
;c
;c	COMPILATION NOTE: f77 +E1 in hp systeme (MSR 95/09/25)
;c
;c	MODIFICATION HISTORY
;c			June 1991	first version
;c			September 1991	update 
;c			October 1991	moved to Sun
;c			September 1992	distribution version
;c			February 2006	translated to IDL (srio@esrf.fr)
;c---

; variable initialization
 
IF N_Elements(str) EQ 0 THEN str=waviness_read(/Default)
IF N_Elements(nowrite) EQ 0 THEN nowrite=0

t0=systime(1)

x=DblArr(str.npointx)
y=DblArr(str.npointy)
coe=DblArr(str.n+1)
shi=DblArr(str.n+1)
ranc=DblArr(str.n+1)
shin=DblArr(str.n+1)
zz=DblArr(str.npointx,str.npointy)
xx=DblArr(str.npointx)
yy=DblArr(str.npointy)
;print,'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
;help,coe,str.n

;c
;c  reads input
;c
	yfact = 1.D0
	slp = str.slp/3600D0*!dpi/180.D0   ; pass to rads
;c
	xfact = str.xlength/!dpi
	i_plot = 0
	xntot = 0.0D0
	iseed1=str.iseed
	iseed2=str.iseed+11L
        tmp = r_myrand(initseed=[iseed1,iseed2],/OnlyInit)
;print,'<><>iseeds: ',iseed1,iseed2
        FOR i=0L,str.n DO BEGIN
         a1=(str.c)[i]
         a2=(str.y)[i]
         a3=(str.g)[i]
	 xntot = xntot + a1
	 amp = slp*str.xlength/(0.5D0+double(i))/sqrt(2.D0)/!dpi
	 coe(i) = a1*amp
	 shin(i) = a2
	 ranc(i) = a3 
;print, 'i,coe(i),amp,a1,a2,a3',i,coe(i),amp,a1,a2,a3,'-', $
; slp,str.xlength


;print, 'i,coe(i),shin(i),ranc(i)',i,coe(i),shin(i),ranc(i)
        ENDFOR

;print, 'xntot = ',xntot
	FOR i=0L,str.n DO BEGIN
	  coe(i) = coe(i)/sqrt(xntot)       ; for a single harmonic
;print,'<><>i,coe:',i,coe(i)
        ENDFOR
;print,'<><>'

;c
;c	begin calculations
;c
;print,'Start : ',t0
;print,'Begin calculations: ',systime(1)-t0
	stp = !dpi/(str.npointy-1)
	stpx = str.width/(str.npointx-1)
	stpy = str.xlength/(str.npointy-1)
	k=0D0
label10:
	xx(k)=-(str.width/2)+stpx*k
	FOR j=0L,str.n DO BEGIN
	  tmp = r_myrand(1.0D0)
	  shi(j)=shin(j)*!dpi+tmp*!dpi*ranc(j)
;IF k LE 1 THEN print,'k,rand,shi',k,tmp,shi(j)
        ENDFOR

;	FOR i=0,str.npointy-1 DO BEGIN
;	  y(i)=0.0D0
;        ENDFOR
	y[*]=0.0D0

;tmp=systime(1)
	FOR j=0L,str.n DO BEGIN
	  ;FOR i=0L,str.npointy-1 DO BEGIN
	    x= -!dpi/2 + DIndGen(str.npointy)*stp
	    nn=double(j)
	    ynew= coe[j]*( (-1D0)^nn*cos((2D0*nn+1D0)*(x+shi[j])))
	    y=ynew+y
;help,ynew,x,y
          ;ENDFOR
	  ;FOR i=0L,str.npointy-1 DO BEGIN
	  ;  x(i)= -!dpi/2 + Double(i)*stp
	  ;  nn=double(j)
	  ;  ynew= coe(j)*( (-1D0)^nn*cos((2D0*nn+1D0)*(x(i)+shi(j))))
	  ;  y(i)=ynew+y(i)
          ;ENDFOR
        ENDFOR
;print,'Loop : ',k,systime(1)-tmp

	
        ;FOR i=0L,str.npointy-1 DO BEGIN
	;  x(i)=x(i)*xfact
	;  yy(i) = x(i)
	;  y(i)=y(i)*yfact
	;  zz(k,i)=y(i)
        ;ENDFOR
        ;FOR i=0L,str.npointy-1 DO BEGIN
	  x=x*xfact
	  yy = x
	  y=y*yfact
	  zz(k,*)=y
        ;ENDFOR
	k=k+1
	IF (k LT Double(str.npointx)) THEN GOTO,label10

	; 
	; define structure with result 
	;
	out={z:zz,x:xx,y:yy}

;c
;c	writes file for shadow
;c
	IF not(nowrite) THEN BEGIN
          openw,unit,str.file,/get_lun
	  printf,unit, str.npointx, str.npointy
	  printf,unit, yy
	  FOR i=0L,str.npointx-1 DO BEGIN
	    printf,unit,xx(i),zz(i,*)
          ENDFOR
	  Free_Lun,unit
	  Print,'File written to disk: ',str.file
	  print,'   Don`t forget to run PRESURFACE before SHADOW'
	  print,' '
	ENDIF

;c
;c  calculate the slope error rms of the whole surface
;c
	IF Keyword_Set(slopes) THEN BEGIN
	  tmp = slopes(out)
	ENDIF

END ; waviness_calc
