PRO mirinfo,element,name = name, Group = group, REMOVE = remove
;+
; NAME:
;	MIRINFO
; PURPOSE:
;	an IDL interface of the MIRINFO SHADOW's utility
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	mirinfo,n,keyword_parameters
; INPUTS:
;	shadow_in   may be:
; OPTIONAL INPUT PARAMETERS:
; KEYWORD PARAMETERS:
;        NAME = 'name' a string with the name of the file to be
;               processed with mirinfo (default-'end')
;        GROUP = the widget id of the group parent
;        REMOVE = if set, remove temporary files
; OUTPUTS:
;	a window (in X or WIN device) or a text
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	Creates temporal files, and calls the SHADOW's mirinfo
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, 8 July 1993
;	97-04-02 MSR adds call to xsh_defaults to initialize shadow.
;	97-11-04 srio@esrf.fr uses xsh_run to spawn shadow process.
;	98-03-13 srio@esrf.fr adds Group kw
;	98-03-17 srio@esrf.fr checks for file existence
;	98-04-04 srio@esrf.fr adds /Remove kw. Other cleaning.
;-
on_error,2
if n_params() EQ 0 then element=1
if not(keyword_set(name)) then name='end'
if (element lt 10) then file = name+'.0'+strcompress(element,/rem) $
  else file = name+'.'+strcompress(element,/rem)

if checkfile(file) NE 1 then begin
 itmp = Dialog_Message(/Error,Dialog_Parent=group,$
	'MIRINFO: File not found: '+file)
  return
endif
message,/info,'file analyzed is: '+file

openw,unit,'xsh_mirinfo_tmp.inp',/get_lun
printf,unit,file
printf,unit,'mirinfo called from SHADOW VUI'
printf,unit,''
printf,unit,'xsh_mirinfo_tmp.out'
free_lun,unit
;
command = 'mirinfo < xsh_mirinfo_tmp.inp'
xsh_run,command

if sdep(/w) then begin
  xdisplayfile1,'xsh_mirinfo_tmp.out', REMOVE=remove, Group=group  
endif else begin
  a = read_textfile('xsh_mirinfo_tmp.out')
  for i=0,n_elements(a)-1 do print,a(i)
  if keyword_set(remove) then begin
    case sdep() of
      'UNIX': command='/bin/rm -f xsh_mirinfo_tmp.out'
      'WINDOWS': command='del xsh_mirinfo_tmp.out'
      else: command = ''
    endcase
    message,/info,'Executing: '+command
    spawn,command
  endif
endelse
if keyword_set(remove) then begin
  case sdep() of
     'UNIX': command='/bin/rm -f  xsh_mirinfo_tmp.inp'
     'WINDOWS': command='del xsh_mirinfo_tmp.inp'
     else: command = ''
  endcase
  message,/info,'Executing: '+command
  spawn,command
endif
;
end
