Function XSh_Plotxy_Command,PStr
;
; create command
;

;
; General
;
c_general = 'plotxy,' 

c_general = c_general +  "'"+(*pstr).shadow_in+"'"

c_general = c_general +  ','+StrCompress((*pstr).col1,/Rem)+ $
                         ','+StrCompress((*pstr).col2,/Rem)
IF (*pstr).xrange(0) NE (*pstr).xrange(1) THEN $
  c_general = c_general+',XRange='+$
  Vect2String([(*pstr).xrange(0),(*pstr).xrange(1)])
IF (*pstr).yrange(0) NE (*pstr).yrange(1) THEN $
  c_general = c_general+',YRange='+$
  Vect2String([(*pstr).yrange(0),(*pstr).yrange(1)])
IF Abs( (*pstr).retrace)  GT 1e-6 THEN $
  c_general = c_general + ',Retrace='+StrCompress((*pstr).Retrace,/rem)
IF (*pstr).nolost NE 0 THEN $
  c_general = c_general + ',NoLost='+StrCompress((*pstr).nolost,/rem)
IF (*pstr).cart NE 0 THEN $
  c_general = c_general + ',Cart='+StrCompress((*pstr).cart,/rem)
IF (*pstr).contour NE 0 THEN $
  c_general = c_general + ',Contour='+StrCompress((*pstr).contour,/rem)
;
; histograms
;
c_histo='' 
IF (*pstr).histo NE 0 THEN $
  c_histo = c_histo + ',Histo='+StrCompress((*pstr).histo,/rem)
IF (*pstr).NBins NE 0 AND (*pstr).NBins NE 25 THEN $
  c_histo = c_histo + ',NBins='+StrCompress((*pstr).nbins,/Rem)

IF (*pstr).contour NE 0 THEN BEGIN
  IF (*pstr).NC_Bins NE 0 AND (*pstr).NC_Bins NE (*pstr).NBins THEN $
    c_histo = c_histo + ',NC_Bins='+StrCompress((*pstr).NC_Bins,/Rem)
  IF (*pstr).nLevels NE 0 AND (*pstr).NLevels NE 6 THEN $
    c_histo = c_histo + ',NLevels='+StrCompress((*pstr).NLevels,/Rem)
  IF (*pstr).Smooth NE 0 THEN $
    c_histo = c_histo+',Smooth='+StrCompress((*pstr).smooth,/rem)
ENDIF

IF (*pstr).calfwhm NE 0 THEN $
  c_histo = c_histo + ',CalFWHM='+StrCompress((*pstr).calfwhm,/rem)
IF (*pstr).gaussfit NE 0 THEN $
  c_histo = c_histo + ',GaussFit='+StrCompress((*pstr).gaussfit,/rem)
;
; color
;
c_color=''
IF (*pstr).ccol NE 0 THEN BEGIN
  c_color = c_color + ',CCol='+StrCompress((*pstr).ccol,/Rem)
  IF StrCompress((*pstr).cfile,/Rem) NE '' THEN $
    c_color = c_color + ',CFile='+"'"+(*pstr).cfile+"'"
  IF (*pstr).cbins NE 0 AND (*pstr).cbins NE 100 THEN $
    c_color = c_color + ',CBins='+StrCompress((*pstr).cbins,/Rem)
  IF (*pstr).climits(0) NE (*pstr).climits(1) THEN $
    c_color = c_color + ',CLimits='+$
    vect2string([(*pstr).climits(0),(*pstr).climits(1)])
  IF (*pstr).cref NE 0 THEN $
    c_color = c_color + ',CRef='+StrCompress((*pstr).cref,/rem)
ENDIF
;
; presentation
;
c_pres = ''
IF StrCompress((*pstr).title,/Rem) NE '' THEN $
  c_pres = c_pres+',Title='+"'"+(*pstr).title+"'"
IF (*pstr).slit(0) NE Total((*pstr).slit)/4 THEN $
  c_pres = c_pres+',Slit='+Vect2String((*pstr).slit)
IF (*pstr).nocomm NE 0 THEN $
  c_pres = c_pres+',NoComm='+StrCompress((*pstr).nocomm,/rem)
IF (*pstr).charsize NE 0 THEN $
  c_pres = c_pres+',CharSize='+StrCompress((*pstr).charsize,/rem)
IF (*pstr).MulFac NE 0 THEN $
  c_pres = c_pres+',MulFac='+StrCompress((*pstr).mulfac,/rem)
;IF (*pstr).NLevels NE 0 THEN $
;  c_pres = c_pres+',NLevels='+StrCompress((*pstr).nlevels,/rem)
IF (*pstr).Publish NE 0 THEN $
  c_pres = c_pres+',Publish='+StrCompress((*pstr).publish,/rem)

Return,c_general+c_histo+c_color+c_pres
End
