PRO write_gfile, str, file
;+
; NAME:
;	WRITE_GFILE
;
; PURPOSE:
;	This writes the contents of an IDL structure in a gfile.
;
; CATEGORY:
;	SHADOW
;
; CALLING SEQUENCE:
; 
;	write_gfile,str [,file]
;
; INPUTS:
;	str:	The IDL structure.
;
; OPTIONAL INPUTS:
;	file:	the file name for the output. If not set, it uses 'start.00'
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	A gfile.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;
;		WRITE_GFILE,str,'start.02'
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio, srio@esrf.fr, 97/11/05
;	98-06-24 srio@esrf.fr adds format when writing float/double.
;	06-02-21 srio@esrf.fr changes format to deal with meV
;-

;
; writes the start.00 file from the corresponding idl structure
; MSR 97/11/04
;
on_error,2
names = tag_names(str)
if keyword_set(file) then file1=file else file1='start.00' 
openw,Unit,file1,/Get_lun
for i=0,n_tags(str)-1 do begin
  nn = n_elements(str.(i))
  mytype = type(str.(i))
  if nn EQ 1 then begin
     if mytype EQ 4 or mytype EQ 5 then $
       printf,Unit,names(i)+' = '+string(str.(i),format='(G17.9)')  else $
       printf,Unit,names(i)+' = '+strcompress(str.(i)) 
  endif else begin 
    for j=0,nn-1 do begin
       if mytype EQ 4 or mytype EQ 5 then $
         printf,Unit,names(i)+'('+strcompress(j+1,/rem)+$
	  ') = '+string((str.(i))(j),format='(G15.8)') else $
         printf,Unit,names(i)+'('+strcompress(j+1,/rem)+$
	  ') = '+strcompress((str.(i))(j))
    endfor
  endelse
endfor
free_lun,Unit
message,/info,'File '+file1+' written to disk.'
end

