pro SET_LATT, cent, isys, ksys
;+
; NAME:
;	SET_LATT
;
; PURPOSE:
;	Subroutine to SYS_ABS.
;
; CATEGORY:
;	Laue data processing, Crystallography
;
; CALLING SEQUENCE:
; 	= SET_LATT()
;
; INPUTS:
;
; KEYWORDED PARAMETERS:
;
; OUTPUTS:
;	
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;	From LDM.FOR (Daresbury Laue Software Suite).
;	(LDM_SET_LATT)
;
; MODIFICATION HISTORY:
;	Written by Thomas Ursby, September 1995
;
;-

KSYS= INTARR(3)
CASE cent OF
  1: ISYS = 0
  2: BEGIN
      ISYS = 2
      KSYS(1) = 1
      KSYS(2) = 1
    END
  3: BEGIN
      ISYS = 2
      KSYS(0) = 1
      KSYS(2) = 1
    END
  4: BEGIN
      ISYS = 2
      KSYS(0) = 1
      KSYS(1) = 1
    END
  5: BEGIN
      ISYS = 2
      KSYS(0) = 1
      KSYS(1) = 1
      KSYS(2) = 1
    END
  6: ISYS = 4
  7: BEGIN
      ISYS = 3
      KSYS(0) = -1
      KSYS(1) = 1
      KSYS(2) = 1
    END
  ELSE: MESSAGE, 'Input CENT should be in the range 1-7.'
ENDCASE

END