function GET_SPECTRUM_POL, file=file
;+
; NAME:
;	GET_SPECTRUM_POL
;
; PURPOSE:
;	From a theoretical spectrum, get a fitted polyom.
;
; CATEGORY:
;	Laue data processing, Crystallography
;
; CALLING SEQUENCE:
; 	result= GET_SPECTRUM_POL(file=file)
;
; INPUTS:
;	file : [optional] enter directly the filename of the spectrum.
;		The file is IDL format
;
; KEYWORDED PARAMETERS:
;
;
; OUTPUTS:
;	Returns the polynom
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;	
; MODIFICATION HISTORY:
;	Written by Dominique Bourgeois, December 1996
;
;-

IF KEYWORD_SET(file) THEN spectrum_file = file ELSE BEGIN
 spectrum_file=''
 READ,'Enter filename of spectrum [IDL format]: ',spectrum_file
ENDELSE
 RESTORE,spectrum_file

lambda = 12.4/spectrum(0,*)
spectrum(2,*)=spectrum(2,*)/MAX(spectrum(2,*))
REPEAT BEGIN
 READ,'Enter degree of polynomial fit :',pdeg
 lambdapol = POLY_FIT(lambda,spectrum(2,*),pdeg,y,/DOUBLE)
 help,lambdapol
 PLOT,lambda,spectrum(2,*),XRANGE=[0.2,2],XTITLE='Lambda [A]',YTITLE='Normalization curve',XSTYLE=1,CHARSIZE=1.5
 OPLOT,lambda,y,LINESTYLE=2
 ok=''
 READ,'Ok ? [yes/no] ',ok
ENDREP UNTIL (ok EQ 'yes')

RETURN, lambdapol

END

