pro WHICH, name, file=file, count=count, quiet=quiet
;+
; NAME:
;	WHICH
;
; PURPOSE:
;	Find which file that would be compiled if the command ".run NAME"
;	would be issued or if a not yet compiled function or procedure 
;	would be called. See also FWHERE.
;
; CATEGORY:
;	Routine managing.
;
; CALLING SEQUENCE:
; 	WHICH, name [, file=file, count=count, quiet=quiet]
;
; INPUTS:
;	NAME: String containing the name of the routine (i.e. to find
;		this file you would issue "WHICH, 'which'" ).
;
; KEYWORDED PARAMETERS:
;	FILE: On exit it contains the found file (or an empty string).
;	COUNT: On exit it is one if a file was found and zero if no
;		file was found.
;	QUIET: If set then nothing is printed to standard output.
;
; OUTPUTS:
;	Prints the found file (the whole path). If no file is found then
;	nothing is printed.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	Printing on standard output.
;
; RESTRICTIONS:
;	The routine first looks in the current directory and then goes 
;	through the !PATH system variable looking for files called 
;	"NAME.pro". Thus it do not necessarily find all callable routines;
;	more specifically not built in routines, routines that has been
;	compiled as a part of a file compiled for some reasons or if 
;	!PATH (or the current directory) has  changed since a routine
;	was compiled. 
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	Thomas Ursby, 1995
;	25/7/96. Fixed bug; didn't check last directory in !path.
;
;-

ON_ERROR, 2

path= '.:'+!path
nr=0
files=''

REPEAT BEGIN
  pos= STRPOS(path, ':')
  IF (pos eq -1) THEN dir=path $
  ELSE dir= STRMID(path,0,pos)
  thisfile= FINDFILE(STRCOMPRESS(dir+'/'+name+'.pro', /REMOVE_ALL), $
	count=ffcount)
  IF (ffcount gt 0) THEN BEGIN 
    files= thisfile(0)
    nr=1
    pos=-1
  ENDIF
  path=STRMID(path,pos+1,STRLEN(path))
ENDREP UNTIL (pos eq -1)

IF ((nr eq 1) and (not KEYWORD_SET(quiet))) THEN PRINT, files
file= files
count=nr

END
